package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1PersistentVolumeStatusBuilder extends V1PersistentVolumeStatusFluentImpl<V1PersistentVolumeStatusBuilder> implements VisitableBuilder<V1PersistentVolumeStatus,V1PersistentVolumeStatusBuilder>{

    V1PersistentVolumeStatusFluent<?> fluent;
    Boolean validationEnabled;

    public V1PersistentVolumeStatusBuilder(){
            this(true);
    }
    public V1PersistentVolumeStatusBuilder(Boolean validationEnabled){
            this(new V1PersistentVolumeStatus(), validationEnabled);
    }
    public V1PersistentVolumeStatusBuilder(V1PersistentVolumeStatusFluent<?> fluent){
            this(fluent, true);
    }
    public V1PersistentVolumeStatusBuilder(V1PersistentVolumeStatusFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1PersistentVolumeStatus(), validationEnabled);
    }
    public V1PersistentVolumeStatusBuilder(V1PersistentVolumeStatusFluent<?> fluent,V1PersistentVolumeStatus instance){
            this(fluent, instance, true);
    }
    public V1PersistentVolumeStatusBuilder(V1PersistentVolumeStatusFluent<?> fluent,V1PersistentVolumeStatus instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withMessage(instance.getMessage());

            fluent.withPhase(instance.getPhase());

            fluent.withReason(instance.getReason());

            this.validationEnabled = validationEnabled; 
    }
    public V1PersistentVolumeStatusBuilder(V1PersistentVolumeStatus instance){
            this(instance,true);
    }
    public V1PersistentVolumeStatusBuilder(V1PersistentVolumeStatus instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withMessage(instance.getMessage());

            this.withPhase(instance.getPhase());

            this.withReason(instance.getReason());

            this.validationEnabled = validationEnabled; 
    }

    public V1PersistentVolumeStatus build(){
            V1PersistentVolumeStatus buildable = new V1PersistentVolumeStatus();
            buildable.setMessage(fluent.getMessage());
            buildable.setPhase(fluent.getPhase());
            buildable.setReason(fluent.getReason());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1PersistentVolumeStatusBuilder that = (V1PersistentVolumeStatusBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
