package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class V1NetworkPolicyFluentImpl<A extends V1NetworkPolicyFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1NetworkPolicyFluent<A>{

    private String apiVersion;
    private String kind;
    private V1ObjectMetaBuilder metadata;
    private V1NetworkPolicySpecBuilder spec;

    public V1NetworkPolicyFluentImpl(){
    }
    public V1NetworkPolicyFluentImpl(V1NetworkPolicy instance){
            this.withApiVersion(instance.getApiVersion());

            this.withKind(instance.getKind());

            this.withMetadata(instance.getMetadata());

            this.withSpec(instance.getSpec());

    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion(){
            return this.apiVersion != null;
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public Boolean hasKind(){
            return this.kind != null;
    }

    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public V1ObjectMeta getMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public V1ObjectMeta buildMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(V1ObjectMeta metadata){
            _visitables.remove(this.metadata);
            if (metadata!=null){ this.metadata= new V1ObjectMetaBuilder(metadata); _visitables.add(this.metadata);} return (A) this;
    }

    public Boolean hasMetadata(){
            return this.metadata != null;
    }

    public V1NetworkPolicyFluent.MetadataNested<A> withNewMetadata(){
            return new MetadataNestedImpl();
    }

    public V1NetworkPolicyFluent.MetadataNested<A> withNewMetadataLike(V1ObjectMeta item){
            return new MetadataNestedImpl(item);
    }

    public V1NetworkPolicyFluent.MetadataNested<A> editMetadata(){
            return withNewMetadataLike(getMetadata());
    }

    public V1NetworkPolicyFluent.MetadataNested<A> editOrNewMetadata(){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): new V1ObjectMetaBuilder().build());
    }

    public V1NetworkPolicyFluent.MetadataNested<A> editOrNewMetadataLike(V1ObjectMeta item){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public V1NetworkPolicySpec getSpec(){
            return this.spec!=null?this.spec.build():null;
    }

    public V1NetworkPolicySpec buildSpec(){
            return this.spec!=null?this.spec.build():null;
    }

    public A withSpec(V1NetworkPolicySpec spec){
            _visitables.remove(this.spec);
            if (spec!=null){ this.spec= new V1NetworkPolicySpecBuilder(spec); _visitables.add(this.spec);} return (A) this;
    }

    public Boolean hasSpec(){
            return this.spec != null;
    }

    public V1NetworkPolicyFluent.SpecNested<A> withNewSpec(){
            return new SpecNestedImpl();
    }

    public V1NetworkPolicyFluent.SpecNested<A> withNewSpecLike(V1NetworkPolicySpec item){
            return new SpecNestedImpl(item);
    }

    public V1NetworkPolicyFluent.SpecNested<A> editSpec(){
            return withNewSpecLike(getSpec());
    }

    public V1NetworkPolicyFluent.SpecNested<A> editOrNewSpec(){
            return withNewSpecLike(getSpec() != null ? getSpec(): new V1NetworkPolicySpecBuilder().build());
    }

    public V1NetworkPolicyFluent.SpecNested<A> editOrNewSpecLike(V1NetworkPolicySpec item){
            return withNewSpecLike(getSpec() != null ? getSpec(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1NetworkPolicyFluentImpl that = (V1NetworkPolicyFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
            if (spec != null ? !spec.equals(that.spec) :that.spec != null) return false;
            return true;
    }


    public class MetadataNestedImpl<N> extends V1ObjectMetaFluentImpl<V1NetworkPolicyFluent.MetadataNested<N>> implements V1NetworkPolicyFluent.MetadataNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1ObjectMetaBuilder builder;
    
            MetadataNestedImpl(V1ObjectMeta item){
                    this.builder = new V1ObjectMetaBuilder(this, item);
            }
            MetadataNestedImpl(){
                    this.builder = new V1ObjectMetaBuilder(this);
            }
    
    public N and(){
            return (N) V1NetworkPolicyFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata(){
            return and();
    }

}
    public class SpecNestedImpl<N> extends V1NetworkPolicySpecFluentImpl<V1NetworkPolicyFluent.SpecNested<N>> implements V1NetworkPolicyFluent.SpecNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1NetworkPolicySpecBuilder builder;
    
            SpecNestedImpl(V1NetworkPolicySpec item){
                    this.builder = new V1NetworkPolicySpecBuilder(this, item);
            }
            SpecNestedImpl(){
                    this.builder = new V1NetworkPolicySpecBuilder(this);
            }
    
    public N and(){
            return (N) V1NetworkPolicyFluentImpl.this.withSpec(builder.build());
    }
    public N endSpec(){
            return and();
    }

}


}
