package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1NamespaceSpecBuilder extends V1NamespaceSpecFluentImpl<V1NamespaceSpecBuilder> implements VisitableBuilder<V1NamespaceSpec,V1NamespaceSpecBuilder>{

    V1NamespaceSpecFluent<?> fluent;
    Boolean validationEnabled;

    public V1NamespaceSpecBuilder(){
            this(true);
    }
    public V1NamespaceSpecBuilder(Boolean validationEnabled){
            this(new V1NamespaceSpec(), validationEnabled);
    }
    public V1NamespaceSpecBuilder(V1NamespaceSpecFluent<?> fluent){
            this(fluent, true);
    }
    public V1NamespaceSpecBuilder(V1NamespaceSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1NamespaceSpec(), validationEnabled);
    }
    public V1NamespaceSpecBuilder(V1NamespaceSpecFluent<?> fluent,V1NamespaceSpec instance){
            this(fluent, instance, true);
    }
    public V1NamespaceSpecBuilder(V1NamespaceSpecFluent<?> fluent,V1NamespaceSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withFinalizers(instance.getFinalizers());

            this.validationEnabled = validationEnabled; 
    }
    public V1NamespaceSpecBuilder(V1NamespaceSpec instance){
            this(instance,true);
    }
    public V1NamespaceSpecBuilder(V1NamespaceSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withFinalizers(instance.getFinalizers());

            this.validationEnabled = validationEnabled; 
    }

    public V1NamespaceSpec build(){
            V1NamespaceSpec buildable = new V1NamespaceSpec();
            buildable.setFinalizers(fluent.getFinalizers());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1NamespaceSpecBuilder that = (V1NamespaceSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
