package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1ListMetaBuilder extends V1ListMetaFluentImpl<V1ListMetaBuilder> implements VisitableBuilder<V1ListMeta,V1ListMetaBuilder>{

    V1ListMetaFluent<?> fluent;
    Boolean validationEnabled;

    public V1ListMetaBuilder(){
            this(true);
    }
    public V1ListMetaBuilder(Boolean validationEnabled){
            this(new V1ListMeta(), validationEnabled);
    }
    public V1ListMetaBuilder(V1ListMetaFluent<?> fluent){
            this(fluent, true);
    }
    public V1ListMetaBuilder(V1ListMetaFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1ListMeta(), validationEnabled);
    }
    public V1ListMetaBuilder(V1ListMetaFluent<?> fluent,V1ListMeta instance){
            this(fluent, instance, true);
    }
    public V1ListMetaBuilder(V1ListMetaFluent<?> fluent,V1ListMeta instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withContinue(instance.getContinue());

            fluent.withResourceVersion(instance.getResourceVersion());

            fluent.withSelfLink(instance.getSelfLink());

            this.validationEnabled = validationEnabled; 
    }
    public V1ListMetaBuilder(V1ListMeta instance){
            this(instance,true);
    }
    public V1ListMetaBuilder(V1ListMeta instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withContinue(instance.getContinue());

            this.withResourceVersion(instance.getResourceVersion());

            this.withSelfLink(instance.getSelfLink());

            this.validationEnabled = validationEnabled; 
    }

    public V1ListMeta build(){
            V1ListMeta buildable = new V1ListMeta();
            buildable.setContinue(fluent.getContinue());
            buildable.setResourceVersion(fluent.getResourceVersion());
            buildable.setSelfLink(fluent.getSelfLink());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1ListMetaBuilder that = (V1ListMetaBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
