package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Fluent;
import io.kubernetes.client.fluent.Nested;
import java.lang.String;
import java.lang.Integer;
import java.lang.Deprecated;
import java.lang.Long;
import java.lang.Boolean;

public interface V1JobSpecFluent<A extends V1JobSpecFluent<A>> extends Fluent<A>{


    public Long getActiveDeadlineSeconds();
    public A withActiveDeadlineSeconds(Long activeDeadlineSeconds);
    public Boolean hasActiveDeadlineSeconds();
    public A withNewActiveDeadlineSeconds(String arg1);
    public A withNewActiveDeadlineSeconds(long arg1);
    public Integer getBackoffLimit();
    public A withBackoffLimit(Integer backoffLimit);
    public Boolean hasBackoffLimit();
    public A withNewBackoffLimit(int arg1);
    public A withNewBackoffLimit(String arg1);
    public Integer getCompletions();
    public A withCompletions(Integer completions);
    public Boolean hasCompletions();
    public A withNewCompletions(int arg1);
    public A withNewCompletions(String arg1);
    public Boolean isManualSelector();
    public A withManualSelector(Boolean manualSelector);
    public Boolean hasManualSelector();
    public A withNewManualSelector(boolean arg1);
    public A withNewManualSelector(String arg1);
    public Integer getParallelism();
    public A withParallelism(Integer parallelism);
    public Boolean hasParallelism();
    public A withNewParallelism(int arg1);
    public A withNewParallelism(String arg1);
    
/**
 * This method has been deprecated, please use method buildSelector instead.
 * @return The buildable object.
 */
@Deprecated public V1LabelSelector getSelector();
    public V1LabelSelector buildSelector();
    public A withSelector(V1LabelSelector selector);
    public Boolean hasSelector();
    public V1JobSpecFluent.SelectorNested<A> withNewSelector();
    public V1JobSpecFluent.SelectorNested<A> withNewSelectorLike(V1LabelSelector item);
    public V1JobSpecFluent.SelectorNested<A> editSelector();
    public V1JobSpecFluent.SelectorNested<A> editOrNewSelector();
    public V1JobSpecFluent.SelectorNested<A> editOrNewSelectorLike(V1LabelSelector item);
    
/**
 * This method has been deprecated, please use method buildTemplate instead.
 * @return The buildable object.
 */
@Deprecated public V1PodTemplateSpec getTemplate();
    public V1PodTemplateSpec buildTemplate();
    public A withTemplate(V1PodTemplateSpec template);
    public Boolean hasTemplate();
    public V1JobSpecFluent.TemplateNested<A> withNewTemplate();
    public V1JobSpecFluent.TemplateNested<A> withNewTemplateLike(V1PodTemplateSpec item);
    public V1JobSpecFluent.TemplateNested<A> editTemplate();
    public V1JobSpecFluent.TemplateNested<A> editOrNewTemplate();
    public V1JobSpecFluent.TemplateNested<A> editOrNewTemplateLike(V1PodTemplateSpec item);

    public interface SelectorNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1LabelSelectorFluent<V1JobSpecFluent.SelectorNested<N>>{

        
    public N and();    public N endSelector();
}
    public interface TemplateNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1PodTemplateSpecFluent<V1JobSpecFluent.TemplateNested<N>>{

        
    public N and();    public N endTemplate();
}


}
