package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Fluent;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import io.kubernetes.client.fluent.Predicate;
import java.lang.Deprecated;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;

public interface V1InitializersFluent<A extends V1InitializersFluent<A>> extends Fluent<A>{


    public A addToPending(int index,V1Initializer item);
    public A setToPending(int index,V1Initializer item);
    public A addToPending(V1Initializer... items);
    public A addAllToPending(Collection<V1Initializer> items);
    public A removeFromPending(V1Initializer... items);
    public A removeAllFromPending(Collection<V1Initializer> items);
    
/**
 * This method has been deprecated, please use method buildPending instead.
 * @return The buildable object.
 */
@Deprecated public List<V1Initializer> getPending();
    public List<V1Initializer> buildPending();
    public V1Initializer buildPending(int index);
    public V1Initializer buildFirstPending();
    public V1Initializer buildLastPending();
    public V1Initializer buildMatchingPending(io.kubernetes.client.fluent.Predicate<V1InitializerBuilder> predicate);
    public A withPending(List<V1Initializer> pending);
    public A withPending(V1Initializer... pending);
    public Boolean hasPending();
    public V1InitializersFluent.PendingNested<A> addNewPending();
    public V1InitializersFluent.PendingNested<A> addNewPendingLike(V1Initializer item);
    public V1InitializersFluent.PendingNested<A> setNewPendingLike(int index,V1Initializer item);
    public V1InitializersFluent.PendingNested<A> editPending(int index);
    public V1InitializersFluent.PendingNested<A> editFirstPending();
    public V1InitializersFluent.PendingNested<A> editLastPending();
    public V1InitializersFluent.PendingNested<A> editMatchingPending(io.kubernetes.client.fluent.Predicate<V1InitializerBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildResult instead.
 * @return The buildable object.
 */
@Deprecated public V1Status getResult();
    public V1Status buildResult();
    public A withResult(V1Status result);
    public Boolean hasResult();
    public V1InitializersFluent.ResultNested<A> withNewResult();
    public V1InitializersFluent.ResultNested<A> withNewResultLike(V1Status item);
    public V1InitializersFluent.ResultNested<A> editResult();
    public V1InitializersFluent.ResultNested<A> editOrNewResult();
    public V1InitializersFluent.ResultNested<A> editOrNewResultLike(V1Status item);

    public interface PendingNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1InitializerFluent<V1InitializersFluent.PendingNested<N>>{

        
    public N and();    public N endPending();
}
    public interface ResultNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1StatusFluent<V1InitializersFluent.ResultNested<N>>{

        
    public N and();    public N endResult();
}


}
