package io.kubernetes.client.models;

import io.kubernetes.client.custom.IntOrString;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Fluent;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.kubernetes.client.fluent.Predicate;
import java.lang.Deprecated;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;

public interface V1HTTPGetActionFluent<A extends V1HTTPGetActionFluent<A>> extends Fluent<A>{


    public String getHost();
    public A withHost(String host);
    public Boolean hasHost();
    public A addToHttpHeaders(int index,V1HTTPHeader item);
    public A setToHttpHeaders(int index,V1HTTPHeader item);
    public A addToHttpHeaders(V1HTTPHeader... items);
    public A addAllToHttpHeaders(Collection<V1HTTPHeader> items);
    public A removeFromHttpHeaders(V1HTTPHeader... items);
    public A removeAllFromHttpHeaders(Collection<V1HTTPHeader> items);
    
/**
 * This method has been deprecated, please use method buildHttpHeaders instead.
 * @return The buildable object.
 */
@Deprecated public List<V1HTTPHeader> getHttpHeaders();
    public List<V1HTTPHeader> buildHttpHeaders();
    public V1HTTPHeader buildHttpHeader(int index);
    public V1HTTPHeader buildFirstHttpHeader();
    public V1HTTPHeader buildLastHttpHeader();
    public V1HTTPHeader buildMatchingHttpHeader(io.kubernetes.client.fluent.Predicate<V1HTTPHeaderBuilder> predicate);
    public A withHttpHeaders(List<V1HTTPHeader> httpHeaders);
    public A withHttpHeaders(V1HTTPHeader... httpHeaders);
    public Boolean hasHttpHeaders();
    public V1HTTPGetActionFluent.HttpHeadersNested<A> addNewHttpHeader();
    public V1HTTPGetActionFluent.HttpHeadersNested<A> addNewHttpHeaderLike(V1HTTPHeader item);
    public V1HTTPGetActionFluent.HttpHeadersNested<A> setNewHttpHeaderLike(int index,V1HTTPHeader item);
    public V1HTTPGetActionFluent.HttpHeadersNested<A> editHttpHeader(int index);
    public V1HTTPGetActionFluent.HttpHeadersNested<A> editFirstHttpHeader();
    public V1HTTPGetActionFluent.HttpHeadersNested<A> editLastHttpHeader();
    public V1HTTPGetActionFluent.HttpHeadersNested<A> editMatchingHttpHeader(io.kubernetes.client.fluent.Predicate<V1HTTPHeaderBuilder> predicate);
    public String getPath();
    public A withPath(String path);
    public Boolean hasPath();
    public IntOrString getPort();
    public A withPort(IntOrString port);
    public Boolean hasPort();
    public A withNewPort(final String value);
    public A withNewPort(final int value);
    public String getScheme();
    public A withScheme(String scheme);
    public Boolean hasScheme();

    public interface HttpHeadersNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1HTTPHeaderFluent<V1HTTPGetActionFluent.HttpHeadersNested<N>>{

        
    public N and();    public N endHttpHeader();
}


}
