package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1EventSeriesBuilder extends V1EventSeriesFluentImpl<V1EventSeriesBuilder> implements VisitableBuilder<V1EventSeries,V1EventSeriesBuilder>{

    V1EventSeriesFluent<?> fluent;
    Boolean validationEnabled;

    public V1EventSeriesBuilder(){
            this(true);
    }
    public V1EventSeriesBuilder(Boolean validationEnabled){
            this(new V1EventSeries(), validationEnabled);
    }
    public V1EventSeriesBuilder(V1EventSeriesFluent<?> fluent){
            this(fluent, true);
    }
    public V1EventSeriesBuilder(V1EventSeriesFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1EventSeries(), validationEnabled);
    }
    public V1EventSeriesBuilder(V1EventSeriesFluent<?> fluent,V1EventSeries instance){
            this(fluent, instance, true);
    }
    public V1EventSeriesBuilder(V1EventSeriesFluent<?> fluent,V1EventSeries instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withCount(instance.getCount());

            fluent.withLastObservedTime(instance.getLastObservedTime());

            fluent.withState(instance.getState());

            this.validationEnabled = validationEnabled; 
    }
    public V1EventSeriesBuilder(V1EventSeries instance){
            this(instance,true);
    }
    public V1EventSeriesBuilder(V1EventSeries instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withCount(instance.getCount());

            this.withLastObservedTime(instance.getLastObservedTime());

            this.withState(instance.getState());

            this.validationEnabled = validationEnabled; 
    }

    public V1EventSeries build(){
            V1EventSeries buildable = new V1EventSeries();
            buildable.setCount(fluent.getCount());
            buildable.setLastObservedTime(fluent.getLastObservedTime());
            buildable.setState(fluent.getState());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1EventSeriesBuilder that = (V1EventSeriesBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
