package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.lang.String;
import org.joda.time.DateTime;
import java.lang.Deprecated;
import java.lang.Boolean;
import io.kubernetes.client.fluent.Fluent;
import java.lang.Integer;
import java.lang.Object;

public interface V1EventFluent<A extends V1EventFluent<A>> extends Fluent<A>{


    public String getAction();
    public A withAction(String action);
    public Boolean hasAction();
    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public Integer getCount();
    public A withCount(Integer count);
    public Boolean hasCount();
    public A withNewCount(int arg1);
    public A withNewCount(String arg1);
    public DateTime getEventTime();
    public A withEventTime(DateTime eventTime);
    public Boolean hasEventTime();
    public A withNewEventTime(int arg0,int arg1,int arg2,int arg3,int arg4);
    public A withNewEventTime(long arg0);
    public A withNewEventTime(Object arg0);
    public DateTime getFirstTimestamp();
    public A withFirstTimestamp(DateTime firstTimestamp);
    public Boolean hasFirstTimestamp();
    public A withNewFirstTimestamp(int arg0,int arg1,int arg2,int arg3,int arg4);
    public A withNewFirstTimestamp(long arg0);
    public A withNewFirstTimestamp(Object arg0);
    
/**
 * This method has been deprecated, please use method buildInvolvedObject instead.
 * @return The buildable object.
 */
@Deprecated public V1ObjectReference getInvolvedObject();
    public V1ObjectReference buildInvolvedObject();
    public A withInvolvedObject(V1ObjectReference involvedObject);
    public Boolean hasInvolvedObject();
    public V1EventFluent.InvolvedObjectNested<A> withNewInvolvedObject();
    public V1EventFluent.InvolvedObjectNested<A> withNewInvolvedObjectLike(V1ObjectReference item);
    public V1EventFluent.InvolvedObjectNested<A> editInvolvedObject();
    public V1EventFluent.InvolvedObjectNested<A> editOrNewInvolvedObject();
    public V1EventFluent.InvolvedObjectNested<A> editOrNewInvolvedObjectLike(V1ObjectReference item);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public DateTime getLastTimestamp();
    public A withLastTimestamp(DateTime lastTimestamp);
    public Boolean hasLastTimestamp();
    public A withNewLastTimestamp(int arg0,int arg1,int arg2,int arg3,int arg4);
    public A withNewLastTimestamp(long arg0);
    public A withNewLastTimestamp(Object arg0);
    public String getMessage();
    public A withMessage(String message);
    public Boolean hasMessage();
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public V1ObjectMeta getMetadata();
    public V1ObjectMeta buildMetadata();
    public A withMetadata(V1ObjectMeta metadata);
    public Boolean hasMetadata();
    public V1EventFluent.MetadataNested<A> withNewMetadata();
    public V1EventFluent.MetadataNested<A> withNewMetadataLike(V1ObjectMeta item);
    public V1EventFluent.MetadataNested<A> editMetadata();
    public V1EventFluent.MetadataNested<A> editOrNewMetadata();
    public V1EventFluent.MetadataNested<A> editOrNewMetadataLike(V1ObjectMeta item);
    public String getReason();
    public A withReason(String reason);
    public Boolean hasReason();
    
/**
 * This method has been deprecated, please use method buildRelated instead.
 * @return The buildable object.
 */
@Deprecated public V1ObjectReference getRelated();
    public V1ObjectReference buildRelated();
    public A withRelated(V1ObjectReference related);
    public Boolean hasRelated();
    public V1EventFluent.RelatedNested<A> withNewRelated();
    public V1EventFluent.RelatedNested<A> withNewRelatedLike(V1ObjectReference item);
    public V1EventFluent.RelatedNested<A> editRelated();
    public V1EventFluent.RelatedNested<A> editOrNewRelated();
    public V1EventFluent.RelatedNested<A> editOrNewRelatedLike(V1ObjectReference item);
    public String getReportingComponent();
    public A withReportingComponent(String reportingComponent);
    public Boolean hasReportingComponent();
    public String getReportingInstance();
    public A withReportingInstance(String reportingInstance);
    public Boolean hasReportingInstance();
    
/**
 * This method has been deprecated, please use method buildSeries instead.
 * @return The buildable object.
 */
@Deprecated public V1EventSeries getSeries();
    public V1EventSeries buildSeries();
    public A withSeries(V1EventSeries series);
    public Boolean hasSeries();
    public V1EventFluent.SeriesNested<A> withNewSeries();
    public V1EventFluent.SeriesNested<A> withNewSeriesLike(V1EventSeries item);
    public V1EventFluent.SeriesNested<A> editSeries();
    public V1EventFluent.SeriesNested<A> editOrNewSeries();
    public V1EventFluent.SeriesNested<A> editOrNewSeriesLike(V1EventSeries item);
    
/**
 * This method has been deprecated, please use method buildSource instead.
 * @return The buildable object.
 */
@Deprecated public V1EventSource getSource();
    public V1EventSource buildSource();
    public A withSource(V1EventSource source);
    public Boolean hasSource();
    public V1EventFluent.SourceNested<A> withNewSource();
    public V1EventFluent.SourceNested<A> withNewSourceLike(V1EventSource item);
    public V1EventFluent.SourceNested<A> editSource();
    public V1EventFluent.SourceNested<A> editOrNewSource();
    public V1EventFluent.SourceNested<A> editOrNewSourceLike(V1EventSource item);
    public String getType();
    public A withType(String type);
    public Boolean hasType();

    public interface InvolvedObjectNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1ObjectReferenceFluent<V1EventFluent.InvolvedObjectNested<N>>{

        
    public N and();    public N endInvolvedObject();
}
    public interface MetadataNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1ObjectMetaFluent<V1EventFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface RelatedNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1ObjectReferenceFluent<V1EventFluent.RelatedNested<N>>{

        
    public N and();    public N endRelated();
}
    public interface SeriesNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1EventSeriesFluent<V1EventFluent.SeriesNested<N>>{

        
    public N and();    public N endSeries();
}
    public interface SourceNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1EventSourceFluent<V1EventFluent.SourceNested<N>>{

        
    public N and();    public N endSource();
}


}
