package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1DeleteOptionsBuilder extends V1DeleteOptionsFluentImpl<V1DeleteOptionsBuilder> implements VisitableBuilder<V1DeleteOptions,V1DeleteOptionsBuilder>{

    V1DeleteOptionsFluent<?> fluent;
    Boolean validationEnabled;

    public V1DeleteOptionsBuilder(){
            this(true);
    }
    public V1DeleteOptionsBuilder(Boolean validationEnabled){
            this(new V1DeleteOptions(), validationEnabled);
    }
    public V1DeleteOptionsBuilder(V1DeleteOptionsFluent<?> fluent){
            this(fluent, true);
    }
    public V1DeleteOptionsBuilder(V1DeleteOptionsFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1DeleteOptions(), validationEnabled);
    }
    public V1DeleteOptionsBuilder(V1DeleteOptionsFluent<?> fluent,V1DeleteOptions instance){
            this(fluent, instance, true);
    }
    public V1DeleteOptionsBuilder(V1DeleteOptionsFluent<?> fluent,V1DeleteOptions instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion());

            fluent.withGracePeriodSeconds(instance.getGracePeriodSeconds());

            fluent.withKind(instance.getKind());

            fluent.withOrphanDependents(instance.isOrphanDependents());

            fluent.withPreconditions(instance.getPreconditions());

            fluent.withPropagationPolicy(instance.getPropagationPolicy());

            this.validationEnabled = validationEnabled; 
    }
    public V1DeleteOptionsBuilder(V1DeleteOptions instance){
            this(instance,true);
    }
    public V1DeleteOptionsBuilder(V1DeleteOptions instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion());

            this.withGracePeriodSeconds(instance.getGracePeriodSeconds());

            this.withKind(instance.getKind());

            this.withOrphanDependents(instance.isOrphanDependents());

            this.withPreconditions(instance.getPreconditions());

            this.withPropagationPolicy(instance.getPropagationPolicy());

            this.validationEnabled = validationEnabled; 
    }

    public V1DeleteOptions build(){
            V1DeleteOptions buildable = new V1DeleteOptions();
            buildable.setApiVersion(fluent.getApiVersion());
            buildable.setGracePeriodSeconds(fluent.getGracePeriodSeconds());
            buildable.setKind(fluent.getKind());
            buildable.setOrphanDependents(fluent.isOrphanDependents());
            buildable.setPreconditions(fluent.getPreconditions());
            buildable.setPropagationPolicy(fluent.getPropagationPolicy());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1DeleteOptionsBuilder that = (V1DeleteOptionsBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
