package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Fluent;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.kubernetes.client.fluent.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;

public interface V1DaemonSetStatusFluent<A extends V1DaemonSetStatusFluent<A>> extends Fluent<A>{


    public Integer getCollisionCount();
    public A withCollisionCount(Integer collisionCount);
    public Boolean hasCollisionCount();
    public A withNewCollisionCount(int arg1);
    public A withNewCollisionCount(String arg1);
    public A addToConditions(int index,V1DaemonSetCondition item);
    public A setToConditions(int index,V1DaemonSetCondition item);
    public A addToConditions(V1DaemonSetCondition... items);
    public A addAllToConditions(Collection<V1DaemonSetCondition> items);
    public A removeFromConditions(V1DaemonSetCondition... items);
    public A removeAllFromConditions(Collection<V1DaemonSetCondition> items);
    
/**
 * This method has been deprecated, please use method buildConditions instead.
 * @return The buildable object.
 */
@Deprecated public List<V1DaemonSetCondition> getConditions();
    public List<V1DaemonSetCondition> buildConditions();
    public V1DaemonSetCondition buildCondition(int index);
    public V1DaemonSetCondition buildFirstCondition();
    public V1DaemonSetCondition buildLastCondition();
    public V1DaemonSetCondition buildMatchingCondition(io.kubernetes.client.fluent.Predicate<V1DaemonSetConditionBuilder> predicate);
    public A withConditions(List<V1DaemonSetCondition> conditions);
    public A withConditions(V1DaemonSetCondition... conditions);
    public Boolean hasConditions();
    public V1DaemonSetStatusFluent.ConditionsNested<A> addNewCondition();
    public V1DaemonSetStatusFluent.ConditionsNested<A> addNewConditionLike(V1DaemonSetCondition item);
    public V1DaemonSetStatusFluent.ConditionsNested<A> setNewConditionLike(int index,V1DaemonSetCondition item);
    public V1DaemonSetStatusFluent.ConditionsNested<A> editCondition(int index);
    public V1DaemonSetStatusFluent.ConditionsNested<A> editFirstCondition();
    public V1DaemonSetStatusFluent.ConditionsNested<A> editLastCondition();
    public V1DaemonSetStatusFluent.ConditionsNested<A> editMatchingCondition(io.kubernetes.client.fluent.Predicate<V1DaemonSetConditionBuilder> predicate);
    public Integer getCurrentNumberScheduled();
    public A withCurrentNumberScheduled(Integer currentNumberScheduled);
    public Boolean hasCurrentNumberScheduled();
    public A withNewCurrentNumberScheduled(int arg1);
    public A withNewCurrentNumberScheduled(String arg1);
    public Integer getDesiredNumberScheduled();
    public A withDesiredNumberScheduled(Integer desiredNumberScheduled);
    public Boolean hasDesiredNumberScheduled();
    public A withNewDesiredNumberScheduled(int arg1);
    public A withNewDesiredNumberScheduled(String arg1);
    public Integer getNumberAvailable();
    public A withNumberAvailable(Integer numberAvailable);
    public Boolean hasNumberAvailable();
    public A withNewNumberAvailable(int arg1);
    public A withNewNumberAvailable(String arg1);
    public Integer getNumberMisscheduled();
    public A withNumberMisscheduled(Integer numberMisscheduled);
    public Boolean hasNumberMisscheduled();
    public A withNewNumberMisscheduled(int arg1);
    public A withNewNumberMisscheduled(String arg1);
    public Integer getNumberReady();
    public A withNumberReady(Integer numberReady);
    public Boolean hasNumberReady();
    public A withNewNumberReady(int arg1);
    public A withNewNumberReady(String arg1);
    public Integer getNumberUnavailable();
    public A withNumberUnavailable(Integer numberUnavailable);
    public Boolean hasNumberUnavailable();
    public A withNewNumberUnavailable(int arg1);
    public A withNewNumberUnavailable(String arg1);
    public Long getObservedGeneration();
    public A withObservedGeneration(Long observedGeneration);
    public Boolean hasObservedGeneration();
    public A withNewObservedGeneration(String arg1);
    public A withNewObservedGeneration(long arg1);
    public Integer getUpdatedNumberScheduled();
    public A withUpdatedNumberScheduled(Integer updatedNumberScheduled);
    public Boolean hasUpdatedNumberScheduled();
    public A withNewUpdatedNumberScheduled(int arg1);
    public A withNewUpdatedNumberScheduled(String arg1);

    public interface ConditionsNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1DaemonSetConditionFluent<V1DaemonSetStatusFluent.ConditionsNested<N>>{

        
    public N and();    public N endCondition();
}


}
