package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class PolicyV1beta1RunAsUserStrategyOptionsBuilder extends PolicyV1beta1RunAsUserStrategyOptionsFluentImpl<PolicyV1beta1RunAsUserStrategyOptionsBuilder> implements VisitableBuilder<PolicyV1beta1RunAsUserStrategyOptions,PolicyV1beta1RunAsUserStrategyOptionsBuilder>{

    PolicyV1beta1RunAsUserStrategyOptionsFluent<?> fluent;
    Boolean validationEnabled;

    public PolicyV1beta1RunAsUserStrategyOptionsBuilder(){
            this(true);
    }
    public PolicyV1beta1RunAsUserStrategyOptionsBuilder(Boolean validationEnabled){
            this(new PolicyV1beta1RunAsUserStrategyOptions(), validationEnabled);
    }
    public PolicyV1beta1RunAsUserStrategyOptionsBuilder(PolicyV1beta1RunAsUserStrategyOptionsFluent<?> fluent){
            this(fluent, true);
    }
    public PolicyV1beta1RunAsUserStrategyOptionsBuilder(PolicyV1beta1RunAsUserStrategyOptionsFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new PolicyV1beta1RunAsUserStrategyOptions(), validationEnabled);
    }
    public PolicyV1beta1RunAsUserStrategyOptionsBuilder(PolicyV1beta1RunAsUserStrategyOptionsFluent<?> fluent,PolicyV1beta1RunAsUserStrategyOptions instance){
            this(fluent, instance, true);
    }
    public PolicyV1beta1RunAsUserStrategyOptionsBuilder(PolicyV1beta1RunAsUserStrategyOptionsFluent<?> fluent,PolicyV1beta1RunAsUserStrategyOptions instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withRanges(instance.getRanges());

            fluent.withRule(instance.getRule());

            this.validationEnabled = validationEnabled; 
    }
    public PolicyV1beta1RunAsUserStrategyOptionsBuilder(PolicyV1beta1RunAsUserStrategyOptions instance){
            this(instance,true);
    }
    public PolicyV1beta1RunAsUserStrategyOptionsBuilder(PolicyV1beta1RunAsUserStrategyOptions instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withRanges(instance.getRanges());

            this.withRule(instance.getRule());

            this.validationEnabled = validationEnabled; 
    }

    public PolicyV1beta1RunAsUserStrategyOptions build(){
            PolicyV1beta1RunAsUserStrategyOptions buildable = new PolicyV1beta1RunAsUserStrategyOptions();
            buildable.setRanges(fluent.getRanges());
            buildable.setRule(fluent.getRule());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            PolicyV1beta1RunAsUserStrategyOptionsBuilder that = (PolicyV1beta1RunAsUserStrategyOptionsBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
