package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.lang.Boolean;
import java.lang.Object;

public class ExtensionsV1beta1ScaleFluentImpl<A extends ExtensionsV1beta1ScaleFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements ExtensionsV1beta1ScaleFluent<A>{

    private String apiVersion;
    private String kind;
    private V1ObjectMetaBuilder metadata;
    private ExtensionsV1beta1ScaleSpecBuilder spec;
    private ExtensionsV1beta1ScaleStatusBuilder status;

    public ExtensionsV1beta1ScaleFluentImpl(){
    }
    public ExtensionsV1beta1ScaleFluentImpl(ExtensionsV1beta1Scale instance){
            this.withApiVersion(instance.getApiVersion());

            this.withKind(instance.getKind());

            this.withMetadata(instance.getMetadata());

            this.withSpec(instance.getSpec());

            this.withStatus(instance.getStatus());

    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion(){
            return this.apiVersion != null;
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public Boolean hasKind(){
            return this.kind != null;
    }

    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public V1ObjectMeta getMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public V1ObjectMeta buildMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(V1ObjectMeta metadata){
            _visitables.remove(this.metadata);
            if (metadata!=null){ this.metadata= new V1ObjectMetaBuilder(metadata); _visitables.add(this.metadata);} return (A) this;
    }

    public Boolean hasMetadata(){
            return this.metadata != null;
    }

    public ExtensionsV1beta1ScaleFluent.MetadataNested<A> withNewMetadata(){
            return new MetadataNestedImpl();
    }

    public ExtensionsV1beta1ScaleFluent.MetadataNested<A> withNewMetadataLike(V1ObjectMeta item){
            return new MetadataNestedImpl(item);
    }

    public ExtensionsV1beta1ScaleFluent.MetadataNested<A> editMetadata(){
            return withNewMetadataLike(getMetadata());
    }

    public ExtensionsV1beta1ScaleFluent.MetadataNested<A> editOrNewMetadata(){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): new V1ObjectMetaBuilder().build());
    }

    public ExtensionsV1beta1ScaleFluent.MetadataNested<A> editOrNewMetadataLike(V1ObjectMeta item){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public ExtensionsV1beta1ScaleSpec getSpec(){
            return this.spec!=null?this.spec.build():null;
    }

    public ExtensionsV1beta1ScaleSpec buildSpec(){
            return this.spec!=null?this.spec.build():null;
    }

    public A withSpec(ExtensionsV1beta1ScaleSpec spec){
            _visitables.remove(this.spec);
            if (spec!=null){ this.spec= new ExtensionsV1beta1ScaleSpecBuilder(spec); _visitables.add(this.spec);} return (A) this;
    }

    public Boolean hasSpec(){
            return this.spec != null;
    }

    public ExtensionsV1beta1ScaleFluent.SpecNested<A> withNewSpec(){
            return new SpecNestedImpl();
    }

    public ExtensionsV1beta1ScaleFluent.SpecNested<A> withNewSpecLike(ExtensionsV1beta1ScaleSpec item){
            return new SpecNestedImpl(item);
    }

    public ExtensionsV1beta1ScaleFluent.SpecNested<A> editSpec(){
            return withNewSpecLike(getSpec());
    }

    public ExtensionsV1beta1ScaleFluent.SpecNested<A> editOrNewSpec(){
            return withNewSpecLike(getSpec() != null ? getSpec(): new ExtensionsV1beta1ScaleSpecBuilder().build());
    }

    public ExtensionsV1beta1ScaleFluent.SpecNested<A> editOrNewSpecLike(ExtensionsV1beta1ScaleSpec item){
            return withNewSpecLike(getSpec() != null ? getSpec(): item);
    }

    
/**
 * This method has been deprecated, please use method buildStatus instead.
 * @return The buildable object.
 */
@Deprecated public ExtensionsV1beta1ScaleStatus getStatus(){
            return this.status!=null?this.status.build():null;
    }

    public ExtensionsV1beta1ScaleStatus buildStatus(){
            return this.status!=null?this.status.build():null;
    }

    public A withStatus(ExtensionsV1beta1ScaleStatus status){
            _visitables.remove(this.status);
            if (status!=null){ this.status= new ExtensionsV1beta1ScaleStatusBuilder(status); _visitables.add(this.status);} return (A) this;
    }

    public Boolean hasStatus(){
            return this.status != null;
    }

    public ExtensionsV1beta1ScaleFluent.StatusNested<A> withNewStatus(){
            return new StatusNestedImpl();
    }

    public ExtensionsV1beta1ScaleFluent.StatusNested<A> withNewStatusLike(ExtensionsV1beta1ScaleStatus item){
            return new StatusNestedImpl(item);
    }

    public ExtensionsV1beta1ScaleFluent.StatusNested<A> editStatus(){
            return withNewStatusLike(getStatus());
    }

    public ExtensionsV1beta1ScaleFluent.StatusNested<A> editOrNewStatus(){
            return withNewStatusLike(getStatus() != null ? getStatus(): new ExtensionsV1beta1ScaleStatusBuilder().build());
    }

    public ExtensionsV1beta1ScaleFluent.StatusNested<A> editOrNewStatusLike(ExtensionsV1beta1ScaleStatus item){
            return withNewStatusLike(getStatus() != null ? getStatus(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ExtensionsV1beta1ScaleFluentImpl that = (ExtensionsV1beta1ScaleFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
            if (spec != null ? !spec.equals(that.spec) :that.spec != null) return false;
            if (status != null ? !status.equals(that.status) :that.status != null) return false;
            return true;
    }


    public class MetadataNestedImpl<N> extends V1ObjectMetaFluentImpl<ExtensionsV1beta1ScaleFluent.MetadataNested<N>> implements ExtensionsV1beta1ScaleFluent.MetadataNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1ObjectMetaBuilder builder;
    
            MetadataNestedImpl(V1ObjectMeta item){
                    this.builder = new V1ObjectMetaBuilder(this, item);
            }
            MetadataNestedImpl(){
                    this.builder = new V1ObjectMetaBuilder(this);
            }
    
    public N and(){
            return (N) ExtensionsV1beta1ScaleFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata(){
            return and();
    }

}
    public class SpecNestedImpl<N> extends ExtensionsV1beta1ScaleSpecFluentImpl<ExtensionsV1beta1ScaleFluent.SpecNested<N>> implements ExtensionsV1beta1ScaleFluent.SpecNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final ExtensionsV1beta1ScaleSpecBuilder builder;
    
            SpecNestedImpl(ExtensionsV1beta1ScaleSpec item){
                    this.builder = new ExtensionsV1beta1ScaleSpecBuilder(this, item);
            }
            SpecNestedImpl(){
                    this.builder = new ExtensionsV1beta1ScaleSpecBuilder(this);
            }
    
    public N and(){
            return (N) ExtensionsV1beta1ScaleFluentImpl.this.withSpec(builder.build());
    }
    public N endSpec(){
            return and();
    }

}
    public class StatusNestedImpl<N> extends ExtensionsV1beta1ScaleStatusFluentImpl<ExtensionsV1beta1ScaleFluent.StatusNested<N>> implements ExtensionsV1beta1ScaleFluent.StatusNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final ExtensionsV1beta1ScaleStatusBuilder builder;
    
            StatusNestedImpl(ExtensionsV1beta1ScaleStatus item){
                    this.builder = new ExtensionsV1beta1ScaleStatusBuilder(this, item);
            }
            StatusNestedImpl(){
                    this.builder = new ExtensionsV1beta1ScaleStatusBuilder(this);
            }
    
    public N and(){
            return (N) ExtensionsV1beta1ScaleFluentImpl.this.withStatus(builder.build());
    }
    public N endStatus(){
            return and();
    }

}


}
