package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class AppsV1beta1ScaleBuilder extends AppsV1beta1ScaleFluentImpl<AppsV1beta1ScaleBuilder> implements VisitableBuilder<AppsV1beta1Scale,AppsV1beta1ScaleBuilder>{

    AppsV1beta1ScaleFluent<?> fluent;
    Boolean validationEnabled;

    public AppsV1beta1ScaleBuilder(){
            this(true);
    }
    public AppsV1beta1ScaleBuilder(Boolean validationEnabled){
            this(new AppsV1beta1Scale(), validationEnabled);
    }
    public AppsV1beta1ScaleBuilder(AppsV1beta1ScaleFluent<?> fluent){
            this(fluent, true);
    }
    public AppsV1beta1ScaleBuilder(AppsV1beta1ScaleFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new AppsV1beta1Scale(), validationEnabled);
    }
    public AppsV1beta1ScaleBuilder(AppsV1beta1ScaleFluent<?> fluent,AppsV1beta1Scale instance){
            this(fluent, instance, true);
    }
    public AppsV1beta1ScaleBuilder(AppsV1beta1ScaleFluent<?> fluent,AppsV1beta1Scale instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion());

            fluent.withKind(instance.getKind());

            fluent.withMetadata(instance.getMetadata());

            fluent.withSpec(instance.getSpec());

            fluent.withStatus(instance.getStatus());

            this.validationEnabled = validationEnabled; 
    }
    public AppsV1beta1ScaleBuilder(AppsV1beta1Scale instance){
            this(instance,true);
    }
    public AppsV1beta1ScaleBuilder(AppsV1beta1Scale instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion());

            this.withKind(instance.getKind());

            this.withMetadata(instance.getMetadata());

            this.withSpec(instance.getSpec());

            this.withStatus(instance.getStatus());

            this.validationEnabled = validationEnabled; 
    }

    public AppsV1beta1Scale build(){
            AppsV1beta1Scale buildable = new AppsV1beta1Scale();
            buildable.setApiVersion(fluent.getApiVersion());
            buildable.setKind(fluent.getKind());
            buildable.setMetadata(fluent.getMetadata());
            buildable.setSpec(fluent.getSpec());
            buildable.setStatus(fluent.getStatus());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            AppsV1beta1ScaleBuilder that = (AppsV1beta1ScaleBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
