/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Predicate;
import io.kubernetes.client.models.V1APIResource;
import io.kubernetes.client.models.V1APIResourceFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class V1APIResourceFluentImpl<A extends V1APIResourceFluent<A>>
extends BaseFluent<A>
implements V1APIResourceFluent<A> {
    private List<String> categories;
    private String group;
    private String kind;
    private String name;
    private Boolean namespaced;
    private List<String> shortNames;
    private String singularName;
    private List<String> verbs;
    private String version;

    public V1APIResourceFluentImpl() {
    }

    public V1APIResourceFluentImpl(V1APIResource instance) {
        this.withCategories(instance.getCategories());
        this.withGroup(instance.getGroup());
        this.withKind(instance.getKind());
        this.withName(instance.getName());
        this.withNamespaced(instance.isNamespaced());
        this.withShortNames(instance.getShortNames());
        this.withSingularName(instance.getSingularName());
        this.withVerbs(instance.getVerbs());
        this.withVersion(instance.getVersion());
    }

    @Override
    public A addToCategories(int index, String item) {
        if (this.categories == null) {
            this.categories = new ArrayList<String>();
        }
        this.categories.add(index, item);
        return (A)this;
    }

    @Override
    public A setToCategories(int index, String item) {
        this.categories.set(index, item);
        return (A)this;
    }

    @Override
    public A addToCategories(String ... items) {
        for (String item : items) {
            this.categories.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToCategories(Collection<String> items) {
        for (String item : items) {
            this.categories.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromCategories(String ... items) {
        for (String item : items) {
            if (this.categories == null) continue;
            this.categories.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromCategories(Collection<String> items) {
        for (String item : items) {
            if (this.categories == null) continue;
            this.categories.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getCategories() {
        return this.categories;
    }

    @Override
    public String getCategory(int index) {
        return this.categories.get(index);
    }

    @Override
    public String getFirstCategory() {
        return this.categories.get(0);
    }

    @Override
    public String getLastCategory() {
        return this.categories.get(this.categories.size() - 1);
    }

    @Override
    public String getMatchingCategory(Predicate<String> predicate) {
        for (String item : this.categories) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public A withCategories(List<String> categories) {
        if (this.categories != null) {
            this._visitables.removeAll(this.categories);
        }
        if (categories != null) {
            this.categories = new ArrayList<String>();
            for (String item : categories) {
                this.addToCategories(item);
            }
        } else {
            this.categories = null;
        }
        return (A)this;
    }

    @Override
    public A withCategories(String ... categories) {
        this.categories.clear();
        if (categories != null) {
            for (String item : categories) {
                this.addToCategories(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasCategories() {
        return this.categories != null && !this.categories.isEmpty();
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public A withGroup(String group) {
        this.group = group;
        return (A)this;
    }

    @Override
    public Boolean hasGroup() {
        return this.group != null;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    public Boolean isNamespaced() {
        return this.namespaced;
    }

    @Override
    public A withNamespaced(Boolean namespaced) {
        this.namespaced = namespaced;
        return (A)this;
    }

    @Override
    public Boolean hasNamespaced() {
        return this.namespaced != null;
    }

    @Override
    public A withNewNamespaced(boolean arg1) {
        return this.withNamespaced(new Boolean(arg1));
    }

    @Override
    public A withNewNamespaced(String arg1) {
        return this.withNamespaced(new Boolean(arg1));
    }

    @Override
    public A addToShortNames(int index, String item) {
        if (this.shortNames == null) {
            this.shortNames = new ArrayList<String>();
        }
        this.shortNames.add(index, item);
        return (A)this;
    }

    @Override
    public A setToShortNames(int index, String item) {
        this.shortNames.set(index, item);
        return (A)this;
    }

    @Override
    public A addToShortNames(String ... items) {
        for (String item : items) {
            this.shortNames.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToShortNames(Collection<String> items) {
        for (String item : items) {
            this.shortNames.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromShortNames(String ... items) {
        for (String item : items) {
            if (this.shortNames == null) continue;
            this.shortNames.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromShortNames(Collection<String> items) {
        for (String item : items) {
            if (this.shortNames == null) continue;
            this.shortNames.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getShortNames() {
        return this.shortNames;
    }

    @Override
    public String getShortName(int index) {
        return this.shortNames.get(index);
    }

    @Override
    public String getFirstShortName() {
        return this.shortNames.get(0);
    }

    @Override
    public String getLastShortName() {
        return this.shortNames.get(this.shortNames.size() - 1);
    }

    @Override
    public String getMatchingShortName(Predicate<String> predicate) {
        for (String item : this.shortNames) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public A withShortNames(List<String> shortNames) {
        if (this.shortNames != null) {
            this._visitables.removeAll(this.shortNames);
        }
        if (shortNames != null) {
            this.shortNames = new ArrayList<String>();
            for (String item : shortNames) {
                this.addToShortNames(item);
            }
        } else {
            this.shortNames = null;
        }
        return (A)this;
    }

    @Override
    public A withShortNames(String ... shortNames) {
        this.shortNames.clear();
        if (shortNames != null) {
            for (String item : shortNames) {
                this.addToShortNames(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasShortNames() {
        return this.shortNames != null && !this.shortNames.isEmpty();
    }

    @Override
    public String getSingularName() {
        return this.singularName;
    }

    @Override
    public A withSingularName(String singularName) {
        this.singularName = singularName;
        return (A)this;
    }

    @Override
    public Boolean hasSingularName() {
        return this.singularName != null;
    }

    @Override
    public A addToVerbs(int index, String item) {
        if (this.verbs == null) {
            this.verbs = new ArrayList<String>();
        }
        this.verbs.add(index, item);
        return (A)this;
    }

    @Override
    public A setToVerbs(int index, String item) {
        this.verbs.set(index, item);
        return (A)this;
    }

    @Override
    public A addToVerbs(String ... items) {
        for (String item : items) {
            this.verbs.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToVerbs(Collection<String> items) {
        for (String item : items) {
            this.verbs.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromVerbs(String ... items) {
        for (String item : items) {
            if (this.verbs == null) continue;
            this.verbs.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromVerbs(Collection<String> items) {
        for (String item : items) {
            if (this.verbs == null) continue;
            this.verbs.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getVerbs() {
        return this.verbs;
    }

    @Override
    public String getVerb(int index) {
        return this.verbs.get(index);
    }

    @Override
    public String getFirstVerb() {
        return this.verbs.get(0);
    }

    @Override
    public String getLastVerb() {
        return this.verbs.get(this.verbs.size() - 1);
    }

    @Override
    public String getMatchingVerb(Predicate<String> predicate) {
        for (String item : this.verbs) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public A withVerbs(List<String> verbs) {
        if (this.verbs != null) {
            this._visitables.removeAll(this.verbs);
        }
        if (verbs != null) {
            this.verbs = new ArrayList<String>();
            for (String item : verbs) {
                this.addToVerbs(item);
            }
        } else {
            this.verbs = null;
        }
        return (A)this;
    }

    @Override
    public A withVerbs(String ... verbs) {
        this.verbs.clear();
        if (verbs != null) {
            for (String item : verbs) {
                this.addToVerbs(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasVerbs() {
        return this.verbs != null && !this.verbs.isEmpty();
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public A withVersion(String version) {
        this.version = version;
        return (A)this;
    }

    @Override
    public Boolean hasVersion() {
        return this.version != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1APIResourceFluentImpl that = (V1APIResourceFluentImpl)o;
        if (this.categories != null ? !this.categories.equals(that.categories) : that.categories != null) {
            return false;
        }
        if (this.group != null ? !this.group.equals(that.group) : that.group != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.namespaced != null ? !this.namespaced.equals(that.namespaced) : that.namespaced != null) {
            return false;
        }
        if (this.shortNames != null ? !this.shortNames.equals(that.shortNames) : that.shortNames != null) {
            return false;
        }
        if (this.singularName != null ? !this.singularName.equals(that.singularName) : that.singularName != null) {
            return false;
        }
        if (this.verbs != null ? !this.verbs.equals(that.verbs) : that.verbs != null) {
            return false;
        }
        return !(this.version != null ? !this.version.equals(that.version) : that.version != null);
    }
}

