/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1NodeSelector;
import io.kubernetes.client.openapi.models.V1beta1DeviceAttribute;
import io.kubernetes.client.openapi.models.V1beta1DeviceCapacity;
import io.kubernetes.client.openapi.models.V1beta1DeviceCounterConsumption;
import io.kubernetes.client.openapi.models.V1beta1DeviceTaint;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="BasicDevice defines one device instance.")
public class V1beta1BasicDevice {
    public static final String SERIALIZED_NAME_ALL_NODES = "allNodes";
    @SerializedName(value="allNodes")
    @Nullable
    private Boolean allNodes;
    public static final String SERIALIZED_NAME_ALLOW_MULTIPLE_ALLOCATIONS = "allowMultipleAllocations";
    @SerializedName(value="allowMultipleAllocations")
    @Nullable
    private Boolean allowMultipleAllocations;
    public static final String SERIALIZED_NAME_ATTRIBUTES = "attributes";
    @SerializedName(value="attributes")
    @Nullable
    private Map<String, V1beta1DeviceAttribute> attributes = new HashMap<String, V1beta1DeviceAttribute>();
    public static final String SERIALIZED_NAME_BINDING_CONDITIONS = "bindingConditions";
    @SerializedName(value="bindingConditions")
    @Nullable
    private List<String> bindingConditions = new ArrayList<String>();
    public static final String SERIALIZED_NAME_BINDING_FAILURE_CONDITIONS = "bindingFailureConditions";
    @SerializedName(value="bindingFailureConditions")
    @Nullable
    private List<String> bindingFailureConditions = new ArrayList<String>();
    public static final String SERIALIZED_NAME_BINDS_TO_NODE = "bindsToNode";
    @SerializedName(value="bindsToNode")
    @Nullable
    private Boolean bindsToNode;
    public static final String SERIALIZED_NAME_CAPACITY = "capacity";
    @SerializedName(value="capacity")
    @Nullable
    private Map<String, V1beta1DeviceCapacity> capacity = new HashMap<String, V1beta1DeviceCapacity>();
    public static final String SERIALIZED_NAME_CONSUMES_COUNTERS = "consumesCounters";
    @SerializedName(value="consumesCounters")
    @Nullable
    private List<V1beta1DeviceCounterConsumption> consumesCounters = new ArrayList<V1beta1DeviceCounterConsumption>();
    public static final String SERIALIZED_NAME_NODE_NAME = "nodeName";
    @SerializedName(value="nodeName")
    @Nullable
    private String nodeName;
    public static final String SERIALIZED_NAME_NODE_SELECTOR = "nodeSelector";
    @SerializedName(value="nodeSelector")
    @Nullable
    private V1NodeSelector nodeSelector;
    public static final String SERIALIZED_NAME_TAINTS = "taints";
    @SerializedName(value="taints")
    @Nullable
    private List<V1beta1DeviceTaint> taints = new ArrayList<V1beta1DeviceTaint>();
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1beta1BasicDevice allNodes(@Nullable Boolean allNodes) {
        this.allNodes = allNodes;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="AllNodes indicates that all nodes have access to the device.  Must only be set if Spec.PerDeviceNodeSelection is set to true. At most one of NodeName, NodeSelector and AllNodes can be set.")
    public Boolean getAllNodes() {
        return this.allNodes;
    }

    public void setAllNodes(@Nullable Boolean allNodes) {
        this.allNodes = allNodes;
    }

    public V1beta1BasicDevice allowMultipleAllocations(@Nullable Boolean allowMultipleAllocations) {
        this.allowMultipleAllocations = allowMultipleAllocations;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="AllowMultipleAllocations marks whether the device is allowed to be allocated to multiple DeviceRequests.  If AllowMultipleAllocations is set to true, the device can be allocated more than once, and all of its capacity is consumable, regardless of whether the requestPolicy is defined or not.")
    public Boolean getAllowMultipleAllocations() {
        return this.allowMultipleAllocations;
    }

    public void setAllowMultipleAllocations(@Nullable Boolean allowMultipleAllocations) {
        this.allowMultipleAllocations = allowMultipleAllocations;
    }

    public V1beta1BasicDevice attributes(@Nullable Map<String, V1beta1DeviceAttribute> attributes) {
        this.attributes = attributes;
        return this;
    }

    public V1beta1BasicDevice putAttributesItem(String key, V1beta1DeviceAttribute attributesItem) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, V1beta1DeviceAttribute>();
        }
        this.attributes.put(key, attributesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Attributes defines the set of attributes for this device. The name of each attribute must be unique in that set.  The maximum number of attributes and capacities combined is 32.")
    public Map<String, V1beta1DeviceAttribute> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(@Nullable Map<String, V1beta1DeviceAttribute> attributes) {
        this.attributes = attributes;
    }

    public V1beta1BasicDevice bindingConditions(@Nullable List<String> bindingConditions) {
        this.bindingConditions = bindingConditions;
        return this;
    }

    public V1beta1BasicDevice addBindingConditionsItem(String bindingConditionsItem) {
        if (this.bindingConditions == null) {
            this.bindingConditions = new ArrayList<String>();
        }
        this.bindingConditions.add(bindingConditionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="BindingConditions defines the conditions for proceeding with binding. All of these conditions must be set in the per-device status conditions with a value of True to proceed with binding the pod to the node while scheduling the pod.  The maximum number of binding conditions is 4.  The conditions must be a valid condition type string.  This is an alpha field and requires enabling the DRADeviceBindingConditions and DRAResourceClaimDeviceStatus feature gates.")
    public List<String> getBindingConditions() {
        return this.bindingConditions;
    }

    public void setBindingConditions(@Nullable List<String> bindingConditions) {
        this.bindingConditions = bindingConditions;
    }

    public V1beta1BasicDevice bindingFailureConditions(@Nullable List<String> bindingFailureConditions) {
        this.bindingFailureConditions = bindingFailureConditions;
        return this;
    }

    public V1beta1BasicDevice addBindingFailureConditionsItem(String bindingFailureConditionsItem) {
        if (this.bindingFailureConditions == null) {
            this.bindingFailureConditions = new ArrayList<String>();
        }
        this.bindingFailureConditions.add(bindingFailureConditionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="BindingFailureConditions defines the conditions for binding failure. They may be set in the per-device status conditions. If any is true, a binding failure occurred.  The maximum number of binding failure conditions is 4.  The conditions must be a valid condition type string.  This is an alpha field and requires enabling the DRADeviceBindingConditions and DRAResourceClaimDeviceStatus feature gates.")
    public List<String> getBindingFailureConditions() {
        return this.bindingFailureConditions;
    }

    public void setBindingFailureConditions(@Nullable List<String> bindingFailureConditions) {
        this.bindingFailureConditions = bindingFailureConditions;
    }

    public V1beta1BasicDevice bindsToNode(@Nullable Boolean bindsToNode) {
        this.bindsToNode = bindsToNode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="BindsToNode indicates if the usage of an allocation involving this device has to be limited to exactly the node that was chosen when allocating the claim. If set to true, the scheduler will set the ResourceClaim.Status.Allocation.NodeSelector to match the node where the allocation was made.  This is an alpha field and requires enabling the DRADeviceBindingConditions and DRAResourceClaimDeviceStatus feature gates.")
    public Boolean getBindsToNode() {
        return this.bindsToNode;
    }

    public void setBindsToNode(@Nullable Boolean bindsToNode) {
        this.bindsToNode = bindsToNode;
    }

    public V1beta1BasicDevice capacity(@Nullable Map<String, V1beta1DeviceCapacity> capacity) {
        this.capacity = capacity;
        return this;
    }

    public V1beta1BasicDevice putCapacityItem(String key, V1beta1DeviceCapacity capacityItem) {
        if (this.capacity == null) {
            this.capacity = new HashMap<String, V1beta1DeviceCapacity>();
        }
        this.capacity.put(key, capacityItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Capacity defines the set of capacities for this device. The name of each capacity must be unique in that set.  The maximum number of attributes and capacities combined is 32.")
    public Map<String, V1beta1DeviceCapacity> getCapacity() {
        return this.capacity;
    }

    public void setCapacity(@Nullable Map<String, V1beta1DeviceCapacity> capacity) {
        this.capacity = capacity;
    }

    public V1beta1BasicDevice consumesCounters(@Nullable List<V1beta1DeviceCounterConsumption> consumesCounters) {
        this.consumesCounters = consumesCounters;
        return this;
    }

    public V1beta1BasicDevice addConsumesCountersItem(V1beta1DeviceCounterConsumption consumesCountersItem) {
        if (this.consumesCounters == null) {
            this.consumesCounters = new ArrayList<V1beta1DeviceCounterConsumption>();
        }
        this.consumesCounters.add(consumesCountersItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ConsumesCounters defines a list of references to sharedCounters and the set of counters that the device will consume from those counter sets.  There can only be a single entry per counterSet.  The total number of device counter consumption entries must be <= 32. In addition, the total number in the entire ResourceSlice must be <= 1024 (for example, 64 devices with 16 counters each).")
    public List<V1beta1DeviceCounterConsumption> getConsumesCounters() {
        return this.consumesCounters;
    }

    public void setConsumesCounters(@Nullable List<V1beta1DeviceCounterConsumption> consumesCounters) {
        this.consumesCounters = consumesCounters;
    }

    public V1beta1BasicDevice nodeName(@Nullable String nodeName) {
        this.nodeName = nodeName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="NodeName identifies the node where the device is available.  Must only be set if Spec.PerDeviceNodeSelection is set to true. At most one of NodeName, NodeSelector and AllNodes can be set.")
    public String getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(@Nullable String nodeName) {
        this.nodeName = nodeName;
    }

    public V1beta1BasicDevice nodeSelector(@Nullable V1NodeSelector nodeSelector) {
        this.nodeSelector = nodeSelector;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1NodeSelector getNodeSelector() {
        return this.nodeSelector;
    }

    public void setNodeSelector(@Nullable V1NodeSelector nodeSelector) {
        this.nodeSelector = nodeSelector;
    }

    public V1beta1BasicDevice taints(@Nullable List<V1beta1DeviceTaint> taints) {
        this.taints = taints;
        return this;
    }

    public V1beta1BasicDevice addTaintsItem(V1beta1DeviceTaint taintsItem) {
        if (this.taints == null) {
            this.taints = new ArrayList<V1beta1DeviceTaint>();
        }
        this.taints.add(taintsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If specified, these are the driver-defined taints.  The maximum number of taints is 4.  This is an alpha field and requires enabling the DRADeviceTaints feature gate.")
    public List<V1beta1DeviceTaint> getTaints() {
        return this.taints;
    }

    public void setTaints(@Nullable List<V1beta1DeviceTaint> taints) {
        this.taints = taints;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1beta1BasicDevice v1beta1BasicDevice = (V1beta1BasicDevice)o;
        return Objects.equals(this.allNodes, v1beta1BasicDevice.allNodes) && Objects.equals(this.allowMultipleAllocations, v1beta1BasicDevice.allowMultipleAllocations) && Objects.equals(this.attributes, v1beta1BasicDevice.attributes) && Objects.equals(this.bindingConditions, v1beta1BasicDevice.bindingConditions) && Objects.equals(this.bindingFailureConditions, v1beta1BasicDevice.bindingFailureConditions) && Objects.equals(this.bindsToNode, v1beta1BasicDevice.bindsToNode) && Objects.equals(this.capacity, v1beta1BasicDevice.capacity) && Objects.equals(this.consumesCounters, v1beta1BasicDevice.consumesCounters) && Objects.equals(this.nodeName, v1beta1BasicDevice.nodeName) && Objects.equals(this.nodeSelector, v1beta1BasicDevice.nodeSelector) && Objects.equals(this.taints, v1beta1BasicDevice.taints);
    }

    public int hashCode() {
        return Objects.hash(this.allNodes, this.allowMultipleAllocations, this.attributes, this.bindingConditions, this.bindingFailureConditions, this.bindsToNode, this.capacity, this.consumesCounters, this.nodeName, this.nodeSelector, this.taints);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1beta1BasicDevice {\n");
        sb.append("    allNodes: ").append(this.toIndentedString(this.allNodes)).append("\n");
        sb.append("    allowMultipleAllocations: ").append(this.toIndentedString(this.allowMultipleAllocations)).append("\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    bindingConditions: ").append(this.toIndentedString(this.bindingConditions)).append("\n");
        sb.append("    bindingFailureConditions: ").append(this.toIndentedString(this.bindingFailureConditions)).append("\n");
        sb.append("    bindsToNode: ").append(this.toIndentedString(this.bindsToNode)).append("\n");
        sb.append("    capacity: ").append(this.toIndentedString(this.capacity)).append("\n");
        sb.append("    consumesCounters: ").append(this.toIndentedString(this.consumesCounters)).append("\n");
        sb.append("    nodeName: ").append(this.toIndentedString(this.nodeName)).append("\n");
        sb.append("    nodeSelector: ").append(this.toIndentedString(this.nodeSelector)).append("\n");
        sb.append("    taints: ").append(this.toIndentedString(this.taints)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        JsonArray jsonArraytaints;
        int i;
        JsonArray jsonArrayconsumesCounters;
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1beta1BasicDevice is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1beta1BasicDevice` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_BINDING_CONDITIONS) != null && !jsonObj.get(SERIALIZED_NAME_BINDING_CONDITIONS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_BINDING_CONDITIONS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `bindingConditions` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BINDING_CONDITIONS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_BINDING_FAILURE_CONDITIONS) != null && !jsonObj.get(SERIALIZED_NAME_BINDING_FAILURE_CONDITIONS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_BINDING_FAILURE_CONDITIONS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `bindingFailureConditions` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BINDING_FAILURE_CONDITIONS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CONSUMES_COUNTERS) != null && !jsonObj.get(SERIALIZED_NAME_CONSUMES_COUNTERS).isJsonNull() && (jsonArrayconsumesCounters = jsonObj.getAsJsonArray(SERIALIZED_NAME_CONSUMES_COUNTERS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_CONSUMES_COUNTERS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `consumesCounters` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CONSUMES_COUNTERS).toString()));
            }
            for (i = 0; i < jsonArrayconsumesCounters.size(); ++i) {
                V1beta1DeviceCounterConsumption.validateJsonElement(jsonArrayconsumesCounters.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_NODE_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NODE_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_NODE_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `nodeName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NODE_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NODE_SELECTOR) != null && !jsonObj.get(SERIALIZED_NAME_NODE_SELECTOR).isJsonNull()) {
            V1NodeSelector.validateJsonElement(jsonObj.get(SERIALIZED_NAME_NODE_SELECTOR));
        }
        if (jsonObj.get(SERIALIZED_NAME_TAINTS) != null && !jsonObj.get(SERIALIZED_NAME_TAINTS).isJsonNull() && (jsonArraytaints = jsonObj.getAsJsonArray(SERIALIZED_NAME_TAINTS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_TAINTS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `taints` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TAINTS).toString()));
            }
            for (i = 0; i < jsonArraytaints.size(); ++i) {
                V1beta1DeviceTaint.validateJsonElement(jsonArraytaints.get(i));
            }
        }
    }

    public static V1beta1BasicDevice fromJson(String jsonString) throws IOException {
        return (V1beta1BasicDevice)JSON.getGson().fromJson(jsonString, V1beta1BasicDevice.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ALL_NODES);
        openapiFields.add(SERIALIZED_NAME_ALLOW_MULTIPLE_ALLOCATIONS);
        openapiFields.add(SERIALIZED_NAME_ATTRIBUTES);
        openapiFields.add(SERIALIZED_NAME_BINDING_CONDITIONS);
        openapiFields.add(SERIALIZED_NAME_BINDING_FAILURE_CONDITIONS);
        openapiFields.add(SERIALIZED_NAME_BINDS_TO_NODE);
        openapiFields.add(SERIALIZED_NAME_CAPACITY);
        openapiFields.add(SERIALIZED_NAME_CONSUMES_COUNTERS);
        openapiFields.add(SERIALIZED_NAME_NODE_NAME);
        openapiFields.add(SERIALIZED_NAME_NODE_SELECTOR);
        openapiFields.add(SERIALIZED_NAME_TAINTS);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1beta1BasicDevice.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1beta1BasicDevice.class));
            return new TypeAdapter<V1beta1BasicDevice>(){

                public void write(JsonWriter out, V1beta1BasicDevice value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1beta1BasicDevice read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1beta1BasicDevice.validateJsonElement(jsonElement);
                    return (V1beta1BasicDevice)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

