/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1ContainerExtendedResourceRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="PodExtendedResourceClaimStatus is stored in the PodStatus for the extended resource requests backed by DRA. It stores the generated name for the corresponding special ResourceClaim created by the scheduler.")
public class V1PodExtendedResourceClaimStatus {
    public static final String SERIALIZED_NAME_REQUEST_MAPPINGS = "requestMappings";
    @SerializedName(value="requestMappings")
    @Nonnull
    private List<V1ContainerExtendedResourceRequest> requestMappings = new ArrayList<V1ContainerExtendedResourceRequest>();
    public static final String SERIALIZED_NAME_RESOURCE_CLAIM_NAME = "resourceClaimName";
    @SerializedName(value="resourceClaimName")
    @Nonnull
    private String resourceClaimName;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1PodExtendedResourceClaimStatus requestMappings(@Nonnull List<V1ContainerExtendedResourceRequest> requestMappings) {
        this.requestMappings = requestMappings;
        return this;
    }

    public V1PodExtendedResourceClaimStatus addRequestMappingsItem(V1ContainerExtendedResourceRequest requestMappingsItem) {
        if (this.requestMappings == null) {
            this.requestMappings = new ArrayList<V1ContainerExtendedResourceRequest>();
        }
        this.requestMappings.add(requestMappingsItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="RequestMappings identifies the mapping of <container, extended resource backed by DRA> to  device request in the generated ResourceClaim.")
    public List<V1ContainerExtendedResourceRequest> getRequestMappings() {
        return this.requestMappings;
    }

    public void setRequestMappings(@Nonnull List<V1ContainerExtendedResourceRequest> requestMappings) {
        this.requestMappings = requestMappings;
    }

    public V1PodExtendedResourceClaimStatus resourceClaimName(@Nonnull String resourceClaimName) {
        this.resourceClaimName = resourceClaimName;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="ResourceClaimName is the name of the ResourceClaim that was generated for the Pod in the namespace of the Pod.")
    public String getResourceClaimName() {
        return this.resourceClaimName;
    }

    public void setResourceClaimName(@Nonnull String resourceClaimName) {
        this.resourceClaimName = resourceClaimName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1PodExtendedResourceClaimStatus v1PodExtendedResourceClaimStatus = (V1PodExtendedResourceClaimStatus)o;
        return Objects.equals(this.requestMappings, v1PodExtendedResourceClaimStatus.requestMappings) && Objects.equals(this.resourceClaimName, v1PodExtendedResourceClaimStatus.resourceClaimName);
    }

    public int hashCode() {
        return Objects.hash(this.requestMappings, this.resourceClaimName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1PodExtendedResourceClaimStatus {\n");
        sb.append("    requestMappings: ").append(this.toIndentedString(this.requestMappings)).append("\n");
        sb.append("    resourceClaimName: ").append(this.toIndentedString(this.resourceClaimName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1PodExtendedResourceClaimStatus is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1PodExtendedResourceClaimStatus` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_REQUEST_MAPPINGS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `requestMappings` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REQUEST_MAPPINGS).toString()));
        }
        JsonArray jsonArrayrequestMappings = jsonObj.getAsJsonArray(SERIALIZED_NAME_REQUEST_MAPPINGS);
        for (int i = 0; i < jsonArrayrequestMappings.size(); ++i) {
            V1ContainerExtendedResourceRequest.validateJsonElement(jsonArrayrequestMappings.get(i));
        }
        if (!jsonObj.get(SERIALIZED_NAME_RESOURCE_CLAIM_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `resourceClaimName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RESOURCE_CLAIM_NAME).toString()));
        }
    }

    public static V1PodExtendedResourceClaimStatus fromJson(String jsonString) throws IOException {
        return (V1PodExtendedResourceClaimStatus)JSON.getGson().fromJson(jsonString, V1PodExtendedResourceClaimStatus.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_REQUEST_MAPPINGS);
        openapiFields.add(SERIALIZED_NAME_RESOURCE_CLAIM_NAME);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_REQUEST_MAPPINGS);
        openapiRequiredFields.add(SERIALIZED_NAME_RESOURCE_CLAIM_NAME);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1PodExtendedResourceClaimStatus.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1PodExtendedResourceClaimStatus.class));
            return new TypeAdapter<V1PodExtendedResourceClaimStatus>(){

                public void write(JsonWriter out, V1PodExtendedResourceClaimStatus value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1PodExtendedResourceClaimStatus read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1PodExtendedResourceClaimStatus.validateJsonElement(jsonElement);
                    return (V1PodExtendedResourceClaimStatus)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

