/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1LabelSelectorRequirement;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="LabelSelectorAttributes indicates a label limited access. Webhook authors are encouraged to * ensure rawSelector and requirements are not both set * consider the requirements field if set * not try to parse or consider the rawSelector field if set. This is to avoid another CVE-2022-2880 (i.e. getting different systems to agree on how exactly to parse a query is not something we want), see https://www.oxeye.io/resources/golang-parameter-smuggling-attack for more details. For the *SubjectAccessReview endpoints of the kube-apiserver: * If rawSelector is empty and requirements are empty, the request is not limited. * If rawSelector is present and requirements are empty, the rawSelector will be parsed and limited if the parsing succeeds. * If rawSelector is empty and requirements are present, the requirements should be honored * If rawSelector is present and requirements are present, the request is invalid.")
public class V1LabelSelectorAttributes {
    public static final String SERIALIZED_NAME_RAW_SELECTOR = "rawSelector";
    @SerializedName(value="rawSelector")
    @Nullable
    private String rawSelector;
    public static final String SERIALIZED_NAME_REQUIREMENTS = "requirements";
    @SerializedName(value="requirements")
    @Nullable
    private List<V1LabelSelectorRequirement> requirements = new ArrayList<V1LabelSelectorRequirement>();
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1LabelSelectorAttributes rawSelector(@Nullable String rawSelector) {
        this.rawSelector = rawSelector;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="rawSelector is the serialization of a field selector that would be included in a query parameter. Webhook implementations are encouraged to ignore rawSelector. The kube-apiserver's *SubjectAccessReview will parse the rawSelector as long as the requirements are not present.")
    public String getRawSelector() {
        return this.rawSelector;
    }

    public void setRawSelector(@Nullable String rawSelector) {
        this.rawSelector = rawSelector;
    }

    public V1LabelSelectorAttributes requirements(@Nullable List<V1LabelSelectorRequirement> requirements) {
        this.requirements = requirements;
        return this;
    }

    public V1LabelSelectorAttributes addRequirementsItem(V1LabelSelectorRequirement requirementsItem) {
        if (this.requirements == null) {
            this.requirements = new ArrayList<V1LabelSelectorRequirement>();
        }
        this.requirements.add(requirementsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="requirements is the parsed interpretation of a label selector. All requirements must be met for a resource instance to match the selector. Webhook implementations should handle requirements, but how to handle them is up to the webhook. Since requirements can only limit the request, it is safe to authorize as unlimited request if the requirements are not understood.")
    public List<V1LabelSelectorRequirement> getRequirements() {
        return this.requirements;
    }

    public void setRequirements(@Nullable List<V1LabelSelectorRequirement> requirements) {
        this.requirements = requirements;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1LabelSelectorAttributes v1LabelSelectorAttributes = (V1LabelSelectorAttributes)o;
        return Objects.equals(this.rawSelector, v1LabelSelectorAttributes.rawSelector) && Objects.equals(this.requirements, v1LabelSelectorAttributes.requirements);
    }

    public int hashCode() {
        return Objects.hash(this.rawSelector, this.requirements);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1LabelSelectorAttributes {\n");
        sb.append("    rawSelector: ").append(this.toIndentedString(this.rawSelector)).append("\n");
        sb.append("    requirements: ").append(this.toIndentedString(this.requirements)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        JsonArray jsonArrayrequirements;
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1LabelSelectorAttributes is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1LabelSelectorAttributes` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_RAW_SELECTOR) != null && !jsonObj.get(SERIALIZED_NAME_RAW_SELECTOR).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_RAW_SELECTOR).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `rawSelector` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RAW_SELECTOR).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_REQUIREMENTS) != null && !jsonObj.get(SERIALIZED_NAME_REQUIREMENTS).isJsonNull() && (jsonArrayrequirements = jsonObj.getAsJsonArray(SERIALIZED_NAME_REQUIREMENTS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_REQUIREMENTS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `requirements` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REQUIREMENTS).toString()));
            }
            for (int i = 0; i < jsonArrayrequirements.size(); ++i) {
                V1LabelSelectorRequirement.validateJsonElement(jsonArrayrequirements.get(i));
            }
        }
    }

    public static V1LabelSelectorAttributes fromJson(String jsonString) throws IOException {
        return (V1LabelSelectorAttributes)JSON.getGson().fromJson(jsonString, V1LabelSelectorAttributes.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_RAW_SELECTOR);
        openapiFields.add(SERIALIZED_NAME_REQUIREMENTS);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1LabelSelectorAttributes.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1LabelSelectorAttributes.class));
            return new TypeAdapter<V1LabelSelectorAttributes>(){

                public void write(JsonWriter out, V1LabelSelectorAttributes value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1LabelSelectorAttributes read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1LabelSelectorAttributes.validateJsonElement(jsonElement);
                    return (V1LabelSelectorAttributes)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

