/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1LabelSelectorRequirement;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="A label selector is a label query over a set of resources. The result of matchLabels and matchExpressions are ANDed. An empty label selector matches all objects. A null label selector matches no objects.")
public class V1LabelSelector {
    public static final String SERIALIZED_NAME_MATCH_EXPRESSIONS = "matchExpressions";
    @SerializedName(value="matchExpressions")
    @Nullable
    private List<V1LabelSelectorRequirement> matchExpressions = new ArrayList<V1LabelSelectorRequirement>();
    public static final String SERIALIZED_NAME_MATCH_LABELS = "matchLabels";
    @SerializedName(value="matchLabels")
    @Nullable
    private Map<String, String> matchLabels = new HashMap<String, String>();
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1LabelSelector matchExpressions(@Nullable List<V1LabelSelectorRequirement> matchExpressions) {
        this.matchExpressions = matchExpressions;
        return this;
    }

    public V1LabelSelector addMatchExpressionsItem(V1LabelSelectorRequirement matchExpressionsItem) {
        if (this.matchExpressions == null) {
            this.matchExpressions = new ArrayList<V1LabelSelectorRequirement>();
        }
        this.matchExpressions.add(matchExpressionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="matchExpressions is a list of label selector requirements. The requirements are ANDed.")
    public List<V1LabelSelectorRequirement> getMatchExpressions() {
        return this.matchExpressions;
    }

    public void setMatchExpressions(@Nullable List<V1LabelSelectorRequirement> matchExpressions) {
        this.matchExpressions = matchExpressions;
    }

    public V1LabelSelector matchLabels(@Nullable Map<String, String> matchLabels) {
        this.matchLabels = matchLabels;
        return this;
    }

    public V1LabelSelector putMatchLabelsItem(String key, String matchLabelsItem) {
        if (this.matchLabels == null) {
            this.matchLabels = new HashMap<String, String>();
        }
        this.matchLabels.put(key, matchLabelsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels map is equivalent to an element of matchExpressions, whose key field is \"key\", the operator is \"In\", and the values array contains only \"value\". The requirements are ANDed.")
    public Map<String, String> getMatchLabels() {
        return this.matchLabels;
    }

    public void setMatchLabels(@Nullable Map<String, String> matchLabels) {
        this.matchLabels = matchLabels;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1LabelSelector v1LabelSelector = (V1LabelSelector)o;
        return Objects.equals(this.matchExpressions, v1LabelSelector.matchExpressions) && Objects.equals(this.matchLabels, v1LabelSelector.matchLabels);
    }

    public int hashCode() {
        return Objects.hash(this.matchExpressions, this.matchLabels);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1LabelSelector {\n");
        sb.append("    matchExpressions: ").append(this.toIndentedString(this.matchExpressions)).append("\n");
        sb.append("    matchLabels: ").append(this.toIndentedString(this.matchLabels)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        JsonArray jsonArraymatchExpressions;
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1LabelSelector is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1LabelSelector` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_MATCH_EXPRESSIONS) != null && !jsonObj.get(SERIALIZED_NAME_MATCH_EXPRESSIONS).isJsonNull() && (jsonArraymatchExpressions = jsonObj.getAsJsonArray(SERIALIZED_NAME_MATCH_EXPRESSIONS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_MATCH_EXPRESSIONS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `matchExpressions` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MATCH_EXPRESSIONS).toString()));
            }
            for (int i = 0; i < jsonArraymatchExpressions.size(); ++i) {
                V1LabelSelectorRequirement.validateJsonElement(jsonArraymatchExpressions.get(i));
            }
        }
    }

    public static V1LabelSelector fromJson(String jsonString) throws IOException {
        return (V1LabelSelector)JSON.getGson().fromJson(jsonString, V1LabelSelector.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_MATCH_EXPRESSIONS);
        openapiFields.add(SERIALIZED_NAME_MATCH_LABELS);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1LabelSelector.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1LabelSelector.class));
            return new TypeAdapter<V1LabelSelector>(){

                public void write(JsonWriter out, V1LabelSelector value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1LabelSelector read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1LabelSelector.validateJsonElement(jsonElement);
                    return (V1LabelSelector)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

