/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1CustomResourceColumnDefinition;
import io.kubernetes.client.openapi.models.V1CustomResourceSubresources;
import io.kubernetes.client.openapi.models.V1CustomResourceValidation;
import io.kubernetes.client.openapi.models.V1SelectableField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="CustomResourceDefinitionVersion describes a version for CRD.")
public class V1CustomResourceDefinitionVersion {
    public static final String SERIALIZED_NAME_ADDITIONAL_PRINTER_COLUMNS = "additionalPrinterColumns";
    @SerializedName(value="additionalPrinterColumns")
    @Nullable
    private List<V1CustomResourceColumnDefinition> additionalPrinterColumns = new ArrayList<V1CustomResourceColumnDefinition>();
    public static final String SERIALIZED_NAME_DEPRECATED = "deprecated";
    @SerializedName(value="deprecated")
    @Nullable
    private Boolean deprecated;
    public static final String SERIALIZED_NAME_DEPRECATION_WARNING = "deprecationWarning";
    @SerializedName(value="deprecationWarning")
    @Nullable
    private String deprecationWarning;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    @Nonnull
    private String name;
    public static final String SERIALIZED_NAME_SCHEMA = "schema";
    @SerializedName(value="schema")
    @Nullable
    private V1CustomResourceValidation schema;
    public static final String SERIALIZED_NAME_SELECTABLE_FIELDS = "selectableFields";
    @SerializedName(value="selectableFields")
    @Nullable
    private List<V1SelectableField> selectableFields = new ArrayList<V1SelectableField>();
    public static final String SERIALIZED_NAME_SERVED = "served";
    @SerializedName(value="served")
    @Nonnull
    private Boolean served;
    public static final String SERIALIZED_NAME_STORAGE = "storage";
    @SerializedName(value="storage")
    @Nonnull
    private Boolean storage;
    public static final String SERIALIZED_NAME_SUBRESOURCES = "subresources";
    @SerializedName(value="subresources")
    @Nullable
    private V1CustomResourceSubresources subresources;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1CustomResourceDefinitionVersion additionalPrinterColumns(@Nullable List<V1CustomResourceColumnDefinition> additionalPrinterColumns) {
        this.additionalPrinterColumns = additionalPrinterColumns;
        return this;
    }

    public V1CustomResourceDefinitionVersion addAdditionalPrinterColumnsItem(V1CustomResourceColumnDefinition additionalPrinterColumnsItem) {
        if (this.additionalPrinterColumns == null) {
            this.additionalPrinterColumns = new ArrayList<V1CustomResourceColumnDefinition>();
        }
        this.additionalPrinterColumns.add(additionalPrinterColumnsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="additionalPrinterColumns specifies additional columns returned in Table output. See https://kubernetes.io/docs/reference/using-api/api-concepts/#receiving-resources-as-tables for details. If no columns are specified, a single column displaying the age of the custom resource is used.")
    public List<V1CustomResourceColumnDefinition> getAdditionalPrinterColumns() {
        return this.additionalPrinterColumns;
    }

    public void setAdditionalPrinterColumns(@Nullable List<V1CustomResourceColumnDefinition> additionalPrinterColumns) {
        this.additionalPrinterColumns = additionalPrinterColumns;
    }

    public V1CustomResourceDefinitionVersion deprecated(@Nullable Boolean deprecated) {
        this.deprecated = deprecated;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="deprecated indicates this version of the custom resource API is deprecated. When set to true, API requests to this version receive a warning header in the server response. Defaults to false.")
    public Boolean getDeprecated() {
        return this.deprecated;
    }

    public void setDeprecated(@Nullable Boolean deprecated) {
        this.deprecated = deprecated;
    }

    public V1CustomResourceDefinitionVersion deprecationWarning(@Nullable String deprecationWarning) {
        this.deprecationWarning = deprecationWarning;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="deprecationWarning overrides the default warning returned to API clients. May only be set when `deprecated` is true. The default warning indicates this version is deprecated and recommends use of the newest served version of equal or greater stability, if one exists.")
    public String getDeprecationWarning() {
        return this.deprecationWarning;
    }

    public void setDeprecationWarning(@Nullable String deprecationWarning) {
        this.deprecationWarning = deprecationWarning;
    }

    public V1CustomResourceDefinitionVersion name(@Nonnull String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="name is the version name, e.g. \u201cv1\u201d, \u201cv2beta1\u201d, etc. The custom resources are served under this version at `/apis/<group>/<version>/...` if `served` is true.")
    public String getName() {
        return this.name;
    }

    public void setName(@Nonnull String name) {
        this.name = name;
    }

    public V1CustomResourceDefinitionVersion schema(@Nullable V1CustomResourceValidation schema) {
        this.schema = schema;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1CustomResourceValidation getSchema() {
        return this.schema;
    }

    public void setSchema(@Nullable V1CustomResourceValidation schema) {
        this.schema = schema;
    }

    public V1CustomResourceDefinitionVersion selectableFields(@Nullable List<V1SelectableField> selectableFields) {
        this.selectableFields = selectableFields;
        return this;
    }

    public V1CustomResourceDefinitionVersion addSelectableFieldsItem(V1SelectableField selectableFieldsItem) {
        if (this.selectableFields == null) {
            this.selectableFields = new ArrayList<V1SelectableField>();
        }
        this.selectableFields.add(selectableFieldsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="selectableFields specifies paths to fields that may be used as field selectors. A maximum of 8 selectable fields are allowed. See https://kubernetes.io/docs/concepts/overview/working-with-objects/field-selectors")
    public List<V1SelectableField> getSelectableFields() {
        return this.selectableFields;
    }

    public void setSelectableFields(@Nullable List<V1SelectableField> selectableFields) {
        this.selectableFields = selectableFields;
    }

    public V1CustomResourceDefinitionVersion served(@Nonnull Boolean served) {
        this.served = served;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="served is a flag enabling/disabling this version from being served via REST APIs")
    public Boolean getServed() {
        return this.served;
    }

    public void setServed(@Nonnull Boolean served) {
        this.served = served;
    }

    public V1CustomResourceDefinitionVersion storage(@Nonnull Boolean storage) {
        this.storage = storage;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="storage indicates this version should be used when persisting custom resources to storage. There must be exactly one version with storage=true.")
    public Boolean getStorage() {
        return this.storage;
    }

    public void setStorage(@Nonnull Boolean storage) {
        this.storage = storage;
    }

    public V1CustomResourceDefinitionVersion subresources(@Nullable V1CustomResourceSubresources subresources) {
        this.subresources = subresources;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1CustomResourceSubresources getSubresources() {
        return this.subresources;
    }

    public void setSubresources(@Nullable V1CustomResourceSubresources subresources) {
        this.subresources = subresources;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1CustomResourceDefinitionVersion v1CustomResourceDefinitionVersion = (V1CustomResourceDefinitionVersion)o;
        return Objects.equals(this.additionalPrinterColumns, v1CustomResourceDefinitionVersion.additionalPrinterColumns) && Objects.equals(this.deprecated, v1CustomResourceDefinitionVersion.deprecated) && Objects.equals(this.deprecationWarning, v1CustomResourceDefinitionVersion.deprecationWarning) && Objects.equals(this.name, v1CustomResourceDefinitionVersion.name) && Objects.equals(this.schema, v1CustomResourceDefinitionVersion.schema) && Objects.equals(this.selectableFields, v1CustomResourceDefinitionVersion.selectableFields) && Objects.equals(this.served, v1CustomResourceDefinitionVersion.served) && Objects.equals(this.storage, v1CustomResourceDefinitionVersion.storage) && Objects.equals(this.subresources, v1CustomResourceDefinitionVersion.subresources);
    }

    public int hashCode() {
        return Objects.hash(this.additionalPrinterColumns, this.deprecated, this.deprecationWarning, this.name, this.schema, this.selectableFields, this.served, this.storage, this.subresources);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1CustomResourceDefinitionVersion {\n");
        sb.append("    additionalPrinterColumns: ").append(this.toIndentedString(this.additionalPrinterColumns)).append("\n");
        sb.append("    deprecated: ").append(this.toIndentedString(this.deprecated)).append("\n");
        sb.append("    deprecationWarning: ").append(this.toIndentedString(this.deprecationWarning)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    schema: ").append(this.toIndentedString(this.schema)).append("\n");
        sb.append("    selectableFields: ").append(this.toIndentedString(this.selectableFields)).append("\n");
        sb.append("    served: ").append(this.toIndentedString(this.served)).append("\n");
        sb.append("    storage: ").append(this.toIndentedString(this.storage)).append("\n");
        sb.append("    subresources: ").append(this.toIndentedString(this.subresources)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        JsonArray jsonArrayselectableFields;
        int i;
        JsonArray jsonArrayadditionalPrinterColumns;
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1CustomResourceDefinitionVersion is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1CustomResourceDefinitionVersion` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_ADDITIONAL_PRINTER_COLUMNS) != null && !jsonObj.get(SERIALIZED_NAME_ADDITIONAL_PRINTER_COLUMNS).isJsonNull() && (jsonArrayadditionalPrinterColumns = jsonObj.getAsJsonArray(SERIALIZED_NAME_ADDITIONAL_PRINTER_COLUMNS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_ADDITIONAL_PRINTER_COLUMNS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `additionalPrinterColumns` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ADDITIONAL_PRINTER_COLUMNS).toString()));
            }
            for (i = 0; i < jsonArrayadditionalPrinterColumns.size(); ++i) {
                V1CustomResourceColumnDefinition.validateJsonElement(jsonArrayadditionalPrinterColumns.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_DEPRECATION_WARNING) != null && !jsonObj.get(SERIALIZED_NAME_DEPRECATION_WARNING).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_DEPRECATION_WARNING).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `deprecationWarning` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DEPRECATION_WARNING).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SCHEMA) != null && !jsonObj.get(SERIALIZED_NAME_SCHEMA).isJsonNull()) {
            V1CustomResourceValidation.validateJsonElement(jsonObj.get(SERIALIZED_NAME_SCHEMA));
        }
        if (jsonObj.get(SERIALIZED_NAME_SELECTABLE_FIELDS) != null && !jsonObj.get(SERIALIZED_NAME_SELECTABLE_FIELDS).isJsonNull() && (jsonArrayselectableFields = jsonObj.getAsJsonArray(SERIALIZED_NAME_SELECTABLE_FIELDS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_SELECTABLE_FIELDS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `selectableFields` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SELECTABLE_FIELDS).toString()));
            }
            for (i = 0; i < jsonArrayselectableFields.size(); ++i) {
                V1SelectableField.validateJsonElement(jsonArrayselectableFields.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_SUBRESOURCES) != null && !jsonObj.get(SERIALIZED_NAME_SUBRESOURCES).isJsonNull()) {
            V1CustomResourceSubresources.validateJsonElement(jsonObj.get(SERIALIZED_NAME_SUBRESOURCES));
        }
    }

    public static V1CustomResourceDefinitionVersion fromJson(String jsonString) throws IOException {
        return (V1CustomResourceDefinitionVersion)JSON.getGson().fromJson(jsonString, V1CustomResourceDefinitionVersion.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ADDITIONAL_PRINTER_COLUMNS);
        openapiFields.add(SERIALIZED_NAME_DEPRECATED);
        openapiFields.add(SERIALIZED_NAME_DEPRECATION_WARNING);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_SCHEMA);
        openapiFields.add(SERIALIZED_NAME_SELECTABLE_FIELDS);
        openapiFields.add(SERIALIZED_NAME_SERVED);
        openapiFields.add(SERIALIZED_NAME_STORAGE);
        openapiFields.add(SERIALIZED_NAME_SUBRESOURCES);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_NAME);
        openapiRequiredFields.add(SERIALIZED_NAME_SERVED);
        openapiRequiredFields.add(SERIALIZED_NAME_STORAGE);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1CustomResourceDefinitionVersion.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1CustomResourceDefinitionVersion.class));
            return new TypeAdapter<V1CustomResourceDefinitionVersion>(){

                public void write(JsonWriter out, V1CustomResourceDefinitionVersion value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1CustomResourceDefinitionVersion read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1CustomResourceDefinitionVersion.validateJsonElement(jsonElement);
                    return (V1CustomResourceDefinitionVersion)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

