/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V1beta2Counter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="CounterSet defines a named set of counters that are available to be used by devices defined in the ResourceSlice.  The counters are not allocatable by themselves, but can be referenced by devices. When a device is allocated, the portion of counters it uses will no longer be available for use by other devices.")
public class V1beta2CounterSet {
    public static final String SERIALIZED_NAME_COUNTERS = "counters";
    @SerializedName(value="counters")
    private Map<String, V1beta2Counter> counters = new HashMap<String, V1beta2Counter>();
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;

    public V1beta2CounterSet counters(Map<String, V1beta2Counter> counters) {
        this.counters = counters;
        return this;
    }

    public V1beta2CounterSet putCountersItem(String key, V1beta2Counter countersItem) {
        this.counters.put(key, countersItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Counters defines the set of counters for this CounterSet The name of each counter must be unique in that set and must be a DNS label.  The maximum number of counters in all sets is 32.")
    public Map<String, V1beta2Counter> getCounters() {
        return this.counters;
    }

    public void setCounters(Map<String, V1beta2Counter> counters) {
        this.counters = counters;
    }

    public V1beta2CounterSet name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="Name defines the name of the counter set. It must be a DNS label.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1beta2CounterSet v1beta2CounterSet = (V1beta2CounterSet)o;
        return Objects.equals(this.counters, v1beta2CounterSet.counters) && Objects.equals(this.name, v1beta2CounterSet.name);
    }

    public int hashCode() {
        return Objects.hash(this.counters, this.name);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1beta2CounterSet {\n");
        sb.append("    counters: ").append(this.toIndentedString(this.counters)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

