/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V1ResourceHealth;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="ResourceStatus represents the status of a single resource allocated to a Pod.")
public class V1ResourceStatus {
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_RESOURCES = "resources";
    @SerializedName(value="resources")
    private List<V1ResourceHealth> resources = null;

    public V1ResourceStatus name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="Name of the resource. Must be unique within the pod and in case of non-DRA resource, match one of the resources from the pod spec. For DRA resources, the value must be \"claim:<claim_name>/<request>\". When this status is reported about a container, the \"claim_name\" and \"request\" must match one of the claims of this container.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public V1ResourceStatus resources(List<V1ResourceHealth> resources) {
        this.resources = resources;
        return this;
    }

    public V1ResourceStatus addResourcesItem(V1ResourceHealth resourcesItem) {
        if (this.resources == null) {
            this.resources = new ArrayList<V1ResourceHealth>();
        }
        this.resources.add(resourcesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of unique resources health. Each element in the list contains an unique resource ID and its health. At a minimum, for the lifetime of a Pod, resource ID must uniquely identify the resource allocated to the Pod on the Node. If other Pod on the same Node reports the status with the same resource ID, it must be the same resource they share. See ResourceID type definition for a specific format it has in various use cases.")
    public List<V1ResourceHealth> getResources() {
        return this.resources;
    }

    public void setResources(List<V1ResourceHealth> resources) {
        this.resources = resources;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ResourceStatus v1ResourceStatus = (V1ResourceStatus)o;
        return Objects.equals(this.name, v1ResourceStatus.name) && Objects.equals(this.resources, v1ResourceStatus.resources);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.resources);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1ResourceStatus {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    resources: ").append(this.toIndentedString(this.resources)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

