/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="ContainerRestartRuleOnExitCodes describes the condition for handling an exited container based on its exit codes.")
public class V1ContainerRestartRuleOnExitCodes {
    public static final String SERIALIZED_NAME_OPERATOR = "operator";
    @SerializedName(value="operator")
    private String operator;
    public static final String SERIALIZED_NAME_VALUES = "values";
    @SerializedName(value="values")
    private List<Integer> values = null;

    public V1ContainerRestartRuleOnExitCodes operator(String operator) {
        this.operator = operator;
        return this;
    }

    @ApiModelProperty(required=true, value="Represents the relationship between the container exit code(s) and the specified values. Possible values are: - In: the requirement is satisfied if the container exit code is in the   set of specified values. - NotIn: the requirement is satisfied if the container exit code is   not in the set of specified values.")
    public String getOperator() {
        return this.operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public V1ContainerRestartRuleOnExitCodes values(List<Integer> values) {
        this.values = values;
        return this;
    }

    public V1ContainerRestartRuleOnExitCodes addValuesItem(Integer valuesItem) {
        if (this.values == null) {
            this.values = new ArrayList<Integer>();
        }
        this.values.add(valuesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Specifies the set of values to check for container exit codes. At most 255 elements are allowed.")
    public List<Integer> getValues() {
        return this.values;
    }

    public void setValues(List<Integer> values) {
        this.values = values;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ContainerRestartRuleOnExitCodes v1ContainerRestartRuleOnExitCodes = (V1ContainerRestartRuleOnExitCodes)o;
        return Objects.equals(this.operator, v1ContainerRestartRuleOnExitCodes.operator) && Objects.equals(this.values, v1ContainerRestartRuleOnExitCodes.values);
    }

    public int hashCode() {
        return Objects.hash(this.operator, this.values);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1ContainerRestartRuleOnExitCodes {\n");
        sb.append("    operator: ").append(this.toIndentedString(this.operator)).append("\n");
        sb.append("    values: ").append(this.toIndentedString(this.values)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

