/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V1ContainerPort;
import io.kubernetes.client.openapi.models.V1ContainerResizePolicy;
import io.kubernetes.client.openapi.models.V1ContainerRestartRule;
import io.kubernetes.client.openapi.models.V1EnvFromSource;
import io.kubernetes.client.openapi.models.V1EnvVar;
import io.kubernetes.client.openapi.models.V1Lifecycle;
import io.kubernetes.client.openapi.models.V1Probe;
import io.kubernetes.client.openapi.models.V1ResourceRequirements;
import io.kubernetes.client.openapi.models.V1SecurityContext;
import io.kubernetes.client.openapi.models.V1VolumeDevice;
import io.kubernetes.client.openapi.models.V1VolumeMount;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="A single application container that you want to run within a pod.")
public class V1Container {
    public static final String SERIALIZED_NAME_ARGS = "args";
    @SerializedName(value="args")
    private List<String> args = null;
    public static final String SERIALIZED_NAME_COMMAND = "command";
    @SerializedName(value="command")
    private List<String> command = null;
    public static final String SERIALIZED_NAME_ENV = "env";
    @SerializedName(value="env")
    private List<V1EnvVar> env = null;
    public static final String SERIALIZED_NAME_ENV_FROM = "envFrom";
    @SerializedName(value="envFrom")
    private List<V1EnvFromSource> envFrom = null;
    public static final String SERIALIZED_NAME_IMAGE = "image";
    @SerializedName(value="image")
    private String image;
    public static final String SERIALIZED_NAME_IMAGE_PULL_POLICY = "imagePullPolicy";
    @SerializedName(value="imagePullPolicy")
    private String imagePullPolicy;
    public static final String SERIALIZED_NAME_LIFECYCLE = "lifecycle";
    @SerializedName(value="lifecycle")
    private V1Lifecycle lifecycle;
    public static final String SERIALIZED_NAME_LIVENESS_PROBE = "livenessProbe";
    @SerializedName(value="livenessProbe")
    private V1Probe livenessProbe;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_PORTS = "ports";
    @SerializedName(value="ports")
    private List<V1ContainerPort> ports = null;
    public static final String SERIALIZED_NAME_READINESS_PROBE = "readinessProbe";
    @SerializedName(value="readinessProbe")
    private V1Probe readinessProbe;
    public static final String SERIALIZED_NAME_RESIZE_POLICY = "resizePolicy";
    @SerializedName(value="resizePolicy")
    private List<V1ContainerResizePolicy> resizePolicy = null;
    public static final String SERIALIZED_NAME_RESOURCES = "resources";
    @SerializedName(value="resources")
    private V1ResourceRequirements resources;
    public static final String SERIALIZED_NAME_RESTART_POLICY = "restartPolicy";
    @SerializedName(value="restartPolicy")
    private String restartPolicy;
    public static final String SERIALIZED_NAME_RESTART_POLICY_RULES = "restartPolicyRules";
    @SerializedName(value="restartPolicyRules")
    private List<V1ContainerRestartRule> restartPolicyRules = null;
    public static final String SERIALIZED_NAME_SECURITY_CONTEXT = "securityContext";
    @SerializedName(value="securityContext")
    private V1SecurityContext securityContext;
    public static final String SERIALIZED_NAME_STARTUP_PROBE = "startupProbe";
    @SerializedName(value="startupProbe")
    private V1Probe startupProbe;
    public static final String SERIALIZED_NAME_STDIN = "stdin";
    @SerializedName(value="stdin")
    private Boolean stdin;
    public static final String SERIALIZED_NAME_STDIN_ONCE = "stdinOnce";
    @SerializedName(value="stdinOnce")
    private Boolean stdinOnce;
    public static final String SERIALIZED_NAME_TERMINATION_MESSAGE_PATH = "terminationMessagePath";
    @SerializedName(value="terminationMessagePath")
    private String terminationMessagePath;
    public static final String SERIALIZED_NAME_TERMINATION_MESSAGE_POLICY = "terminationMessagePolicy";
    @SerializedName(value="terminationMessagePolicy")
    private String terminationMessagePolicy;
    public static final String SERIALIZED_NAME_TTY = "tty";
    @SerializedName(value="tty")
    private Boolean tty;
    public static final String SERIALIZED_NAME_VOLUME_DEVICES = "volumeDevices";
    @SerializedName(value="volumeDevices")
    private List<V1VolumeDevice> volumeDevices = null;
    public static final String SERIALIZED_NAME_VOLUME_MOUNTS = "volumeMounts";
    @SerializedName(value="volumeMounts")
    private List<V1VolumeMount> volumeMounts = null;
    public static final String SERIALIZED_NAME_WORKING_DIR = "workingDir";
    @SerializedName(value="workingDir")
    private String workingDir;

    public V1Container args(List<String> args) {
        this.args = args;
        return this;
    }

    public V1Container addArgsItem(String argsItem) {
        if (this.args == null) {
            this.args = new ArrayList<String>();
        }
        this.args.add(argsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Arguments to the entrypoint. The container image's CMD is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. Double $$ are reduced to a single $, which allows for escaping the $(VAR_NAME) syntax: i.e. \"$$(VAR_NAME)\" will produce the string literal \"$(VAR_NAME)\". Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell")
    public List<String> getArgs() {
        return this.args;
    }

    public void setArgs(List<String> args) {
        this.args = args;
    }

    public V1Container command(List<String> command) {
        this.command = command;
        return this;
    }

    public V1Container addCommandItem(String commandItem) {
        if (this.command == null) {
            this.command = new ArrayList<String>();
        }
        this.command.add(commandItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Entrypoint array. Not executed within a shell. The container image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. Double $$ are reduced to a single $, which allows for escaping the $(VAR_NAME) syntax: i.e. \"$$(VAR_NAME)\" will produce the string literal \"$(VAR_NAME)\". Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell")
    public List<String> getCommand() {
        return this.command;
    }

    public void setCommand(List<String> command) {
        this.command = command;
    }

    public V1Container env(List<V1EnvVar> env) {
        this.env = env;
        return this;
    }

    public V1Container addEnvItem(V1EnvVar envItem) {
        if (this.env == null) {
            this.env = new ArrayList<V1EnvVar>();
        }
        this.env.add(envItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of environment variables to set in the container. Cannot be updated.")
    public List<V1EnvVar> getEnv() {
        return this.env;
    }

    public void setEnv(List<V1EnvVar> env) {
        this.env = env;
    }

    public V1Container envFrom(List<V1EnvFromSource> envFrom) {
        this.envFrom = envFrom;
        return this;
    }

    public V1Container addEnvFromItem(V1EnvFromSource envFromItem) {
        if (this.envFrom == null) {
            this.envFrom = new ArrayList<V1EnvFromSource>();
        }
        this.envFrom.add(envFromItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of sources to populate environment variables in the container. The keys defined within a source may consist of any printable ASCII characters except '='. When a key exists in multiple sources, the value associated with the last source will take precedence. Values defined by an Env with a duplicate key will take precedence. Cannot be updated.")
    public List<V1EnvFromSource> getEnvFrom() {
        return this.envFrom;
    }

    public void setEnvFrom(List<V1EnvFromSource> envFrom) {
        this.envFrom = envFrom;
    }

    public V1Container image(String image) {
        this.image = image;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Container image name. More info: https://kubernetes.io/docs/concepts/containers/images This field is optional to allow higher level config management to default or override container images in workload controllers like Deployments and StatefulSets.")
    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public V1Container imagePullPolicy(String imagePullPolicy) {
        this.imagePullPolicy = imagePullPolicy;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Image pull policy. One of Always, Never, IfNotPresent. Defaults to Always if :latest tag is specified, or IfNotPresent otherwise. Cannot be updated. More info: https://kubernetes.io/docs/concepts/containers/images#updating-images")
    public String getImagePullPolicy() {
        return this.imagePullPolicy;
    }

    public void setImagePullPolicy(String imagePullPolicy) {
        this.imagePullPolicy = imagePullPolicy;
    }

    public V1Container lifecycle(V1Lifecycle lifecycle) {
        this.lifecycle = lifecycle;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1Lifecycle getLifecycle() {
        return this.lifecycle;
    }

    public void setLifecycle(V1Lifecycle lifecycle) {
        this.lifecycle = lifecycle;
    }

    public V1Container livenessProbe(V1Probe livenessProbe) {
        this.livenessProbe = livenessProbe;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1Probe getLivenessProbe() {
        return this.livenessProbe;
    }

    public void setLivenessProbe(V1Probe livenessProbe) {
        this.livenessProbe = livenessProbe;
    }

    public V1Container name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="Name of the container specified as a DNS_LABEL. Each container in a pod must have a unique name (DNS_LABEL). Cannot be updated.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public V1Container ports(List<V1ContainerPort> ports) {
        this.ports = ports;
        return this;
    }

    public V1Container addPortsItem(V1ContainerPort portsItem) {
        if (this.ports == null) {
            this.ports = new ArrayList<V1ContainerPort>();
        }
        this.ports.add(portsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of ports to expose from the container. Not specifying a port here DOES NOT prevent that port from being exposed. Any port which is listening on the default \"0.0.0.0\" address inside a container will be accessible from the network. Modifying this array with strategic merge patch may corrupt the data. For more information See https://github.com/kubernetes/kubernetes/issues/108255. Cannot be updated.")
    public List<V1ContainerPort> getPorts() {
        return this.ports;
    }

    public void setPorts(List<V1ContainerPort> ports) {
        this.ports = ports;
    }

    public V1Container readinessProbe(V1Probe readinessProbe) {
        this.readinessProbe = readinessProbe;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1Probe getReadinessProbe() {
        return this.readinessProbe;
    }

    public void setReadinessProbe(V1Probe readinessProbe) {
        this.readinessProbe = readinessProbe;
    }

    public V1Container resizePolicy(List<V1ContainerResizePolicy> resizePolicy) {
        this.resizePolicy = resizePolicy;
        return this;
    }

    public V1Container addResizePolicyItem(V1ContainerResizePolicy resizePolicyItem) {
        if (this.resizePolicy == null) {
            this.resizePolicy = new ArrayList<V1ContainerResizePolicy>();
        }
        this.resizePolicy.add(resizePolicyItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Resources resize policy for the container.")
    public List<V1ContainerResizePolicy> getResizePolicy() {
        return this.resizePolicy;
    }

    public void setResizePolicy(List<V1ContainerResizePolicy> resizePolicy) {
        this.resizePolicy = resizePolicy;
    }

    public V1Container resources(V1ResourceRequirements resources) {
        this.resources = resources;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1ResourceRequirements getResources() {
        return this.resources;
    }

    public void setResources(V1ResourceRequirements resources) {
        this.resources = resources;
    }

    public V1Container restartPolicy(String restartPolicy) {
        this.restartPolicy = restartPolicy;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="RestartPolicy defines the restart behavior of individual containers in a pod. This overrides the pod-level restart policy. When this field is not specified, the restart behavior is defined by the Pod's restart policy and the container type. Additionally, setting the RestartPolicy as \"Always\" for the init container will have the following effect: this init container will be continually restarted on exit until all regular containers have terminated. Once all regular containers have completed, all init containers with restartPolicy \"Always\" will be shut down. This lifecycle differs from normal init containers and is often referred to as a \"sidecar\" container. Although this init container still starts in the init container sequence, it does not wait for the container to complete before proceeding to the next init container. Instead, the next init container starts immediately after this init container is started, or after any startupProbe has successfully completed.")
    public String getRestartPolicy() {
        return this.restartPolicy;
    }

    public void setRestartPolicy(String restartPolicy) {
        this.restartPolicy = restartPolicy;
    }

    public V1Container restartPolicyRules(List<V1ContainerRestartRule> restartPolicyRules) {
        this.restartPolicyRules = restartPolicyRules;
        return this;
    }

    public V1Container addRestartPolicyRulesItem(V1ContainerRestartRule restartPolicyRulesItem) {
        if (this.restartPolicyRules == null) {
            this.restartPolicyRules = new ArrayList<V1ContainerRestartRule>();
        }
        this.restartPolicyRules.add(restartPolicyRulesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Represents a list of rules to be checked to determine if the container should be restarted on exit. The rules are evaluated in order. Once a rule matches a container exit condition, the remaining rules are ignored. If no rule matches the container exit condition, the Container-level restart policy determines the whether the container is restarted or not. Constraints on the rules: - At most 20 rules are allowed. - Rules can have the same action. - Identical rules are not forbidden in validations. When rules are specified, container MUST set RestartPolicy explicitly even it if matches the Pod's RestartPolicy.")
    public List<V1ContainerRestartRule> getRestartPolicyRules() {
        return this.restartPolicyRules;
    }

    public void setRestartPolicyRules(List<V1ContainerRestartRule> restartPolicyRules) {
        this.restartPolicyRules = restartPolicyRules;
    }

    public V1Container securityContext(V1SecurityContext securityContext) {
        this.securityContext = securityContext;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1SecurityContext getSecurityContext() {
        return this.securityContext;
    }

    public void setSecurityContext(V1SecurityContext securityContext) {
        this.securityContext = securityContext;
    }

    public V1Container startupProbe(V1Probe startupProbe) {
        this.startupProbe = startupProbe;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1Probe getStartupProbe() {
        return this.startupProbe;
    }

    public void setStartupProbe(V1Probe startupProbe) {
        this.startupProbe = startupProbe;
    }

    public V1Container stdin(Boolean stdin) {
        this.stdin = stdin;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether this container should allocate a buffer for stdin in the container runtime. If this is not set, reads from stdin in the container will always result in EOF. Default is false.")
    public Boolean getStdin() {
        return this.stdin;
    }

    public void setStdin(Boolean stdin) {
        this.stdin = stdin;
    }

    public V1Container stdinOnce(Boolean stdinOnce) {
        this.stdinOnce = stdinOnce;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether the container runtime should close the stdin channel after it has been opened by a single attach. When stdin is true the stdin stream will remain open across multiple attach sessions. If stdinOnce is set to true, stdin is opened on container start, is empty until the first client attaches to stdin, and then remains open and accepts data until the client disconnects, at which time stdin is closed and remains closed until the container is restarted. If this flag is false, a container processes that reads from stdin will never receive an EOF. Default is false")
    public Boolean getStdinOnce() {
        return this.stdinOnce;
    }

    public void setStdinOnce(Boolean stdinOnce) {
        this.stdinOnce = stdinOnce;
    }

    public V1Container terminationMessagePath(String terminationMessagePath) {
        this.terminationMessagePath = terminationMessagePath;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional: Path at which the file to which the container's termination message will be written is mounted into the container's filesystem. Message written is intended to be brief final status, such as an assertion failure message. Will be truncated by the node if greater than 4096 bytes. The total message length across all containers will be limited to 12kb. Defaults to /dev/termination-log. Cannot be updated.")
    public String getTerminationMessagePath() {
        return this.terminationMessagePath;
    }

    public void setTerminationMessagePath(String terminationMessagePath) {
        this.terminationMessagePath = terminationMessagePath;
    }

    public V1Container terminationMessagePolicy(String terminationMessagePolicy) {
        this.terminationMessagePolicy = terminationMessagePolicy;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicate how the termination message should be populated. File will use the contents of terminationMessagePath to populate the container status message on both success and failure. FallbackToLogsOnError will use the last chunk of container log output if the termination message file is empty and the container exited with an error. The log output is limited to 2048 bytes or 80 lines, whichever is smaller. Defaults to File. Cannot be updated.")
    public String getTerminationMessagePolicy() {
        return this.terminationMessagePolicy;
    }

    public void setTerminationMessagePolicy(String terminationMessagePolicy) {
        this.terminationMessagePolicy = terminationMessagePolicy;
    }

    public V1Container tty(Boolean tty) {
        this.tty = tty;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether this container should allocate a TTY for itself, also requires 'stdin' to be true. Default is false.")
    public Boolean getTty() {
        return this.tty;
    }

    public void setTty(Boolean tty) {
        this.tty = tty;
    }

    public V1Container volumeDevices(List<V1VolumeDevice> volumeDevices) {
        this.volumeDevices = volumeDevices;
        return this;
    }

    public V1Container addVolumeDevicesItem(V1VolumeDevice volumeDevicesItem) {
        if (this.volumeDevices == null) {
            this.volumeDevices = new ArrayList<V1VolumeDevice>();
        }
        this.volumeDevices.add(volumeDevicesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="volumeDevices is the list of block devices to be used by the container.")
    public List<V1VolumeDevice> getVolumeDevices() {
        return this.volumeDevices;
    }

    public void setVolumeDevices(List<V1VolumeDevice> volumeDevices) {
        this.volumeDevices = volumeDevices;
    }

    public V1Container volumeMounts(List<V1VolumeMount> volumeMounts) {
        this.volumeMounts = volumeMounts;
        return this;
    }

    public V1Container addVolumeMountsItem(V1VolumeMount volumeMountsItem) {
        if (this.volumeMounts == null) {
            this.volumeMounts = new ArrayList<V1VolumeMount>();
        }
        this.volumeMounts.add(volumeMountsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Pod volumes to mount into the container's filesystem. Cannot be updated.")
    public List<V1VolumeMount> getVolumeMounts() {
        return this.volumeMounts;
    }

    public void setVolumeMounts(List<V1VolumeMount> volumeMounts) {
        this.volumeMounts = volumeMounts;
    }

    public V1Container workingDir(String workingDir) {
        this.workingDir = workingDir;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Container's working directory. If not specified, the container runtime's default will be used, which might be configured in the container image. Cannot be updated.")
    public String getWorkingDir() {
        return this.workingDir;
    }

    public void setWorkingDir(String workingDir) {
        this.workingDir = workingDir;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1Container v1Container = (V1Container)o;
        return Objects.equals(this.args, v1Container.args) && Objects.equals(this.command, v1Container.command) && Objects.equals(this.env, v1Container.env) && Objects.equals(this.envFrom, v1Container.envFrom) && Objects.equals(this.image, v1Container.image) && Objects.equals(this.imagePullPolicy, v1Container.imagePullPolicy) && Objects.equals(this.lifecycle, v1Container.lifecycle) && Objects.equals(this.livenessProbe, v1Container.livenessProbe) && Objects.equals(this.name, v1Container.name) && Objects.equals(this.ports, v1Container.ports) && Objects.equals(this.readinessProbe, v1Container.readinessProbe) && Objects.equals(this.resizePolicy, v1Container.resizePolicy) && Objects.equals(this.resources, v1Container.resources) && Objects.equals(this.restartPolicy, v1Container.restartPolicy) && Objects.equals(this.restartPolicyRules, v1Container.restartPolicyRules) && Objects.equals(this.securityContext, v1Container.securityContext) && Objects.equals(this.startupProbe, v1Container.startupProbe) && Objects.equals(this.stdin, v1Container.stdin) && Objects.equals(this.stdinOnce, v1Container.stdinOnce) && Objects.equals(this.terminationMessagePath, v1Container.terminationMessagePath) && Objects.equals(this.terminationMessagePolicy, v1Container.terminationMessagePolicy) && Objects.equals(this.tty, v1Container.tty) && Objects.equals(this.volumeDevices, v1Container.volumeDevices) && Objects.equals(this.volumeMounts, v1Container.volumeMounts) && Objects.equals(this.workingDir, v1Container.workingDir);
    }

    public int hashCode() {
        return Objects.hash(this.args, this.command, this.env, this.envFrom, this.image, this.imagePullPolicy, this.lifecycle, this.livenessProbe, this.name, this.ports, this.readinessProbe, this.resizePolicy, this.resources, this.restartPolicy, this.restartPolicyRules, this.securityContext, this.startupProbe, this.stdin, this.stdinOnce, this.terminationMessagePath, this.terminationMessagePolicy, this.tty, this.volumeDevices, this.volumeMounts, this.workingDir);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1Container {\n");
        sb.append("    args: ").append(this.toIndentedString(this.args)).append("\n");
        sb.append("    command: ").append(this.toIndentedString(this.command)).append("\n");
        sb.append("    env: ").append(this.toIndentedString(this.env)).append("\n");
        sb.append("    envFrom: ").append(this.toIndentedString(this.envFrom)).append("\n");
        sb.append("    image: ").append(this.toIndentedString(this.image)).append("\n");
        sb.append("    imagePullPolicy: ").append(this.toIndentedString(this.imagePullPolicy)).append("\n");
        sb.append("    lifecycle: ").append(this.toIndentedString(this.lifecycle)).append("\n");
        sb.append("    livenessProbe: ").append(this.toIndentedString(this.livenessProbe)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    ports: ").append(this.toIndentedString(this.ports)).append("\n");
        sb.append("    readinessProbe: ").append(this.toIndentedString(this.readinessProbe)).append("\n");
        sb.append("    resizePolicy: ").append(this.toIndentedString(this.resizePolicy)).append("\n");
        sb.append("    resources: ").append(this.toIndentedString(this.resources)).append("\n");
        sb.append("    restartPolicy: ").append(this.toIndentedString(this.restartPolicy)).append("\n");
        sb.append("    restartPolicyRules: ").append(this.toIndentedString(this.restartPolicyRules)).append("\n");
        sb.append("    securityContext: ").append(this.toIndentedString(this.securityContext)).append("\n");
        sb.append("    startupProbe: ").append(this.toIndentedString(this.startupProbe)).append("\n");
        sb.append("    stdin: ").append(this.toIndentedString(this.stdin)).append("\n");
        sb.append("    stdinOnce: ").append(this.toIndentedString(this.stdinOnce)).append("\n");
        sb.append("    terminationMessagePath: ").append(this.toIndentedString(this.terminationMessagePath)).append("\n");
        sb.append("    terminationMessagePolicy: ").append(this.toIndentedString(this.terminationMessagePolicy)).append("\n");
        sb.append("    tty: ").append(this.toIndentedString(this.tty)).append("\n");
        sb.append("    volumeDevices: ").append(this.toIndentedString(this.volumeDevices)).append("\n");
        sb.append("    volumeMounts: ").append(this.toIndentedString(this.volumeMounts)).append("\n");
        sb.append("    workingDir: ").append(this.toIndentedString(this.workingDir)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

