/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1ForNode;
import io.kubernetes.client.openapi.models.V1ForZone;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="EndpointHints provides hints describing how an endpoint should be consumed.")
public class V1EndpointHints {
    public static final String SERIALIZED_NAME_FOR_NODES = "forNodes";
    @SerializedName(value="forNodes")
    @Nullable
    private List<V1ForNode> forNodes = new ArrayList<V1ForNode>();
    public static final String SERIALIZED_NAME_FOR_ZONES = "forZones";
    @SerializedName(value="forZones")
    @Nullable
    private List<V1ForZone> forZones = new ArrayList<V1ForZone>();
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1EndpointHints forNodes(@Nullable List<V1ForNode> forNodes) {
        this.forNodes = forNodes;
        return this;
    }

    public V1EndpointHints addForNodesItem(V1ForNode forNodesItem) {
        if (this.forNodes == null) {
            this.forNodes = new ArrayList<V1ForNode>();
        }
        this.forNodes.add(forNodesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="forNodes indicates the node(s) this endpoint should be consumed by when using topology aware routing. May contain a maximum of 8 entries. This is an Alpha feature and is only used when the PreferSameTrafficDistribution feature gate is enabled.")
    public List<V1ForNode> getForNodes() {
        return this.forNodes;
    }

    public void setForNodes(@Nullable List<V1ForNode> forNodes) {
        this.forNodes = forNodes;
    }

    public V1EndpointHints forZones(@Nullable List<V1ForZone> forZones) {
        this.forZones = forZones;
        return this;
    }

    public V1EndpointHints addForZonesItem(V1ForZone forZonesItem) {
        if (this.forZones == null) {
            this.forZones = new ArrayList<V1ForZone>();
        }
        this.forZones.add(forZonesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="forZones indicates the zone(s) this endpoint should be consumed by when using topology aware routing. May contain a maximum of 8 entries.")
    public List<V1ForZone> getForZones() {
        return this.forZones;
    }

    public void setForZones(@Nullable List<V1ForZone> forZones) {
        this.forZones = forZones;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1EndpointHints v1EndpointHints = (V1EndpointHints)o;
        return Objects.equals(this.forNodes, v1EndpointHints.forNodes) && Objects.equals(this.forZones, v1EndpointHints.forZones);
    }

    public int hashCode() {
        return Objects.hash(this.forNodes, this.forZones);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1EndpointHints {\n");
        sb.append("    forNodes: ").append(this.toIndentedString(this.forNodes)).append("\n");
        sb.append("    forZones: ").append(this.toIndentedString(this.forZones)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        JsonArray jsonArrayforZones;
        int i;
        JsonArray jsonArrayforNodes;
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1EndpointHints is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1EndpointHints` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_FOR_NODES) != null && !jsonObj.get(SERIALIZED_NAME_FOR_NODES).isJsonNull() && (jsonArrayforNodes = jsonObj.getAsJsonArray(SERIALIZED_NAME_FOR_NODES)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_FOR_NODES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `forNodes` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_FOR_NODES).toString()));
            }
            for (i = 0; i < jsonArrayforNodes.size(); ++i) {
                V1ForNode.validateJsonElement(jsonArrayforNodes.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_FOR_ZONES) != null && !jsonObj.get(SERIALIZED_NAME_FOR_ZONES).isJsonNull() && (jsonArrayforZones = jsonObj.getAsJsonArray(SERIALIZED_NAME_FOR_ZONES)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_FOR_ZONES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `forZones` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_FOR_ZONES).toString()));
            }
            for (i = 0; i < jsonArrayforZones.size(); ++i) {
                V1ForZone.validateJsonElement(jsonArrayforZones.get(i));
            }
        }
    }

    public static V1EndpointHints fromJson(String jsonString) throws IOException {
        return (V1EndpointHints)JSON.getGson().fromJson(jsonString, V1EndpointHints.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_FOR_NODES);
        openapiFields.add(SERIALIZED_NAME_FOR_ZONES);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1EndpointHints.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1EndpointHints.class));
            return new TypeAdapter<V1EndpointHints>(){

                public void write(JsonWriter out, V1EndpointHints value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1EndpointHints read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1EndpointHints.validateJsonElement(jsonElement);
                    return (V1EndpointHints)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

