/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1CustomResourceDefinitionCondition;
import io.kubernetes.client.openapi.models.V1CustomResourceDefinitionNames;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="CustomResourceDefinitionStatus indicates the state of the CustomResourceDefinition")
public class V1CustomResourceDefinitionStatus {
    public static final String SERIALIZED_NAME_ACCEPTED_NAMES = "acceptedNames";
    @SerializedName(value="acceptedNames")
    @Nullable
    private V1CustomResourceDefinitionNames acceptedNames;
    public static final String SERIALIZED_NAME_CONDITIONS = "conditions";
    @SerializedName(value="conditions")
    @Nullable
    private List<V1CustomResourceDefinitionCondition> conditions = new ArrayList<V1CustomResourceDefinitionCondition>();
    public static final String SERIALIZED_NAME_STORED_VERSIONS = "storedVersions";
    @SerializedName(value="storedVersions")
    @Nullable
    private List<String> storedVersions = new ArrayList<String>();
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1CustomResourceDefinitionStatus acceptedNames(@Nullable V1CustomResourceDefinitionNames acceptedNames) {
        this.acceptedNames = acceptedNames;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1CustomResourceDefinitionNames getAcceptedNames() {
        return this.acceptedNames;
    }

    public void setAcceptedNames(@Nullable V1CustomResourceDefinitionNames acceptedNames) {
        this.acceptedNames = acceptedNames;
    }

    public V1CustomResourceDefinitionStatus conditions(@Nullable List<V1CustomResourceDefinitionCondition> conditions) {
        this.conditions = conditions;
        return this;
    }

    public V1CustomResourceDefinitionStatus addConditionsItem(V1CustomResourceDefinitionCondition conditionsItem) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<V1CustomResourceDefinitionCondition>();
        }
        this.conditions.add(conditionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="conditions indicate state for particular aspects of a CustomResourceDefinition")
    public List<V1CustomResourceDefinitionCondition> getConditions() {
        return this.conditions;
    }

    public void setConditions(@Nullable List<V1CustomResourceDefinitionCondition> conditions) {
        this.conditions = conditions;
    }

    public V1CustomResourceDefinitionStatus storedVersions(@Nullable List<String> storedVersions) {
        this.storedVersions = storedVersions;
        return this;
    }

    public V1CustomResourceDefinitionStatus addStoredVersionsItem(String storedVersionsItem) {
        if (this.storedVersions == null) {
            this.storedVersions = new ArrayList<String>();
        }
        this.storedVersions.add(storedVersionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="storedVersions lists all versions of CustomResources that were ever persisted. Tracking these versions allows a migration path for stored versions in etcd. The field is mutable so a migration controller can finish a migration to another version (ensuring no old objects are left in storage), and then remove the rest of the versions from this list. Versions may not be removed from `spec.versions` while they exist in this list.")
    public List<String> getStoredVersions() {
        return this.storedVersions;
    }

    public void setStoredVersions(@Nullable List<String> storedVersions) {
        this.storedVersions = storedVersions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1CustomResourceDefinitionStatus v1CustomResourceDefinitionStatus = (V1CustomResourceDefinitionStatus)o;
        return Objects.equals(this.acceptedNames, v1CustomResourceDefinitionStatus.acceptedNames) && Objects.equals(this.conditions, v1CustomResourceDefinitionStatus.conditions) && Objects.equals(this.storedVersions, v1CustomResourceDefinitionStatus.storedVersions);
    }

    public int hashCode() {
        return Objects.hash(this.acceptedNames, this.conditions, this.storedVersions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1CustomResourceDefinitionStatus {\n");
        sb.append("    acceptedNames: ").append(this.toIndentedString(this.acceptedNames)).append("\n");
        sb.append("    conditions: ").append(this.toIndentedString(this.conditions)).append("\n");
        sb.append("    storedVersions: ").append(this.toIndentedString(this.storedVersions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        JsonArray jsonArrayconditions;
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1CustomResourceDefinitionStatus is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1CustomResourceDefinitionStatus` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_ACCEPTED_NAMES) != null && !jsonObj.get(SERIALIZED_NAME_ACCEPTED_NAMES).isJsonNull()) {
            V1CustomResourceDefinitionNames.validateJsonElement(jsonObj.get(SERIALIZED_NAME_ACCEPTED_NAMES));
        }
        if (jsonObj.get(SERIALIZED_NAME_CONDITIONS) != null && !jsonObj.get(SERIALIZED_NAME_CONDITIONS).isJsonNull() && (jsonArrayconditions = jsonObj.getAsJsonArray(SERIALIZED_NAME_CONDITIONS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_CONDITIONS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `conditions` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CONDITIONS).toString()));
            }
            for (int i = 0; i < jsonArrayconditions.size(); ++i) {
                V1CustomResourceDefinitionCondition.validateJsonElement(jsonArrayconditions.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_STORED_VERSIONS) != null && !jsonObj.get(SERIALIZED_NAME_STORED_VERSIONS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_STORED_VERSIONS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `storedVersions` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STORED_VERSIONS).toString()));
        }
    }

    public static V1CustomResourceDefinitionStatus fromJson(String jsonString) throws IOException {
        return (V1CustomResourceDefinitionStatus)JSON.getGson().fromJson(jsonString, V1CustomResourceDefinitionStatus.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ACCEPTED_NAMES);
        openapiFields.add(SERIALIZED_NAME_CONDITIONS);
        openapiFields.add(SERIALIZED_NAME_STORED_VERSIONS);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1CustomResourceDefinitionStatus.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1CustomResourceDefinitionStatus.class));
            return new TypeAdapter<V1CustomResourceDefinitionStatus>(){

                public void write(JsonWriter out, V1CustomResourceDefinitionStatus value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1CustomResourceDefinitionStatus read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1CustomResourceDefinitionStatus.validateJsonElement(jsonElement);
                    return (V1CustomResourceDefinitionStatus)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

