/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V1NodeSelector;
import io.kubernetes.client.openapi.models.V1alpha3CounterSet;
import io.kubernetes.client.openapi.models.V1alpha3Device;
import io.kubernetes.client.openapi.models.V1alpha3ResourcePool;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="ResourceSliceSpec contains the information published by the driver in one ResourceSlice.")
public class V1alpha3ResourceSliceSpec {
    public static final String SERIALIZED_NAME_ALL_NODES = "allNodes";
    @SerializedName(value="allNodes")
    private Boolean allNodes;
    public static final String SERIALIZED_NAME_DEVICES = "devices";
    @SerializedName(value="devices")
    private List<V1alpha3Device> devices = null;
    public static final String SERIALIZED_NAME_DRIVER = "driver";
    @SerializedName(value="driver")
    private String driver;
    public static final String SERIALIZED_NAME_NODE_NAME = "nodeName";
    @SerializedName(value="nodeName")
    private String nodeName;
    public static final String SERIALIZED_NAME_NODE_SELECTOR = "nodeSelector";
    @SerializedName(value="nodeSelector")
    private V1NodeSelector nodeSelector;
    public static final String SERIALIZED_NAME_PER_DEVICE_NODE_SELECTION = "perDeviceNodeSelection";
    @SerializedName(value="perDeviceNodeSelection")
    private Boolean perDeviceNodeSelection;
    public static final String SERIALIZED_NAME_POOL = "pool";
    @SerializedName(value="pool")
    private V1alpha3ResourcePool pool;
    public static final String SERIALIZED_NAME_SHARED_COUNTERS = "sharedCounters";
    @SerializedName(value="sharedCounters")
    private List<V1alpha3CounterSet> sharedCounters = null;

    public V1alpha3ResourceSliceSpec allNodes(Boolean allNodes) {
        this.allNodes = allNodes;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="AllNodes indicates that all nodes have access to the resources in the pool.  Exactly one of NodeName, NodeSelector, AllNodes, and PerDeviceNodeSelection must be set.")
    public Boolean getAllNodes() {
        return this.allNodes;
    }

    public void setAllNodes(Boolean allNodes) {
        this.allNodes = allNodes;
    }

    public V1alpha3ResourceSliceSpec devices(List<V1alpha3Device> devices) {
        this.devices = devices;
        return this;
    }

    public V1alpha3ResourceSliceSpec addDevicesItem(V1alpha3Device devicesItem) {
        if (this.devices == null) {
            this.devices = new ArrayList<V1alpha3Device>();
        }
        this.devices.add(devicesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Devices lists some or all of the devices in this pool.  Must not have more than 128 entries.")
    public List<V1alpha3Device> getDevices() {
        return this.devices;
    }

    public void setDevices(List<V1alpha3Device> devices) {
        this.devices = devices;
    }

    public V1alpha3ResourceSliceSpec driver(String driver) {
        this.driver = driver;
        return this;
    }

    @ApiModelProperty(required=true, value="Driver identifies the DRA driver providing the capacity information. A field selector can be used to list only ResourceSlice objects with a certain driver name.  Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver. This field is immutable.")
    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public V1alpha3ResourceSliceSpec nodeName(String nodeName) {
        this.nodeName = nodeName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="NodeName identifies the node which provides the resources in this pool. A field selector can be used to list only ResourceSlice objects belonging to a certain node.  This field can be used to limit access from nodes to ResourceSlices with the same node name. It also indicates to autoscalers that adding new nodes of the same type as some old node might also make new resources available.  Exactly one of NodeName, NodeSelector, AllNodes, and PerDeviceNodeSelection must be set. This field is immutable.")
    public String getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public V1alpha3ResourceSliceSpec nodeSelector(V1NodeSelector nodeSelector) {
        this.nodeSelector = nodeSelector;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1NodeSelector getNodeSelector() {
        return this.nodeSelector;
    }

    public void setNodeSelector(V1NodeSelector nodeSelector) {
        this.nodeSelector = nodeSelector;
    }

    public V1alpha3ResourceSliceSpec perDeviceNodeSelection(Boolean perDeviceNodeSelection) {
        this.perDeviceNodeSelection = perDeviceNodeSelection;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="PerDeviceNodeSelection defines whether the access from nodes to resources in the pool is set on the ResourceSlice level or on each device. If it is set to true, every device defined the ResourceSlice must specify this individually.  Exactly one of NodeName, NodeSelector, AllNodes, and PerDeviceNodeSelection must be set.")
    public Boolean getPerDeviceNodeSelection() {
        return this.perDeviceNodeSelection;
    }

    public void setPerDeviceNodeSelection(Boolean perDeviceNodeSelection) {
        this.perDeviceNodeSelection = perDeviceNodeSelection;
    }

    public V1alpha3ResourceSliceSpec pool(V1alpha3ResourcePool pool) {
        this.pool = pool;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public V1alpha3ResourcePool getPool() {
        return this.pool;
    }

    public void setPool(V1alpha3ResourcePool pool) {
        this.pool = pool;
    }

    public V1alpha3ResourceSliceSpec sharedCounters(List<V1alpha3CounterSet> sharedCounters) {
        this.sharedCounters = sharedCounters;
        return this;
    }

    public V1alpha3ResourceSliceSpec addSharedCountersItem(V1alpha3CounterSet sharedCountersItem) {
        if (this.sharedCounters == null) {
            this.sharedCounters = new ArrayList<V1alpha3CounterSet>();
        }
        this.sharedCounters.add(sharedCountersItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="SharedCounters defines a list of counter sets, each of which has a name and a list of counters available.  The names of the SharedCounters must be unique in the ResourceSlice.  The maximum number of SharedCounters is 32.")
    public List<V1alpha3CounterSet> getSharedCounters() {
        return this.sharedCounters;
    }

    public void setSharedCounters(List<V1alpha3CounterSet> sharedCounters) {
        this.sharedCounters = sharedCounters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1alpha3ResourceSliceSpec v1alpha3ResourceSliceSpec = (V1alpha3ResourceSliceSpec)o;
        return Objects.equals(this.allNodes, v1alpha3ResourceSliceSpec.allNodes) && Objects.equals(this.devices, v1alpha3ResourceSliceSpec.devices) && Objects.equals(this.driver, v1alpha3ResourceSliceSpec.driver) && Objects.equals(this.nodeName, v1alpha3ResourceSliceSpec.nodeName) && Objects.equals(this.nodeSelector, v1alpha3ResourceSliceSpec.nodeSelector) && Objects.equals(this.perDeviceNodeSelection, v1alpha3ResourceSliceSpec.perDeviceNodeSelection) && Objects.equals(this.pool, v1alpha3ResourceSliceSpec.pool) && Objects.equals(this.sharedCounters, v1alpha3ResourceSliceSpec.sharedCounters);
    }

    public int hashCode() {
        return Objects.hash(this.allNodes, this.devices, this.driver, this.nodeName, this.nodeSelector, this.perDeviceNodeSelection, this.pool, this.sharedCounters);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1alpha3ResourceSliceSpec {\n");
        sb.append("    allNodes: ").append(this.toIndentedString(this.allNodes)).append("\n");
        sb.append("    devices: ").append(this.toIndentedString(this.devices)).append("\n");
        sb.append("    driver: ").append(this.toIndentedString(this.driver)).append("\n");
        sb.append("    nodeName: ").append(this.toIndentedString(this.nodeName)).append("\n");
        sb.append("    nodeSelector: ").append(this.toIndentedString(this.nodeSelector)).append("\n");
        sb.append("    perDeviceNodeSelection: ").append(this.toIndentedString(this.perDeviceNodeSelection)).append("\n");
        sb.append("    pool: ").append(this.toIndentedString(this.pool)).append("\n");
        sb.append("    sharedCounters: ").append(this.toIndentedString(this.sharedCounters)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

