/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1NodeSelectorTerm;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="An empty preferred scheduling term matches all objects with implicit weight 0 (i.e. it's a no-op). A null preferred scheduling term matches no objects (i.e. is also a no-op).")
public class V1PreferredSchedulingTerm {
    public static final String SERIALIZED_NAME_PREFERENCE = "preference";
    @SerializedName(value="preference")
    private V1NodeSelectorTerm preference;
    public static final String SERIALIZED_NAME_WEIGHT = "weight";
    @SerializedName(value="weight")
    private Integer weight;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1PreferredSchedulingTerm preference(V1NodeSelectorTerm preference) {
        this.preference = preference;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public V1NodeSelectorTerm getPreference() {
        return this.preference;
    }

    public void setPreference(V1NodeSelectorTerm preference) {
        this.preference = preference;
    }

    public V1PreferredSchedulingTerm weight(Integer weight) {
        this.weight = weight;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Weight associated with matching the corresponding nodeSelectorTerm, in the range 1-100.")
    public Integer getWeight() {
        return this.weight;
    }

    public void setWeight(Integer weight) {
        this.weight = weight;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1PreferredSchedulingTerm v1PreferredSchedulingTerm = (V1PreferredSchedulingTerm)o;
        return Objects.equals(this.preference, v1PreferredSchedulingTerm.preference) && Objects.equals(this.weight, v1PreferredSchedulingTerm.weight);
    }

    public int hashCode() {
        return Objects.hash(this.preference, this.weight);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1PreferredSchedulingTerm {\n");
        sb.append("    preference: ").append(this.toIndentedString(this.preference)).append("\n");
        sb.append("    weight: ").append(this.toIndentedString(this.weight)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1PreferredSchedulingTerm is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1PreferredSchedulingTerm` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        V1NodeSelectorTerm.validateJsonElement(jsonObj.get(SERIALIZED_NAME_PREFERENCE));
    }

    public static V1PreferredSchedulingTerm fromJson(String jsonString) throws IOException {
        return (V1PreferredSchedulingTerm)JSON.getGson().fromJson(jsonString, V1PreferredSchedulingTerm.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_PREFERENCE);
        openapiFields.add(SERIALIZED_NAME_WEIGHT);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_PREFERENCE);
        openapiRequiredFields.add(SERIALIZED_NAME_WEIGHT);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1PreferredSchedulingTerm.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1PreferredSchedulingTerm.class));
            return new TypeAdapter<V1PreferredSchedulingTerm>(){

                public void write(JsonWriter out, V1PreferredSchedulingTerm value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1PreferredSchedulingTerm read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1PreferredSchedulingTerm.validateJsonElement(jsonElement);
                    return (V1PreferredSchedulingTerm)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

