/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1CustomResourceConversion;
import io.kubernetes.client.openapi.models.V1CustomResourceDefinitionNames;
import io.kubernetes.client.openapi.models.V1CustomResourceDefinitionVersion;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="CustomResourceDefinitionSpec describes how a user wants their resource to appear")
public class V1CustomResourceDefinitionSpec {
    public static final String SERIALIZED_NAME_CONVERSION = "conversion";
    @SerializedName(value="conversion")
    private V1CustomResourceConversion conversion;
    public static final String SERIALIZED_NAME_GROUP = "group";
    @SerializedName(value="group")
    private String group;
    public static final String SERIALIZED_NAME_NAMES = "names";
    @SerializedName(value="names")
    private V1CustomResourceDefinitionNames names;
    public static final String SERIALIZED_NAME_PRESERVE_UNKNOWN_FIELDS = "preserveUnknownFields";
    @SerializedName(value="preserveUnknownFields")
    private Boolean preserveUnknownFields;
    public static final String SERIALIZED_NAME_SCOPE = "scope";
    @SerializedName(value="scope")
    private String scope;
    public static final String SERIALIZED_NAME_VERSIONS = "versions";
    @SerializedName(value="versions")
    private List<V1CustomResourceDefinitionVersion> versions = new ArrayList<V1CustomResourceDefinitionVersion>();
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1CustomResourceDefinitionSpec conversion(V1CustomResourceConversion conversion) {
        this.conversion = conversion;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1CustomResourceConversion getConversion() {
        return this.conversion;
    }

    public void setConversion(V1CustomResourceConversion conversion) {
        this.conversion = conversion;
    }

    public V1CustomResourceDefinitionSpec group(String group) {
        this.group = group;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="group is the API group of the defined custom resource. The custom resources are served under `/apis/<group>/...`. Must match the name of the CustomResourceDefinition (in the form `<names.plural>.<group>`).")
    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public V1CustomResourceDefinitionSpec names(V1CustomResourceDefinitionNames names) {
        this.names = names;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public V1CustomResourceDefinitionNames getNames() {
        return this.names;
    }

    public void setNames(V1CustomResourceDefinitionNames names) {
        this.names = names;
    }

    public V1CustomResourceDefinitionSpec preserveUnknownFields(Boolean preserveUnknownFields) {
        this.preserveUnknownFields = preserveUnknownFields;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="preserveUnknownFields indicates that object fields which are not specified in the OpenAPI schema should be preserved when persisting to storage. apiVersion, kind, metadata and known fields inside metadata are always preserved. This field is deprecated in favor of setting `x-preserve-unknown-fields` to true in `spec.versions[*].schema.openAPIV3Schema`. See https://kubernetes.io/docs/tasks/extend-kubernetes/custom-resources/custom-resource-definitions/#field-pruning for details.")
    public Boolean getPreserveUnknownFields() {
        return this.preserveUnknownFields;
    }

    public void setPreserveUnknownFields(Boolean preserveUnknownFields) {
        this.preserveUnknownFields = preserveUnknownFields;
    }

    public V1CustomResourceDefinitionSpec scope(String scope) {
        this.scope = scope;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="scope indicates whether the defined custom resource is cluster- or namespace-scoped. Allowed values are `Cluster` and `Namespaced`.")
    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public V1CustomResourceDefinitionSpec versions(List<V1CustomResourceDefinitionVersion> versions) {
        this.versions = versions;
        return this;
    }

    public V1CustomResourceDefinitionSpec addVersionsItem(V1CustomResourceDefinitionVersion versionsItem) {
        if (this.versions == null) {
            this.versions = new ArrayList<V1CustomResourceDefinitionVersion>();
        }
        this.versions.add(versionsItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="versions is the list of all API versions of the defined custom resource. Version names are used to compute the order in which served versions are listed in API discovery. If the version string is \"kube-like\", it will sort above non \"kube-like\" version strings, which are ordered lexicographically. \"Kube-like\" versions start with a \"v\", then are followed by a number (the major version), then optionally the string \"alpha\" or \"beta\" and another number (the minor version). These are sorted first by GA > beta > alpha (where GA is a version with no suffix such as beta or alpha), and then by comparing major version, then minor version. An example sorted list of versions: v10, v2, v1, v11beta2, v10beta3, v3beta1, v12alpha1, v11alpha2, foo1, foo10.")
    public List<V1CustomResourceDefinitionVersion> getVersions() {
        return this.versions;
    }

    public void setVersions(List<V1CustomResourceDefinitionVersion> versions) {
        this.versions = versions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1CustomResourceDefinitionSpec v1CustomResourceDefinitionSpec = (V1CustomResourceDefinitionSpec)o;
        return Objects.equals(this.conversion, v1CustomResourceDefinitionSpec.conversion) && Objects.equals(this.group, v1CustomResourceDefinitionSpec.group) && Objects.equals(this.names, v1CustomResourceDefinitionSpec.names) && Objects.equals(this.preserveUnknownFields, v1CustomResourceDefinitionSpec.preserveUnknownFields) && Objects.equals(this.scope, v1CustomResourceDefinitionSpec.scope) && Objects.equals(this.versions, v1CustomResourceDefinitionSpec.versions);
    }

    public int hashCode() {
        return Objects.hash(this.conversion, this.group, this.names, this.preserveUnknownFields, this.scope, this.versions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1CustomResourceDefinitionSpec {\n");
        sb.append("    conversion: ").append(this.toIndentedString(this.conversion)).append("\n");
        sb.append("    group: ").append(this.toIndentedString(this.group)).append("\n");
        sb.append("    names: ").append(this.toIndentedString(this.names)).append("\n");
        sb.append("    preserveUnknownFields: ").append(this.toIndentedString(this.preserveUnknownFields)).append("\n");
        sb.append("    scope: ").append(this.toIndentedString(this.scope)).append("\n");
        sb.append("    versions: ").append(this.toIndentedString(this.versions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1CustomResourceDefinitionSpec is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1CustomResourceDefinitionSpec` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_CONVERSION) != null && !jsonObj.get(SERIALIZED_NAME_CONVERSION).isJsonNull()) {
            V1CustomResourceConversion.validateJsonElement(jsonObj.get(SERIALIZED_NAME_CONVERSION));
        }
        if (!jsonObj.get(SERIALIZED_NAME_GROUP).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `group` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_GROUP).toString()));
        }
        V1CustomResourceDefinitionNames.validateJsonElement(jsonObj.get(SERIALIZED_NAME_NAMES));
        if (!jsonObj.get(SERIALIZED_NAME_SCOPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `scope` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SCOPE).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_VERSIONS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `versions` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VERSIONS).toString()));
        }
        JsonArray jsonArrayversions = jsonObj.getAsJsonArray(SERIALIZED_NAME_VERSIONS);
        for (int i = 0; i < jsonArrayversions.size(); ++i) {
            V1CustomResourceDefinitionVersion.validateJsonElement(jsonArrayversions.get(i));
        }
    }

    public static V1CustomResourceDefinitionSpec fromJson(String jsonString) throws IOException {
        return (V1CustomResourceDefinitionSpec)JSON.getGson().fromJson(jsonString, V1CustomResourceDefinitionSpec.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_CONVERSION);
        openapiFields.add(SERIALIZED_NAME_GROUP);
        openapiFields.add(SERIALIZED_NAME_NAMES);
        openapiFields.add(SERIALIZED_NAME_PRESERVE_UNKNOWN_FIELDS);
        openapiFields.add(SERIALIZED_NAME_SCOPE);
        openapiFields.add(SERIALIZED_NAME_VERSIONS);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_GROUP);
        openapiRequiredFields.add(SERIALIZED_NAME_NAMES);
        openapiRequiredFields.add(SERIALIZED_NAME_SCOPE);
        openapiRequiredFields.add(SERIALIZED_NAME_VERSIONS);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1CustomResourceDefinitionSpec.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1CustomResourceDefinitionSpec.class));
            return new TypeAdapter<V1CustomResourceDefinitionSpec>(){

                public void write(JsonWriter out, V1CustomResourceDefinitionSpec value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1CustomResourceDefinitionSpec read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1CustomResourceDefinitionSpec.validateJsonElement(jsonElement);
                    return (V1CustomResourceDefinitionSpec)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

