/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1alpha3DeviceClaim;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="ResourceClaimSpec defines what is being requested in a ResourceClaim and how to configure it.")
public class V1alpha3ResourceClaimSpec {
    public static final String SERIALIZED_NAME_CONTROLLER = "controller";
    @SerializedName(value="controller")
    private String controller;
    public static final String SERIALIZED_NAME_DEVICES = "devices";
    @SerializedName(value="devices")
    private V1alpha3DeviceClaim devices;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1alpha3ResourceClaimSpec controller(String controller) {
        this.controller = controller;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Controller is the name of the DRA driver that is meant to handle allocation of this claim. If empty, allocation is handled by the scheduler while scheduling a pod.  Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver.  This is an alpha field and requires enabling the DRAControlPlaneController feature gate.")
    public String getController() {
        return this.controller;
    }

    public void setController(String controller) {
        this.controller = controller;
    }

    public V1alpha3ResourceClaimSpec devices(V1alpha3DeviceClaim devices) {
        this.devices = devices;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1alpha3DeviceClaim getDevices() {
        return this.devices;
    }

    public void setDevices(V1alpha3DeviceClaim devices) {
        this.devices = devices;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1alpha3ResourceClaimSpec v1alpha3ResourceClaimSpec = (V1alpha3ResourceClaimSpec)o;
        return Objects.equals(this.controller, v1alpha3ResourceClaimSpec.controller) && Objects.equals(this.devices, v1alpha3ResourceClaimSpec.devices);
    }

    public int hashCode() {
        return Objects.hash(this.controller, this.devices);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1alpha3ResourceClaimSpec {\n");
        sb.append("    controller: ").append(this.toIndentedString(this.controller)).append("\n");
        sb.append("    devices: ").append(this.toIndentedString(this.devices)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1alpha3ResourceClaimSpec is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1alpha3ResourceClaimSpec` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_CONTROLLER) != null && !jsonObj.get(SERIALIZED_NAME_CONTROLLER).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CONTROLLER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `controller` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CONTROLLER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DEVICES) != null && !jsonObj.get(SERIALIZED_NAME_DEVICES).isJsonNull()) {
            V1alpha3DeviceClaim.validateJsonElement(jsonObj.get(SERIALIZED_NAME_DEVICES));
        }
    }

    public static V1alpha3ResourceClaimSpec fromJson(String jsonString) throws IOException {
        return (V1alpha3ResourceClaimSpec)JSON.getGson().fromJson(jsonString, V1alpha3ResourceClaimSpec.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_CONTROLLER);
        openapiFields.add(SERIALIZED_NAME_DEVICES);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1alpha3ResourceClaimSpec.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1alpha3ResourceClaimSpec.class));
            return new TypeAdapter<V1alpha3ResourceClaimSpec>(){

                public void write(JsonWriter out, V1alpha3ResourceClaimSpec value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1alpha3ResourceClaimSpec read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1alpha3ResourceClaimSpec.validateJsonElement(jsonElement);
                    return (V1alpha3ResourceClaimSpec)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

