/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1IPBlock;
import io.kubernetes.client.openapi.models.V1LabelSelector;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="NetworkPolicyPeer describes a peer to allow traffic to/from. Only certain combinations of fields are allowed")
public class V1NetworkPolicyPeer {
    public static final String SERIALIZED_NAME_IP_BLOCK = "ipBlock";
    @SerializedName(value="ipBlock")
    private V1IPBlock ipBlock;
    public static final String SERIALIZED_NAME_NAMESPACE_SELECTOR = "namespaceSelector";
    @SerializedName(value="namespaceSelector")
    private V1LabelSelector namespaceSelector;
    public static final String SERIALIZED_NAME_POD_SELECTOR = "podSelector";
    @SerializedName(value="podSelector")
    private V1LabelSelector podSelector;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1NetworkPolicyPeer ipBlock(V1IPBlock ipBlock) {
        this.ipBlock = ipBlock;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1IPBlock getIpBlock() {
        return this.ipBlock;
    }

    public void setIpBlock(V1IPBlock ipBlock) {
        this.ipBlock = ipBlock;
    }

    public V1NetworkPolicyPeer namespaceSelector(V1LabelSelector namespaceSelector) {
        this.namespaceSelector = namespaceSelector;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1LabelSelector getNamespaceSelector() {
        return this.namespaceSelector;
    }

    public void setNamespaceSelector(V1LabelSelector namespaceSelector) {
        this.namespaceSelector = namespaceSelector;
    }

    public V1NetworkPolicyPeer podSelector(V1LabelSelector podSelector) {
        this.podSelector = podSelector;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1LabelSelector getPodSelector() {
        return this.podSelector;
    }

    public void setPodSelector(V1LabelSelector podSelector) {
        this.podSelector = podSelector;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1NetworkPolicyPeer v1NetworkPolicyPeer = (V1NetworkPolicyPeer)o;
        return Objects.equals(this.ipBlock, v1NetworkPolicyPeer.ipBlock) && Objects.equals(this.namespaceSelector, v1NetworkPolicyPeer.namespaceSelector) && Objects.equals(this.podSelector, v1NetworkPolicyPeer.podSelector);
    }

    public int hashCode() {
        return Objects.hash(this.ipBlock, this.namespaceSelector, this.podSelector);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1NetworkPolicyPeer {\n");
        sb.append("    ipBlock: ").append(this.toIndentedString(this.ipBlock)).append("\n");
        sb.append("    namespaceSelector: ").append(this.toIndentedString(this.namespaceSelector)).append("\n");
        sb.append("    podSelector: ").append(this.toIndentedString(this.podSelector)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1NetworkPolicyPeer is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1NetworkPolicyPeer` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_IP_BLOCK) != null && !jsonObj.get(SERIALIZED_NAME_IP_BLOCK).isJsonNull()) {
            V1IPBlock.validateJsonElement(jsonObj.get(SERIALIZED_NAME_IP_BLOCK));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAMESPACE_SELECTOR) != null && !jsonObj.get(SERIALIZED_NAME_NAMESPACE_SELECTOR).isJsonNull()) {
            V1LabelSelector.validateJsonElement(jsonObj.get(SERIALIZED_NAME_NAMESPACE_SELECTOR));
        }
        if (jsonObj.get(SERIALIZED_NAME_POD_SELECTOR) != null && !jsonObj.get(SERIALIZED_NAME_POD_SELECTOR).isJsonNull()) {
            V1LabelSelector.validateJsonElement(jsonObj.get(SERIALIZED_NAME_POD_SELECTOR));
        }
    }

    public static V1NetworkPolicyPeer fromJson(String jsonString) throws IOException {
        return (V1NetworkPolicyPeer)JSON.getGson().fromJson(jsonString, V1NetworkPolicyPeer.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_IP_BLOCK);
        openapiFields.add(SERIALIZED_NAME_NAMESPACE_SELECTOR);
        openapiFields.add(SERIALIZED_NAME_POD_SELECTOR);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1NetworkPolicyPeer.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1NetworkPolicyPeer.class));
            return new TypeAdapter<V1NetworkPolicyPeer>(){

                public void write(JsonWriter out, V1NetworkPolicyPeer value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1NetworkPolicyPeer read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1NetworkPolicyPeer.validateJsonElement(jsonElement);
                    return (V1NetworkPolicyPeer)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

