/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V1ServicePort;
import io.kubernetes.client.openapi.models.V1SessionAffinityConfig;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="ServiceSpec describes the attributes that a user creates on a service.")
public class V1ServiceSpec {
    public static final String SERIALIZED_NAME_ALLOCATE_LOAD_BALANCER_NODE_PORTS = "allocateLoadBalancerNodePorts";
    @SerializedName(value="allocateLoadBalancerNodePorts")
    private Boolean allocateLoadBalancerNodePorts;
    public static final String SERIALIZED_NAME_CLUSTER_I_P = "clusterIP";
    @SerializedName(value="clusterIP")
    private String clusterIP;
    public static final String SERIALIZED_NAME_CLUSTER_I_PS = "clusterIPs";
    @SerializedName(value="clusterIPs")
    private List<String> clusterIPs = null;
    public static final String SERIALIZED_NAME_EXTERNAL_I_PS = "externalIPs";
    @SerializedName(value="externalIPs")
    private List<String> externalIPs = null;
    public static final String SERIALIZED_NAME_EXTERNAL_NAME = "externalName";
    @SerializedName(value="externalName")
    private String externalName;
    public static final String SERIALIZED_NAME_EXTERNAL_TRAFFIC_POLICY = "externalTrafficPolicy";
    @SerializedName(value="externalTrafficPolicy")
    private String externalTrafficPolicy;
    public static final String SERIALIZED_NAME_HEALTH_CHECK_NODE_PORT = "healthCheckNodePort";
    @SerializedName(value="healthCheckNodePort")
    private Integer healthCheckNodePort;
    public static final String SERIALIZED_NAME_INTERNAL_TRAFFIC_POLICY = "internalTrafficPolicy";
    @SerializedName(value="internalTrafficPolicy")
    private String internalTrafficPolicy;
    public static final String SERIALIZED_NAME_IP_FAMILIES = "ipFamilies";
    @SerializedName(value="ipFamilies")
    private List<String> ipFamilies = null;
    public static final String SERIALIZED_NAME_IP_FAMILY_POLICY = "ipFamilyPolicy";
    @SerializedName(value="ipFamilyPolicy")
    private String ipFamilyPolicy;
    public static final String SERIALIZED_NAME_LOAD_BALANCER_CLASS = "loadBalancerClass";
    @SerializedName(value="loadBalancerClass")
    private String loadBalancerClass;
    public static final String SERIALIZED_NAME_LOAD_BALANCER_I_P = "loadBalancerIP";
    @SerializedName(value="loadBalancerIP")
    private String loadBalancerIP;
    public static final String SERIALIZED_NAME_LOAD_BALANCER_SOURCE_RANGES = "loadBalancerSourceRanges";
    @SerializedName(value="loadBalancerSourceRanges")
    private List<String> loadBalancerSourceRanges = null;
    public static final String SERIALIZED_NAME_PORTS = "ports";
    @SerializedName(value="ports")
    private List<V1ServicePort> ports = null;
    public static final String SERIALIZED_NAME_PUBLISH_NOT_READY_ADDRESSES = "publishNotReadyAddresses";
    @SerializedName(value="publishNotReadyAddresses")
    private Boolean publishNotReadyAddresses;
    public static final String SERIALIZED_NAME_SELECTOR = "selector";
    @SerializedName(value="selector")
    private Map<String, String> selector = null;
    public static final String SERIALIZED_NAME_SESSION_AFFINITY = "sessionAffinity";
    @SerializedName(value="sessionAffinity")
    private String sessionAffinity;
    public static final String SERIALIZED_NAME_SESSION_AFFINITY_CONFIG = "sessionAffinityConfig";
    @SerializedName(value="sessionAffinityConfig")
    private V1SessionAffinityConfig sessionAffinityConfig;
    public static final String SERIALIZED_NAME_TRAFFIC_DISTRIBUTION = "trafficDistribution";
    @SerializedName(value="trafficDistribution")
    private String trafficDistribution;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private String type;

    public V1ServiceSpec allocateLoadBalancerNodePorts(Boolean allocateLoadBalancerNodePorts) {
        this.allocateLoadBalancerNodePorts = allocateLoadBalancerNodePorts;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="allocateLoadBalancerNodePorts defines if NodePorts will be automatically allocated for services with type LoadBalancer.  Default is \"true\". It may be set to \"false\" if the cluster load-balancer does not rely on NodePorts.  If the caller requests specific NodePorts (by specifying a value), those requests will be respected, regardless of this field. This field may only be set for services with type LoadBalancer and will be cleared if the type is changed to any other type.")
    public Boolean getAllocateLoadBalancerNodePorts() {
        return this.allocateLoadBalancerNodePorts;
    }

    public void setAllocateLoadBalancerNodePorts(Boolean allocateLoadBalancerNodePorts) {
        this.allocateLoadBalancerNodePorts = allocateLoadBalancerNodePorts;
    }

    public V1ServiceSpec clusterIP(String clusterIP) {
        this.clusterIP = clusterIP;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="clusterIP is the IP address of the service and is usually assigned randomly. If an address is specified manually, is in-range (as per system configuration), and is not in use, it will be allocated to the service; otherwise creation of the service will fail. This field may not be changed through updates unless the type field is also being changed to ExternalName (which requires this field to be blank) or the type field is being changed from ExternalName (in which case this field may optionally be specified, as describe above).  Valid values are \"None\", empty string (\"\"), or a valid IP address. Setting this to \"None\" makes a \"headless service\" (no virtual IP), which is useful when direct endpoint connections are preferred and proxying is not required.  Only applies to types ClusterIP, NodePort, and LoadBalancer. If this field is specified when creating a Service of type ExternalName, creation will fail. This field will be wiped when updating a Service to type ExternalName. More info: https://kubernetes.io/docs/concepts/services-networking/service/#virtual-ips-and-service-proxies")
    public String getClusterIP() {
        return this.clusterIP;
    }

    public void setClusterIP(String clusterIP) {
        this.clusterIP = clusterIP;
    }

    public V1ServiceSpec clusterIPs(List<String> clusterIPs) {
        this.clusterIPs = clusterIPs;
        return this;
    }

    public V1ServiceSpec addClusterIPsItem(String clusterIPsItem) {
        if (this.clusterIPs == null) {
            this.clusterIPs = new ArrayList<String>();
        }
        this.clusterIPs.add(clusterIPsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ClusterIPs is a list of IP addresses assigned to this service, and are usually assigned randomly.  If an address is specified manually, is in-range (as per system configuration), and is not in use, it will be allocated to the service; otherwise creation of the service will fail. This field may not be changed through updates unless the type field is also being changed to ExternalName (which requires this field to be empty) or the type field is being changed from ExternalName (in which case this field may optionally be specified, as describe above).  Valid values are \"None\", empty string (\"\"), or a valid IP address.  Setting this to \"None\" makes a \"headless service\" (no virtual IP), which is useful when direct endpoint connections are preferred and proxying is not required.  Only applies to types ClusterIP, NodePort, and LoadBalancer. If this field is specified when creating a Service of type ExternalName, creation will fail. This field will be wiped when updating a Service to type ExternalName.  If this field is not specified, it will be initialized from the clusterIP field.  If this field is specified, clients must ensure that clusterIPs[0] and clusterIP have the same value.  This field may hold a maximum of two entries (dual-stack IPs, in either order). These IPs must correspond to the values of the ipFamilies field. Both clusterIPs and ipFamilies are governed by the ipFamilyPolicy field. More info: https://kubernetes.io/docs/concepts/services-networking/service/#virtual-ips-and-service-proxies")
    public List<String> getClusterIPs() {
        return this.clusterIPs;
    }

    public void setClusterIPs(List<String> clusterIPs) {
        this.clusterIPs = clusterIPs;
    }

    public V1ServiceSpec externalIPs(List<String> externalIPs) {
        this.externalIPs = externalIPs;
        return this;
    }

    public V1ServiceSpec addExternalIPsItem(String externalIPsItem) {
        if (this.externalIPs == null) {
            this.externalIPs = new ArrayList<String>();
        }
        this.externalIPs.add(externalIPsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="externalIPs is a list of IP addresses for which nodes in the cluster will also accept traffic for this service.  These IPs are not managed by Kubernetes.  The user is responsible for ensuring that traffic arrives at a node with this IP.  A common example is external load-balancers that are not part of the Kubernetes system.")
    public List<String> getExternalIPs() {
        return this.externalIPs;
    }

    public void setExternalIPs(List<String> externalIPs) {
        this.externalIPs = externalIPs;
    }

    public V1ServiceSpec externalName(String externalName) {
        this.externalName = externalName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="externalName is the external reference that discovery mechanisms will return as an alias for this service (e.g. a DNS CNAME record). No proxying will be involved.  Must be a lowercase RFC-1123 hostname (https://tools.ietf.org/html/rfc1123) and requires `type` to be \"ExternalName\".")
    public String getExternalName() {
        return this.externalName;
    }

    public void setExternalName(String externalName) {
        this.externalName = externalName;
    }

    public V1ServiceSpec externalTrafficPolicy(String externalTrafficPolicy) {
        this.externalTrafficPolicy = externalTrafficPolicy;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="externalTrafficPolicy describes how nodes distribute service traffic they receive on one of the Service's \"externally-facing\" addresses (NodePorts, ExternalIPs, and LoadBalancer IPs). If set to \"Local\", the proxy will configure the service in a way that assumes that external load balancers will take care of balancing the service traffic between nodes, and so each node will deliver traffic only to the node-local endpoints of the service, without masquerading the client source IP. (Traffic mistakenly sent to a node with no endpoints will be dropped.) The default value, \"Cluster\", uses the standard behavior of routing to all endpoints evenly (possibly modified by topology and other features). Note that traffic sent to an External IP or LoadBalancer IP from within the cluster will always get \"Cluster\" semantics, but clients sending to a NodePort from within the cluster may need to take traffic policy into account when picking a node.")
    public String getExternalTrafficPolicy() {
        return this.externalTrafficPolicy;
    }

    public void setExternalTrafficPolicy(String externalTrafficPolicy) {
        this.externalTrafficPolicy = externalTrafficPolicy;
    }

    public V1ServiceSpec healthCheckNodePort(Integer healthCheckNodePort) {
        this.healthCheckNodePort = healthCheckNodePort;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="healthCheckNodePort specifies the healthcheck nodePort for the service. This only applies when type is set to LoadBalancer and externalTrafficPolicy is set to Local. If a value is specified, is in-range, and is not in use, it will be used.  If not specified, a value will be automatically allocated.  External systems (e.g. load-balancers) can use this port to determine if a given node holds endpoints for this service or not.  If this field is specified when creating a Service which does not need it, creation will fail. This field will be wiped when updating a Service to no longer need it (e.g. changing type). This field cannot be updated once set.")
    public Integer getHealthCheckNodePort() {
        return this.healthCheckNodePort;
    }

    public void setHealthCheckNodePort(Integer healthCheckNodePort) {
        this.healthCheckNodePort = healthCheckNodePort;
    }

    public V1ServiceSpec internalTrafficPolicy(String internalTrafficPolicy) {
        this.internalTrafficPolicy = internalTrafficPolicy;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="InternalTrafficPolicy describes how nodes distribute service traffic they receive on the ClusterIP. If set to \"Local\", the proxy will assume that pods only want to talk to endpoints of the service on the same node as the pod, dropping the traffic if there are no local endpoints. The default value, \"Cluster\", uses the standard behavior of routing to all endpoints evenly (possibly modified by topology and other features).")
    public String getInternalTrafficPolicy() {
        return this.internalTrafficPolicy;
    }

    public void setInternalTrafficPolicy(String internalTrafficPolicy) {
        this.internalTrafficPolicy = internalTrafficPolicy;
    }

    public V1ServiceSpec ipFamilies(List<String> ipFamilies) {
        this.ipFamilies = ipFamilies;
        return this;
    }

    public V1ServiceSpec addIpFamiliesItem(String ipFamiliesItem) {
        if (this.ipFamilies == null) {
            this.ipFamilies = new ArrayList<String>();
        }
        this.ipFamilies.add(ipFamiliesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="IPFamilies is a list of IP families (e.g. IPv4, IPv6) assigned to this service. This field is usually assigned automatically based on cluster configuration and the ipFamilyPolicy field. If this field is specified manually, the requested family is available in the cluster, and ipFamilyPolicy allows it, it will be used; otherwise creation of the service will fail. This field is conditionally mutable: it allows for adding or removing a secondary IP family, but it does not allow changing the primary IP family of the Service. Valid values are \"IPv4\" and \"IPv6\".  This field only applies to Services of types ClusterIP, NodePort, and LoadBalancer, and does apply to \"headless\" services. This field will be wiped when updating a Service to type ExternalName.  This field may hold a maximum of two entries (dual-stack families, in either order).  These families must correspond to the values of the clusterIPs field, if specified. Both clusterIPs and ipFamilies are governed by the ipFamilyPolicy field.")
    public List<String> getIpFamilies() {
        return this.ipFamilies;
    }

    public void setIpFamilies(List<String> ipFamilies) {
        this.ipFamilies = ipFamilies;
    }

    public V1ServiceSpec ipFamilyPolicy(String ipFamilyPolicy) {
        this.ipFamilyPolicy = ipFamilyPolicy;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="IPFamilyPolicy represents the dual-stack-ness requested or required by this Service. If there is no value provided, then this field will be set to SingleStack. Services can be \"SingleStack\" (a single IP family), \"PreferDualStack\" (two IP families on dual-stack configured clusters or a single IP family on single-stack clusters), or \"RequireDualStack\" (two IP families on dual-stack configured clusters, otherwise fail). The ipFamilies and clusterIPs fields depend on the value of this field. This field will be wiped when updating a service to type ExternalName.")
    public String getIpFamilyPolicy() {
        return this.ipFamilyPolicy;
    }

    public void setIpFamilyPolicy(String ipFamilyPolicy) {
        this.ipFamilyPolicy = ipFamilyPolicy;
    }

    public V1ServiceSpec loadBalancerClass(String loadBalancerClass) {
        this.loadBalancerClass = loadBalancerClass;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="loadBalancerClass is the class of the load balancer implementation this Service belongs to. If specified, the value of this field must be a label-style identifier, with an optional prefix, e.g. \"internal-vip\" or \"example.com/internal-vip\". Unprefixed names are reserved for end-users. This field can only be set when the Service type is 'LoadBalancer'. If not set, the default load balancer implementation is used, today this is typically done through the cloud provider integration, but should apply for any default implementation. If set, it is assumed that a load balancer implementation is watching for Services with a matching class. Any default load balancer implementation (e.g. cloud providers) should ignore Services that set this field. This field can only be set when creating or updating a Service to type 'LoadBalancer'. Once set, it can not be changed. This field will be wiped when a service is updated to a non 'LoadBalancer' type.")
    public String getLoadBalancerClass() {
        return this.loadBalancerClass;
    }

    public void setLoadBalancerClass(String loadBalancerClass) {
        this.loadBalancerClass = loadBalancerClass;
    }

    public V1ServiceSpec loadBalancerIP(String loadBalancerIP) {
        this.loadBalancerIP = loadBalancerIP;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only applies to Service Type: LoadBalancer. This feature depends on whether the underlying cloud-provider supports specifying the loadBalancerIP when a load balancer is created. This field will be ignored if the cloud-provider does not support the feature. Deprecated: This field was under-specified and its meaning varies across implementations. Using it is non-portable and it may not support dual-stack. Users are encouraged to use implementation-specific annotations when available.")
    public String getLoadBalancerIP() {
        return this.loadBalancerIP;
    }

    public void setLoadBalancerIP(String loadBalancerIP) {
        this.loadBalancerIP = loadBalancerIP;
    }

    public V1ServiceSpec loadBalancerSourceRanges(List<String> loadBalancerSourceRanges) {
        this.loadBalancerSourceRanges = loadBalancerSourceRanges;
        return this;
    }

    public V1ServiceSpec addLoadBalancerSourceRangesItem(String loadBalancerSourceRangesItem) {
        if (this.loadBalancerSourceRanges == null) {
            this.loadBalancerSourceRanges = new ArrayList<String>();
        }
        this.loadBalancerSourceRanges.add(loadBalancerSourceRangesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If specified and supported by the platform, this will restrict traffic through the cloud-provider load-balancer will be restricted to the specified client IPs. This field will be ignored if the cloud-provider does not support the feature.\" More info: https://kubernetes.io/docs/tasks/access-application-cluster/create-external-load-balancer/")
    public List<String> getLoadBalancerSourceRanges() {
        return this.loadBalancerSourceRanges;
    }

    public void setLoadBalancerSourceRanges(List<String> loadBalancerSourceRanges) {
        this.loadBalancerSourceRanges = loadBalancerSourceRanges;
    }

    public V1ServiceSpec ports(List<V1ServicePort> ports) {
        this.ports = ports;
        return this;
    }

    public V1ServiceSpec addPortsItem(V1ServicePort portsItem) {
        if (this.ports == null) {
            this.ports = new ArrayList<V1ServicePort>();
        }
        this.ports.add(portsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The list of ports that are exposed by this service. More info: https://kubernetes.io/docs/concepts/services-networking/service/#virtual-ips-and-service-proxies")
    public List<V1ServicePort> getPorts() {
        return this.ports;
    }

    public void setPorts(List<V1ServicePort> ports) {
        this.ports = ports;
    }

    public V1ServiceSpec publishNotReadyAddresses(Boolean publishNotReadyAddresses) {
        this.publishNotReadyAddresses = publishNotReadyAddresses;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="publishNotReadyAddresses indicates that any agent which deals with endpoints for this Service should disregard any indications of ready/not-ready. The primary use case for setting this field is for a StatefulSet's Headless Service to propagate SRV DNS records for its Pods for the purpose of peer discovery. The Kubernetes controllers that generate Endpoints and EndpointSlice resources for Services interpret this to mean that all endpoints are considered \"ready\" even if the Pods themselves are not. Agents which consume only Kubernetes generated endpoints through the Endpoints or EndpointSlice resources can safely assume this behavior.")
    public Boolean getPublishNotReadyAddresses() {
        return this.publishNotReadyAddresses;
    }

    public void setPublishNotReadyAddresses(Boolean publishNotReadyAddresses) {
        this.publishNotReadyAddresses = publishNotReadyAddresses;
    }

    public V1ServiceSpec selector(Map<String, String> selector) {
        this.selector = selector;
        return this;
    }

    public V1ServiceSpec putSelectorItem(String key, String selectorItem) {
        if (this.selector == null) {
            this.selector = new HashMap<String, String>();
        }
        this.selector.put(key, selectorItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Route service traffic to pods with label keys and values matching this selector. If empty or not present, the service is assumed to have an external process managing its endpoints, which Kubernetes will not modify. Only applies to types ClusterIP, NodePort, and LoadBalancer. Ignored if type is ExternalName. More info: https://kubernetes.io/docs/concepts/services-networking/service/")
    public Map<String, String> getSelector() {
        return this.selector;
    }

    public void setSelector(Map<String, String> selector) {
        this.selector = selector;
    }

    public V1ServiceSpec sessionAffinity(String sessionAffinity) {
        this.sessionAffinity = sessionAffinity;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Supports \"ClientIP\" and \"None\". Used to maintain session affinity. Enable client IP based session affinity. Must be ClientIP or None. Defaults to None. More info: https://kubernetes.io/docs/concepts/services-networking/service/#virtual-ips-and-service-proxies")
    public String getSessionAffinity() {
        return this.sessionAffinity;
    }

    public void setSessionAffinity(String sessionAffinity) {
        this.sessionAffinity = sessionAffinity;
    }

    public V1ServiceSpec sessionAffinityConfig(V1SessionAffinityConfig sessionAffinityConfig) {
        this.sessionAffinityConfig = sessionAffinityConfig;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1SessionAffinityConfig getSessionAffinityConfig() {
        return this.sessionAffinityConfig;
    }

    public void setSessionAffinityConfig(V1SessionAffinityConfig sessionAffinityConfig) {
        this.sessionAffinityConfig = sessionAffinityConfig;
    }

    public V1ServiceSpec trafficDistribution(String trafficDistribution) {
        this.trafficDistribution = trafficDistribution;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="TrafficDistribution offers a way to express preferences for how traffic is distributed to Service endpoints. Implementations can use this field as a hint, but are not required to guarantee strict adherence. If the field is not set, the implementation will apply its default routing strategy. If set to \"PreferClose\", implementations should prioritize endpoints that are topologically close (e.g., same zone). This is an alpha field and requires enabling ServiceTrafficDistribution feature.")
    public String getTrafficDistribution() {
        return this.trafficDistribution;
    }

    public void setTrafficDistribution(String trafficDistribution) {
        this.trafficDistribution = trafficDistribution;
    }

    public V1ServiceSpec type(String type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="type determines how the Service is exposed. Defaults to ClusterIP. Valid options are ExternalName, ClusterIP, NodePort, and LoadBalancer. \"ClusterIP\" allocates a cluster-internal IP address for load-balancing to endpoints. Endpoints are determined by the selector or if that is not specified, by manual construction of an Endpoints object or EndpointSlice objects. If clusterIP is \"None\", no virtual IP is allocated and the endpoints are published as a set of endpoints rather than a virtual IP. \"NodePort\" builds on ClusterIP and allocates a port on every node which routes to the same endpoints as the clusterIP. \"LoadBalancer\" builds on NodePort and creates an external load-balancer (if supported in the current cloud) which routes to the same endpoints as the clusterIP. \"ExternalName\" aliases this service to the specified externalName. Several other fields do not apply to ExternalName services. More info: https://kubernetes.io/docs/concepts/services-networking/service/#publishing-services-service-types")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ServiceSpec v1ServiceSpec = (V1ServiceSpec)o;
        return Objects.equals(this.allocateLoadBalancerNodePorts, v1ServiceSpec.allocateLoadBalancerNodePorts) && Objects.equals(this.clusterIP, v1ServiceSpec.clusterIP) && Objects.equals(this.clusterIPs, v1ServiceSpec.clusterIPs) && Objects.equals(this.externalIPs, v1ServiceSpec.externalIPs) && Objects.equals(this.externalName, v1ServiceSpec.externalName) && Objects.equals(this.externalTrafficPolicy, v1ServiceSpec.externalTrafficPolicy) && Objects.equals(this.healthCheckNodePort, v1ServiceSpec.healthCheckNodePort) && Objects.equals(this.internalTrafficPolicy, v1ServiceSpec.internalTrafficPolicy) && Objects.equals(this.ipFamilies, v1ServiceSpec.ipFamilies) && Objects.equals(this.ipFamilyPolicy, v1ServiceSpec.ipFamilyPolicy) && Objects.equals(this.loadBalancerClass, v1ServiceSpec.loadBalancerClass) && Objects.equals(this.loadBalancerIP, v1ServiceSpec.loadBalancerIP) && Objects.equals(this.loadBalancerSourceRanges, v1ServiceSpec.loadBalancerSourceRanges) && Objects.equals(this.ports, v1ServiceSpec.ports) && Objects.equals(this.publishNotReadyAddresses, v1ServiceSpec.publishNotReadyAddresses) && Objects.equals(this.selector, v1ServiceSpec.selector) && Objects.equals(this.sessionAffinity, v1ServiceSpec.sessionAffinity) && Objects.equals(this.sessionAffinityConfig, v1ServiceSpec.sessionAffinityConfig) && Objects.equals(this.trafficDistribution, v1ServiceSpec.trafficDistribution) && Objects.equals(this.type, v1ServiceSpec.type);
    }

    public int hashCode() {
        return Objects.hash(this.allocateLoadBalancerNodePorts, this.clusterIP, this.clusterIPs, this.externalIPs, this.externalName, this.externalTrafficPolicy, this.healthCheckNodePort, this.internalTrafficPolicy, this.ipFamilies, this.ipFamilyPolicy, this.loadBalancerClass, this.loadBalancerIP, this.loadBalancerSourceRanges, this.ports, this.publishNotReadyAddresses, this.selector, this.sessionAffinity, this.sessionAffinityConfig, this.trafficDistribution, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1ServiceSpec {\n");
        sb.append("    allocateLoadBalancerNodePorts: ").append(this.toIndentedString(this.allocateLoadBalancerNodePorts)).append("\n");
        sb.append("    clusterIP: ").append(this.toIndentedString(this.clusterIP)).append("\n");
        sb.append("    clusterIPs: ").append(this.toIndentedString(this.clusterIPs)).append("\n");
        sb.append("    externalIPs: ").append(this.toIndentedString(this.externalIPs)).append("\n");
        sb.append("    externalName: ").append(this.toIndentedString(this.externalName)).append("\n");
        sb.append("    externalTrafficPolicy: ").append(this.toIndentedString(this.externalTrafficPolicy)).append("\n");
        sb.append("    healthCheckNodePort: ").append(this.toIndentedString(this.healthCheckNodePort)).append("\n");
        sb.append("    internalTrafficPolicy: ").append(this.toIndentedString(this.internalTrafficPolicy)).append("\n");
        sb.append("    ipFamilies: ").append(this.toIndentedString(this.ipFamilies)).append("\n");
        sb.append("    ipFamilyPolicy: ").append(this.toIndentedString(this.ipFamilyPolicy)).append("\n");
        sb.append("    loadBalancerClass: ").append(this.toIndentedString(this.loadBalancerClass)).append("\n");
        sb.append("    loadBalancerIP: ").append(this.toIndentedString(this.loadBalancerIP)).append("\n");
        sb.append("    loadBalancerSourceRanges: ").append(this.toIndentedString(this.loadBalancerSourceRanges)).append("\n");
        sb.append("    ports: ").append(this.toIndentedString(this.ports)).append("\n");
        sb.append("    publishNotReadyAddresses: ").append(this.toIndentedString(this.publishNotReadyAddresses)).append("\n");
        sb.append("    selector: ").append(this.toIndentedString(this.selector)).append("\n");
        sb.append("    sessionAffinity: ").append(this.toIndentedString(this.sessionAffinity)).append("\n");
        sb.append("    sessionAffinityConfig: ").append(this.toIndentedString(this.sessionAffinityConfig)).append("\n");
        sb.append("    trafficDistribution: ").append(this.toIndentedString(this.trafficDistribution)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

