/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1Preconditions;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class V1DeleteOptions {
    public static final String SERIALIZED_NAME_API_VERSION = "apiVersion";
    @SerializedName(value="apiVersion")
    private String apiVersion;
    public static final String SERIALIZED_NAME_DRY_RUN = "dryRun";
    @SerializedName(value="dryRun")
    private List<String> dryRun = new ArrayList<String>();
    public static final String SERIALIZED_NAME_GRACE_PERIOD_SECONDS = "gracePeriodSeconds";
    @SerializedName(value="gracePeriodSeconds")
    private Long gracePeriodSeconds;
    public static final String SERIALIZED_NAME_KIND = "kind";
    @SerializedName(value="kind")
    private String kind;
    public static final String SERIALIZED_NAME_ORPHAN_DEPENDENTS = "orphanDependents";
    @SerializedName(value="orphanDependents")
    private Boolean orphanDependents;
    public static final String SERIALIZED_NAME_PRECONDITIONS = "preconditions";
    @SerializedName(value="preconditions")
    private V1Preconditions preconditions;
    public static final String SERIALIZED_NAME_PROPAGATION_POLICY = "propagationPolicy";
    @SerializedName(value="propagationPolicy")
    private String propagationPolicy;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1DeleteOptions apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @Nullable
    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public V1DeleteOptions dryRun(List<String> dryRun) {
        this.dryRun = dryRun;
        return this;
    }

    public V1DeleteOptions addDryRunItem(String dryRunItem) {
        if (this.dryRun == null) {
            this.dryRun = new ArrayList<String>();
        }
        this.dryRun.add(dryRunItem);
        return this;
    }

    @Nullable
    public List<String> getDryRun() {
        return this.dryRun;
    }

    public void setDryRun(List<String> dryRun) {
        this.dryRun = dryRun;
    }

    public V1DeleteOptions gracePeriodSeconds(Long gracePeriodSeconds) {
        this.gracePeriodSeconds = gracePeriodSeconds;
        return this;
    }

    @Nullable
    public Long getGracePeriodSeconds() {
        return this.gracePeriodSeconds;
    }

    public void setGracePeriodSeconds(Long gracePeriodSeconds) {
        this.gracePeriodSeconds = gracePeriodSeconds;
    }

    public V1DeleteOptions kind(String kind) {
        this.kind = kind;
        return this;
    }

    @Nullable
    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public V1DeleteOptions orphanDependents(Boolean orphanDependents) {
        this.orphanDependents = orphanDependents;
        return this;
    }

    @Nullable
    public Boolean getOrphanDependents() {
        return this.orphanDependents;
    }

    public void setOrphanDependents(Boolean orphanDependents) {
        this.orphanDependents = orphanDependents;
    }

    public V1DeleteOptions preconditions(V1Preconditions preconditions) {
        this.preconditions = preconditions;
        return this;
    }

    @Nullable
    public V1Preconditions getPreconditions() {
        return this.preconditions;
    }

    public void setPreconditions(V1Preconditions preconditions) {
        this.preconditions = preconditions;
    }

    public V1DeleteOptions propagationPolicy(String propagationPolicy) {
        this.propagationPolicy = propagationPolicy;
        return this;
    }

    @Nullable
    public String getPropagationPolicy() {
        return this.propagationPolicy;
    }

    public void setPropagationPolicy(String propagationPolicy) {
        this.propagationPolicy = propagationPolicy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1DeleteOptions v1DeleteOptions = (V1DeleteOptions)o;
        return Objects.equals(this.apiVersion, v1DeleteOptions.apiVersion) && Objects.equals(this.dryRun, v1DeleteOptions.dryRun) && Objects.equals(this.gracePeriodSeconds, v1DeleteOptions.gracePeriodSeconds) && Objects.equals(this.kind, v1DeleteOptions.kind) && Objects.equals(this.orphanDependents, v1DeleteOptions.orphanDependents) && Objects.equals(this.preconditions, v1DeleteOptions.preconditions) && Objects.equals(this.propagationPolicy, v1DeleteOptions.propagationPolicy);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.dryRun, this.gracePeriodSeconds, this.kind, this.orphanDependents, this.preconditions, this.propagationPolicy);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1DeleteOptions {\n");
        sb.append("    apiVersion: ").append(this.toIndentedString(this.apiVersion)).append("\n");
        sb.append("    dryRun: ").append(this.toIndentedString(this.dryRun)).append("\n");
        sb.append("    gracePeriodSeconds: ").append(this.toIndentedString(this.gracePeriodSeconds)).append("\n");
        sb.append("    kind: ").append(this.toIndentedString(this.kind)).append("\n");
        sb.append("    orphanDependents: ").append(this.toIndentedString(this.orphanDependents)).append("\n");
        sb.append("    preconditions: ").append(this.toIndentedString(this.preconditions)).append("\n");
        sb.append("    propagationPolicy: ").append(this.toIndentedString(this.propagationPolicy)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1DeleteOptions is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1DeleteOptions` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_API_VERSION) != null && !jsonObj.get(SERIALIZED_NAME_API_VERSION).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_API_VERSION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `apiVersion` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_API_VERSION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DRY_RUN) != null && !jsonObj.get(SERIALIZED_NAME_DRY_RUN).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_DRY_RUN).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `dryRun` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DRY_RUN).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_KIND) != null && !jsonObj.get(SERIALIZED_NAME_KIND).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_KIND).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `kind` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_KIND).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PRECONDITIONS) != null && !jsonObj.get(SERIALIZED_NAME_PRECONDITIONS).isJsonNull()) {
            V1Preconditions.validateJsonElement(jsonObj.get(SERIALIZED_NAME_PRECONDITIONS));
        }
        if (jsonObj.get(SERIALIZED_NAME_PROPAGATION_POLICY) != null && !jsonObj.get(SERIALIZED_NAME_PROPAGATION_POLICY).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_PROPAGATION_POLICY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `propagationPolicy` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PROPAGATION_POLICY).toString()));
        }
    }

    public static V1DeleteOptions fromJson(String jsonString) throws IOException {
        return (V1DeleteOptions)JSON.getGson().fromJson(jsonString, V1DeleteOptions.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_API_VERSION);
        openapiFields.add(SERIALIZED_NAME_DRY_RUN);
        openapiFields.add(SERIALIZED_NAME_GRACE_PERIOD_SECONDS);
        openapiFields.add(SERIALIZED_NAME_KIND);
        openapiFields.add(SERIALIZED_NAME_ORPHAN_DEPENDENTS);
        openapiFields.add(SERIALIZED_NAME_PRECONDITIONS);
        openapiFields.add(SERIALIZED_NAME_PROPAGATION_POLICY);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1DeleteOptions.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1DeleteOptions.class));
            return new TypeAdapter<V1DeleteOptions>(){

                public void write(JsonWriter out, V1DeleteOptions value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1DeleteOptions read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1DeleteOptions.validateJsonElement(jsonElement);
                    return (V1DeleteOptions)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

