/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V1LabelSelector;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="ParamRef describes how to locate the params to be used as input to expressions of rules applied by a policy binding.")
public class V1beta1ParamRef {
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_NAMESPACE = "namespace";
    @SerializedName(value="namespace")
    private String namespace;
    public static final String SERIALIZED_NAME_PARAMETER_NOT_FOUND_ACTION = "parameterNotFoundAction";
    @SerializedName(value="parameterNotFoundAction")
    private String parameterNotFoundAction;
    public static final String SERIALIZED_NAME_SELECTOR = "selector";
    @SerializedName(value="selector")
    private V1LabelSelector selector;

    public V1beta1ParamRef name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="name is the name of the resource being referenced.  One of `name` or `selector` must be set, but `name` and `selector` are mutually exclusive properties. If one is set, the other must be unset.  A single parameter used for all admission requests can be configured by setting the `name` field, leaving `selector` blank, and setting namespace if `paramKind` is namespace-scoped.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public V1beta1ParamRef namespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="namespace is the namespace of the referenced resource. Allows limiting the search for params to a specific namespace. Applies to both `name` and `selector` fields.  A per-namespace parameter may be used by specifying a namespace-scoped `paramKind` in the policy and leaving this field empty.  - If `paramKind` is cluster-scoped, this field MUST be unset. Setting this field results in a configuration error.  - If `paramKind` is namespace-scoped, the namespace of the object being evaluated for admission will be used when this field is left unset. Take care that if this is left empty the binding must not match any cluster-scoped resources, which will result in an error.")
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public V1beta1ParamRef parameterNotFoundAction(String parameterNotFoundAction) {
        this.parameterNotFoundAction = parameterNotFoundAction;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="`parameterNotFoundAction` controls the behavior of the binding when the resource exists, and name or selector is valid, but there are no parameters matched by the binding. If the value is set to `Allow`, then no matched parameters will be treated as successful validation by the binding. If set to `Deny`, then no matched parameters will be subject to the `failurePolicy` of the policy.  Allowed values are `Allow` or `Deny`  Required")
    public String getParameterNotFoundAction() {
        return this.parameterNotFoundAction;
    }

    public void setParameterNotFoundAction(String parameterNotFoundAction) {
        this.parameterNotFoundAction = parameterNotFoundAction;
    }

    public V1beta1ParamRef selector(V1LabelSelector selector) {
        this.selector = selector;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1LabelSelector getSelector() {
        return this.selector;
    }

    public void setSelector(V1LabelSelector selector) {
        this.selector = selector;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1beta1ParamRef v1beta1ParamRef = (V1beta1ParamRef)o;
        return Objects.equals(this.name, v1beta1ParamRef.name) && Objects.equals(this.namespace, v1beta1ParamRef.namespace) && Objects.equals(this.parameterNotFoundAction, v1beta1ParamRef.parameterNotFoundAction) && Objects.equals(this.selector, v1beta1ParamRef.selector);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.namespace, this.parameterNotFoundAction, this.selector);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1beta1ParamRef {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    namespace: ").append(this.toIndentedString(this.namespace)).append("\n");
        sb.append("    parameterNotFoundAction: ").append(this.toIndentedString(this.parameterNotFoundAction)).append("\n");
        sb.append("    selector: ").append(this.toIndentedString(this.selector)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

