/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V1alpha2ResourceRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="DriverRequests describes all resources that are needed from one particular driver.")
public class V1alpha2DriverRequests {
    public static final String SERIALIZED_NAME_DRIVER_NAME = "driverName";
    @SerializedName(value="driverName")
    private String driverName;
    public static final String SERIALIZED_NAME_REQUESTS = "requests";
    @SerializedName(value="requests")
    private List<V1alpha2ResourceRequest> requests = null;
    public static final String SERIALIZED_NAME_VENDOR_PARAMETERS = "vendorParameters";
    @SerializedName(value="vendorParameters")
    private Object vendorParameters;

    public V1alpha2DriverRequests driverName(String driverName) {
        this.driverName = driverName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="DriverName is the name used by the DRA driver kubelet plugin.")
    public String getDriverName() {
        return this.driverName;
    }

    public void setDriverName(String driverName) {
        this.driverName = driverName;
    }

    public V1alpha2DriverRequests requests(List<V1alpha2ResourceRequest> requests) {
        this.requests = requests;
        return this;
    }

    public V1alpha2DriverRequests addRequestsItem(V1alpha2ResourceRequest requestsItem) {
        if (this.requests == null) {
            this.requests = new ArrayList<V1alpha2ResourceRequest>();
        }
        this.requests.add(requestsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Requests describes all resources that are needed from the driver.")
    public List<V1alpha2ResourceRequest> getRequests() {
        return this.requests;
    }

    public void setRequests(List<V1alpha2ResourceRequest> requests) {
        this.requests = requests;
    }

    public V1alpha2DriverRequests vendorParameters(Object vendorParameters) {
        this.vendorParameters = vendorParameters;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="VendorParameters are arbitrary setup parameters for all requests of the claim. They are ignored while allocating the claim.")
    public Object getVendorParameters() {
        return this.vendorParameters;
    }

    public void setVendorParameters(Object vendorParameters) {
        this.vendorParameters = vendorParameters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1alpha2DriverRequests v1alpha2DriverRequests = (V1alpha2DriverRequests)o;
        return Objects.equals(this.driverName, v1alpha2DriverRequests.driverName) && Objects.equals(this.requests, v1alpha2DriverRequests.requests) && Objects.equals(this.vendorParameters, v1alpha2DriverRequests.vendorParameters);
    }

    public int hashCode() {
        return Objects.hash(this.driverName, this.requests, this.vendorParameters);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1alpha2DriverRequests {\n");
        sb.append("    driverName: ").append(this.toIndentedString(this.driverName)).append("\n");
        sb.append("    requests: ").append(this.toIndentedString(this.requests)).append("\n");
        sb.append("    vendorParameters: ").append(this.toIndentedString(this.vendorParameters)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

