/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="ClusterTrustBundleSpec contains the signer and trust anchors.")
public class V1alpha1ClusterTrustBundleSpec {
    public static final String SERIALIZED_NAME_SIGNER_NAME = "signerName";
    @SerializedName(value="signerName")
    private String signerName;
    public static final String SERIALIZED_NAME_TRUST_BUNDLE = "trustBundle";
    @SerializedName(value="trustBundle")
    private String trustBundle;

    public V1alpha1ClusterTrustBundleSpec signerName(String signerName) {
        this.signerName = signerName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="signerName indicates the associated signer, if any.  In order to create or update a ClusterTrustBundle that sets signerName, you must have the following cluster-scoped permission: group=certificates.k8s.io resource=signers resourceName=<the signer name> verb=attest.  If signerName is not empty, then the ClusterTrustBundle object must be named with the signer name as a prefix (translating slashes to colons). For example, for the signer name `example.com/foo`, valid ClusterTrustBundle object names include `example.com:foo:abc` and `example.com:foo:v1`.  If signerName is empty, then the ClusterTrustBundle object's name must not have such a prefix.  List/watch requests for ClusterTrustBundles can filter on this field using a `spec.signerName=NAME` field selector.")
    public String getSignerName() {
        return this.signerName;
    }

    public void setSignerName(String signerName) {
        this.signerName = signerName;
    }

    public V1alpha1ClusterTrustBundleSpec trustBundle(String trustBundle) {
        this.trustBundle = trustBundle;
        return this;
    }

    @ApiModelProperty(required=true, value="trustBundle contains the individual X.509 trust anchors for this bundle, as PEM bundle of PEM-wrapped, DER-formatted X.509 certificates.  The data must consist only of PEM certificate blocks that parse as valid X.509 certificates.  Each certificate must include a basic constraints extension with the CA bit set.  The API server will reject objects that contain duplicate certificates, or that use PEM block headers.  Users of ClusterTrustBundles, including Kubelet, are free to reorder and deduplicate certificate blocks in this file according to their own logic, as well as to drop PEM block headers and inter-block data.")
    public String getTrustBundle() {
        return this.trustBundle;
    }

    public void setTrustBundle(String trustBundle) {
        this.trustBundle = trustBundle;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1alpha1ClusterTrustBundleSpec v1alpha1ClusterTrustBundleSpec = (V1alpha1ClusterTrustBundleSpec)o;
        return Objects.equals(this.signerName, v1alpha1ClusterTrustBundleSpec.signerName) && Objects.equals(this.trustBundle, v1alpha1ClusterTrustBundleSpec.trustBundle);
    }

    public int hashCode() {
        return Objects.hash(this.signerName, this.trustBundle);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1alpha1ClusterTrustBundleSpec {\n");
        sb.append("    signerName: ").append(this.toIndentedString(this.signerName)).append("\n");
        sb.append("    trustBundle: ").append(this.toIndentedString(this.trustBundle)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

