/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="WindowsSecurityContextOptions contain Windows-specific options and credentials.")
public class V1WindowsSecurityContextOptions {
    public static final String SERIALIZED_NAME_GMSA_CREDENTIAL_SPEC = "gmsaCredentialSpec";
    @SerializedName(value="gmsaCredentialSpec")
    private String gmsaCredentialSpec;
    public static final String SERIALIZED_NAME_GMSA_CREDENTIAL_SPEC_NAME = "gmsaCredentialSpecName";
    @SerializedName(value="gmsaCredentialSpecName")
    private String gmsaCredentialSpecName;
    public static final String SERIALIZED_NAME_HOST_PROCESS = "hostProcess";
    @SerializedName(value="hostProcess")
    private Boolean hostProcess;
    public static final String SERIALIZED_NAME_RUN_AS_USER_NAME = "runAsUserName";
    @SerializedName(value="runAsUserName")
    private String runAsUserName;

    public V1WindowsSecurityContextOptions gmsaCredentialSpec(String gmsaCredentialSpec) {
        this.gmsaCredentialSpec = gmsaCredentialSpec;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="GMSACredentialSpec is where the GMSA admission webhook (https://github.com/kubernetes-sigs/windows-gmsa) inlines the contents of the GMSA credential spec named by the GMSACredentialSpecName field.")
    public String getGmsaCredentialSpec() {
        return this.gmsaCredentialSpec;
    }

    public void setGmsaCredentialSpec(String gmsaCredentialSpec) {
        this.gmsaCredentialSpec = gmsaCredentialSpec;
    }

    public V1WindowsSecurityContextOptions gmsaCredentialSpecName(String gmsaCredentialSpecName) {
        this.gmsaCredentialSpecName = gmsaCredentialSpecName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="GMSACredentialSpecName is the name of the GMSA credential spec to use.")
    public String getGmsaCredentialSpecName() {
        return this.gmsaCredentialSpecName;
    }

    public void setGmsaCredentialSpecName(String gmsaCredentialSpecName) {
        this.gmsaCredentialSpecName = gmsaCredentialSpecName;
    }

    public V1WindowsSecurityContextOptions hostProcess(Boolean hostProcess) {
        this.hostProcess = hostProcess;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="HostProcess determines if a container should be run as a 'Host Process' container. All of a Pod's containers must have the same effective HostProcess value (it is not allowed to have a mix of HostProcess containers and non-HostProcess containers). In addition, if HostProcess is true then HostNetwork must also be set to true.")
    public Boolean getHostProcess() {
        return this.hostProcess;
    }

    public void setHostProcess(Boolean hostProcess) {
        this.hostProcess = hostProcess;
    }

    public V1WindowsSecurityContextOptions runAsUserName(String runAsUserName) {
        this.runAsUserName = runAsUserName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The UserName in Windows to run the entrypoint of the container process. Defaults to the user specified in image metadata if unspecified. May also be set in PodSecurityContext. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.")
    public String getRunAsUserName() {
        return this.runAsUserName;
    }

    public void setRunAsUserName(String runAsUserName) {
        this.runAsUserName = runAsUserName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1WindowsSecurityContextOptions v1WindowsSecurityContextOptions = (V1WindowsSecurityContextOptions)o;
        return Objects.equals(this.gmsaCredentialSpec, v1WindowsSecurityContextOptions.gmsaCredentialSpec) && Objects.equals(this.gmsaCredentialSpecName, v1WindowsSecurityContextOptions.gmsaCredentialSpecName) && Objects.equals(this.hostProcess, v1WindowsSecurityContextOptions.hostProcess) && Objects.equals(this.runAsUserName, v1WindowsSecurityContextOptions.runAsUserName);
    }

    public int hashCode() {
        return Objects.hash(this.gmsaCredentialSpec, this.gmsaCredentialSpecName, this.hostProcess, this.runAsUserName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1WindowsSecurityContextOptions {\n");
        sb.append("    gmsaCredentialSpec: ").append(this.toIndentedString(this.gmsaCredentialSpec)).append("\n");
        sb.append("    gmsaCredentialSpecName: ").append(this.toIndentedString(this.gmsaCredentialSpecName)).append("\n");
        sb.append("    hostProcess: ").append(this.toIndentedString(this.hostProcess)).append("\n");
        sb.append("    runAsUserName: ").append(this.toIndentedString(this.runAsUserName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

