/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="SuccessPolicyRule describes rule for declaring a Job as succeeded. Each rule must have at least one of the \"succeededIndexes\" or \"succeededCount\" specified.")
public class V1SuccessPolicyRule {
    public static final String SERIALIZED_NAME_SUCCEEDED_COUNT = "succeededCount";
    @SerializedName(value="succeededCount")
    private Integer succeededCount;
    public static final String SERIALIZED_NAME_SUCCEEDED_INDEXES = "succeededIndexes";
    @SerializedName(value="succeededIndexes")
    private String succeededIndexes;

    public V1SuccessPolicyRule succeededCount(Integer succeededCount) {
        this.succeededCount = succeededCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="succeededCount specifies the minimal required size of the actual set of the succeeded indexes for the Job. When succeededCount is used along with succeededIndexes, the check is constrained only to the set of indexes specified by succeededIndexes. For example, given that succeededIndexes is \"1-4\", succeededCount is \"3\", and completed indexes are \"1\", \"3\", and \"5\", the Job isn't declared as succeeded because only \"1\" and \"3\" indexes are considered in that rules. When this field is null, this doesn't default to any value and is never evaluated at any time. When specified it needs to be a positive integer.")
    public Integer getSucceededCount() {
        return this.succeededCount;
    }

    public void setSucceededCount(Integer succeededCount) {
        this.succeededCount = succeededCount;
    }

    public V1SuccessPolicyRule succeededIndexes(String succeededIndexes) {
        this.succeededIndexes = succeededIndexes;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="succeededIndexes specifies the set of indexes which need to be contained in the actual set of the succeeded indexes for the Job. The list of indexes must be within 0 to \".spec.completions-1\" and must not contain duplicates. At least one element is required. The indexes are represented as intervals separated by commas. The intervals can be a decimal integer or a pair of decimal integers separated by a hyphen. The number are listed in represented by the first and last element of the series, separated by a hyphen. For example, if the completed indexes are 1, 3, 4, 5 and 7, they are represented as \"1,3-5,7\". When this field is null, this field doesn't default to any value and is never evaluated at any time.")
    public String getSucceededIndexes() {
        return this.succeededIndexes;
    }

    public void setSucceededIndexes(String succeededIndexes) {
        this.succeededIndexes = succeededIndexes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1SuccessPolicyRule v1SuccessPolicyRule = (V1SuccessPolicyRule)o;
        return Objects.equals(this.succeededCount, v1SuccessPolicyRule.succeededCount) && Objects.equals(this.succeededIndexes, v1SuccessPolicyRule.succeededIndexes);
    }

    public int hashCode() {
        return Objects.hash(this.succeededCount, this.succeededIndexes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1SuccessPolicyRule {\n");
        sb.append("    succeededCount: ").append(this.toIndentedString(this.succeededCount)).append("\n");
        sb.append("    succeededIndexes: ").append(this.toIndentedString(this.succeededIndexes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

