/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="ModifyVolumeStatus represents the status object of ControllerModifyVolume operation")
public class V1ModifyVolumeStatus {
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private String status;
    public static final String SERIALIZED_NAME_TARGET_VOLUME_ATTRIBUTES_CLASS_NAME = "targetVolumeAttributesClassName";
    @SerializedName(value="targetVolumeAttributesClassName")
    private String targetVolumeAttributesClassName;

    public V1ModifyVolumeStatus status(String status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(required=true, value="status is the status of the ControllerModifyVolume operation. It can be in any of following states:  - Pending    Pending indicates that the PersistentVolumeClaim cannot be modified due to unmet requirements, such as    the specified VolumeAttributesClass not existing.  - InProgress    InProgress indicates that the volume is being modified.  - Infeasible   Infeasible indicates that the request has been rejected as invalid by the CSI driver. To    resolve the error, a valid VolumeAttributesClass needs to be specified. Note: New statuses can be added in the future. Consumers should check for unknown statuses and fail appropriately.")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public V1ModifyVolumeStatus targetVolumeAttributesClassName(String targetVolumeAttributesClassName) {
        this.targetVolumeAttributesClassName = targetVolumeAttributesClassName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="targetVolumeAttributesClassName is the name of the VolumeAttributesClass the PVC currently being reconciled")
    public String getTargetVolumeAttributesClassName() {
        return this.targetVolumeAttributesClassName;
    }

    public void setTargetVolumeAttributesClassName(String targetVolumeAttributesClassName) {
        this.targetVolumeAttributesClassName = targetVolumeAttributesClassName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ModifyVolumeStatus v1ModifyVolumeStatus = (V1ModifyVolumeStatus)o;
        return Objects.equals(this.status, v1ModifyVolumeStatus.status) && Objects.equals(this.targetVolumeAttributesClassName, v1ModifyVolumeStatus.targetVolumeAttributesClassName);
    }

    public int hashCode() {
        return Objects.hash(this.status, this.targetVolumeAttributesClassName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1ModifyVolumeStatus {\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    targetVolumeAttributesClassName: ").append(this.toIndentedString(this.targetVolumeAttributesClassName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

