/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1alpha2DriverRequests;
import io.kubernetes.client.openapi.models.V1alpha2ResourceClaimParametersReference;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class V1alpha2ResourceClaimParameters
implements KubernetesObject {
    public static final String SERIALIZED_NAME_API_VERSION = "apiVersion";
    @SerializedName(value="apiVersion")
    private String apiVersion;
    public static final String SERIALIZED_NAME_DRIVER_REQUESTS = "driverRequests";
    @SerializedName(value="driverRequests")
    private List<V1alpha2DriverRequests> driverRequests;
    public static final String SERIALIZED_NAME_GENERATED_FROM = "generatedFrom";
    @SerializedName(value="generatedFrom")
    private V1alpha2ResourceClaimParametersReference generatedFrom;
    public static final String SERIALIZED_NAME_KIND = "kind";
    @SerializedName(value="kind")
    private String kind;
    public static final String SERIALIZED_NAME_METADATA = "metadata";
    @SerializedName(value="metadata")
    private V1ObjectMeta metadata;
    public static final String SERIALIZED_NAME_SHAREABLE = "shareable";
    @SerializedName(value="shareable")
    private Boolean shareable;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1alpha2ResourceClaimParameters apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @Override
    @Nullable
    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public V1alpha2ResourceClaimParameters driverRequests(List<V1alpha2DriverRequests> driverRequests) {
        this.driverRequests = driverRequests;
        return this;
    }

    public V1alpha2ResourceClaimParameters addDriverRequestsItem(V1alpha2DriverRequests driverRequestsItem) {
        if (this.driverRequests == null) {
            this.driverRequests = new ArrayList<V1alpha2DriverRequests>();
        }
        this.driverRequests.add(driverRequestsItem);
        return this;
    }

    @Nullable
    public List<V1alpha2DriverRequests> getDriverRequests() {
        return this.driverRequests;
    }

    public void setDriverRequests(List<V1alpha2DriverRequests> driverRequests) {
        this.driverRequests = driverRequests;
    }

    public V1alpha2ResourceClaimParameters generatedFrom(V1alpha2ResourceClaimParametersReference generatedFrom) {
        this.generatedFrom = generatedFrom;
        return this;
    }

    @Nullable
    public V1alpha2ResourceClaimParametersReference getGeneratedFrom() {
        return this.generatedFrom;
    }

    public void setGeneratedFrom(V1alpha2ResourceClaimParametersReference generatedFrom) {
        this.generatedFrom = generatedFrom;
    }

    public V1alpha2ResourceClaimParameters kind(String kind) {
        this.kind = kind;
        return this;
    }

    @Override
    @Nullable
    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public V1alpha2ResourceClaimParameters metadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
        return this;
    }

    @Override
    @Nullable
    public V1ObjectMeta getMetadata() {
        return this.metadata;
    }

    public void setMetadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
    }

    public V1alpha2ResourceClaimParameters shareable(Boolean shareable) {
        this.shareable = shareable;
        return this;
    }

    @Nullable
    public Boolean getShareable() {
        return this.shareable;
    }

    public void setShareable(Boolean shareable) {
        this.shareable = shareable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1alpha2ResourceClaimParameters v1alpha2ResourceClaimParameters = (V1alpha2ResourceClaimParameters)o;
        return Objects.equals(this.apiVersion, v1alpha2ResourceClaimParameters.apiVersion) && Objects.equals(this.driverRequests, v1alpha2ResourceClaimParameters.driverRequests) && Objects.equals(this.generatedFrom, v1alpha2ResourceClaimParameters.generatedFrom) && Objects.equals(this.kind, v1alpha2ResourceClaimParameters.kind) && Objects.equals(this.metadata, v1alpha2ResourceClaimParameters.metadata) && Objects.equals(this.shareable, v1alpha2ResourceClaimParameters.shareable);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.driverRequests, this.generatedFrom, this.kind, this.metadata, this.shareable);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1alpha2ResourceClaimParameters {\n");
        sb.append("    apiVersion: ").append(this.toIndentedString(this.apiVersion)).append("\n");
        sb.append("    driverRequests: ").append(this.toIndentedString(this.driverRequests)).append("\n");
        sb.append("    generatedFrom: ").append(this.toIndentedString(this.generatedFrom)).append("\n");
        sb.append("    kind: ").append(this.toIndentedString(this.kind)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    shareable: ").append(this.toIndentedString(this.shareable)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArraydriverRequests;
        if (jsonObj == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1alpha2ResourceClaimParameters is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1alpha2ResourceClaimParameters` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_API_VERSION) != null && !jsonObj.get(SERIALIZED_NAME_API_VERSION).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_API_VERSION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `apiVersion` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_API_VERSION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DRIVER_REQUESTS) != null && !jsonObj.get(SERIALIZED_NAME_DRIVER_REQUESTS).isJsonNull() && (jsonArraydriverRequests = jsonObj.getAsJsonArray(SERIALIZED_NAME_DRIVER_REQUESTS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_DRIVER_REQUESTS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `driverRequests` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DRIVER_REQUESTS).toString()));
            }
            for (int i = 0; i < jsonArraydriverRequests.size(); ++i) {
                V1alpha2DriverRequests.validateJsonObject(jsonArraydriverRequests.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_GENERATED_FROM) != null && !jsonObj.get(SERIALIZED_NAME_GENERATED_FROM).isJsonNull()) {
            V1alpha2ResourceClaimParametersReference.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_GENERATED_FROM));
        }
        if (jsonObj.get(SERIALIZED_NAME_KIND) != null && !jsonObj.get(SERIALIZED_NAME_KIND).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_KIND).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `kind` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_KIND).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_METADATA) != null && !jsonObj.get(SERIALIZED_NAME_METADATA).isJsonNull()) {
            V1ObjectMeta.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_METADATA));
        }
    }

    public static V1alpha2ResourceClaimParameters fromJson(String jsonString) throws IOException {
        return (V1alpha2ResourceClaimParameters)JSON.getGson().fromJson(jsonString, V1alpha2ResourceClaimParameters.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_API_VERSION);
        openapiFields.add(SERIALIZED_NAME_DRIVER_REQUESTS);
        openapiFields.add(SERIALIZED_NAME_GENERATED_FROM);
        openapiFields.add(SERIALIZED_NAME_KIND);
        openapiFields.add(SERIALIZED_NAME_METADATA);
        openapiFields.add(SERIALIZED_NAME_SHAREABLE);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1alpha2ResourceClaimParameters.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1alpha2ResourceClaimParameters.class));
            return new TypeAdapter<V1alpha2ResourceClaimParameters>(){

                public void write(JsonWriter out, V1alpha2ResourceClaimParameters value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1alpha2ResourceClaimParameters read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    V1alpha2ResourceClaimParameters.validateJsonObject(jsonObj);
                    return (V1alpha2ResourceClaimParameters)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

