/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.custom.Quantity;
import io.kubernetes.client.openapi.models.V1ContainerState;
import io.kubernetes.client.openapi.models.V1ResourceRequirements;
import io.kubernetes.client.openapi.models.V1VolumeMountStatus;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="ContainerStatus contains details for the current status of this container.")
public class V1ContainerStatus {
    public static final String SERIALIZED_NAME_ALLOCATED_RESOURCES = "allocatedResources";
    @SerializedName(value="allocatedResources")
    private Map<String, Quantity> allocatedResources = null;
    public static final String SERIALIZED_NAME_CONTAINER_I_D = "containerID";
    @SerializedName(value="containerID")
    private String containerID;
    public static final String SERIALIZED_NAME_IMAGE = "image";
    @SerializedName(value="image")
    private String image;
    public static final String SERIALIZED_NAME_IMAGE_I_D = "imageID";
    @SerializedName(value="imageID")
    private String imageID;
    public static final String SERIALIZED_NAME_LAST_STATE = "lastState";
    @SerializedName(value="lastState")
    private V1ContainerState lastState;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_READY = "ready";
    @SerializedName(value="ready")
    private Boolean ready;
    public static final String SERIALIZED_NAME_RESOURCES = "resources";
    @SerializedName(value="resources")
    private V1ResourceRequirements resources;
    public static final String SERIALIZED_NAME_RESTART_COUNT = "restartCount";
    @SerializedName(value="restartCount")
    private Integer restartCount;
    public static final String SERIALIZED_NAME_STARTED = "started";
    @SerializedName(value="started")
    private Boolean started;
    public static final String SERIALIZED_NAME_STATE = "state";
    @SerializedName(value="state")
    private V1ContainerState state;
    public static final String SERIALIZED_NAME_VOLUME_MOUNTS = "volumeMounts";
    @SerializedName(value="volumeMounts")
    private List<V1VolumeMountStatus> volumeMounts = null;

    public V1ContainerStatus allocatedResources(Map<String, Quantity> allocatedResources) {
        this.allocatedResources = allocatedResources;
        return this;
    }

    public V1ContainerStatus putAllocatedResourcesItem(String key, Quantity allocatedResourcesItem) {
        if (this.allocatedResources == null) {
            this.allocatedResources = new HashMap<String, Quantity>();
        }
        this.allocatedResources.put(key, allocatedResourcesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="AllocatedResources represents the compute resources allocated for this container by the node. Kubelet sets this value to Container.Resources.Requests upon successful pod admission and after successfully admitting desired pod resize.")
    public Map<String, Quantity> getAllocatedResources() {
        return this.allocatedResources;
    }

    public void setAllocatedResources(Map<String, Quantity> allocatedResources) {
        this.allocatedResources = allocatedResources;
    }

    public V1ContainerStatus containerID(String containerID) {
        this.containerID = containerID;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ContainerID is the ID of the container in the format '<type>://<container_id>'. Where type is a container runtime identifier, returned from Version call of CRI API (for example \"containerd\").")
    public String getContainerID() {
        return this.containerID;
    }

    public void setContainerID(String containerID) {
        this.containerID = containerID;
    }

    public V1ContainerStatus image(String image) {
        this.image = image;
        return this;
    }

    @ApiModelProperty(required=true, value="Image is the name of container image that the container is running. The container image may not match the image used in the PodSpec, as it may have been resolved by the runtime. More info: https://kubernetes.io/docs/concepts/containers/images.")
    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public V1ContainerStatus imageID(String imageID) {
        this.imageID = imageID;
        return this;
    }

    @ApiModelProperty(required=true, value="ImageID is the image ID of the container's image. The image ID may not match the image ID of the image used in the PodSpec, as it may have been resolved by the runtime.")
    public String getImageID() {
        return this.imageID;
    }

    public void setImageID(String imageID) {
        this.imageID = imageID;
    }

    public V1ContainerStatus lastState(V1ContainerState lastState) {
        this.lastState = lastState;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1ContainerState getLastState() {
        return this.lastState;
    }

    public void setLastState(V1ContainerState lastState) {
        this.lastState = lastState;
    }

    public V1ContainerStatus name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="Name is a DNS_LABEL representing the unique name of the container. Each container in a pod must have a unique name across all container types. Cannot be updated.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public V1ContainerStatus ready(Boolean ready) {
        this.ready = ready;
        return this;
    }

    @ApiModelProperty(required=true, value="Ready specifies whether the container is currently passing its readiness check. The value will change as readiness probes keep executing. If no readiness probes are specified, this field defaults to true once the container is fully started (see Started field).  The value is typically used to determine whether a container is ready to accept traffic.")
    public Boolean getReady() {
        return this.ready;
    }

    public void setReady(Boolean ready) {
        this.ready = ready;
    }

    public V1ContainerStatus resources(V1ResourceRequirements resources) {
        this.resources = resources;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1ResourceRequirements getResources() {
        return this.resources;
    }

    public void setResources(V1ResourceRequirements resources) {
        this.resources = resources;
    }

    public V1ContainerStatus restartCount(Integer restartCount) {
        this.restartCount = restartCount;
        return this;
    }

    @ApiModelProperty(required=true, value="RestartCount holds the number of times the container has been restarted. Kubelet makes an effort to always increment the value, but there are cases when the state may be lost due to node restarts and then the value may be reset to 0. The value is never negative.")
    public Integer getRestartCount() {
        return this.restartCount;
    }

    public void setRestartCount(Integer restartCount) {
        this.restartCount = restartCount;
    }

    public V1ContainerStatus started(Boolean started) {
        this.started = started;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Started indicates whether the container has finished its postStart lifecycle hook and passed its startup probe. Initialized as false, becomes true after startupProbe is considered successful. Resets to false when the container is restarted, or if kubelet loses state temporarily. In both cases, startup probes will run again. Is always true when no startupProbe is defined and container is running and has passed the postStart lifecycle hook. The null value must be treated the same as false.")
    public Boolean getStarted() {
        return this.started;
    }

    public void setStarted(Boolean started) {
        this.started = started;
    }

    public V1ContainerStatus state(V1ContainerState state) {
        this.state = state;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1ContainerState getState() {
        return this.state;
    }

    public void setState(V1ContainerState state) {
        this.state = state;
    }

    public V1ContainerStatus volumeMounts(List<V1VolumeMountStatus> volumeMounts) {
        this.volumeMounts = volumeMounts;
        return this;
    }

    public V1ContainerStatus addVolumeMountsItem(V1VolumeMountStatus volumeMountsItem) {
        if (this.volumeMounts == null) {
            this.volumeMounts = new ArrayList<V1VolumeMountStatus>();
        }
        this.volumeMounts.add(volumeMountsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Status of volume mounts.")
    public List<V1VolumeMountStatus> getVolumeMounts() {
        return this.volumeMounts;
    }

    public void setVolumeMounts(List<V1VolumeMountStatus> volumeMounts) {
        this.volumeMounts = volumeMounts;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ContainerStatus v1ContainerStatus = (V1ContainerStatus)o;
        return Objects.equals(this.allocatedResources, v1ContainerStatus.allocatedResources) && Objects.equals(this.containerID, v1ContainerStatus.containerID) && Objects.equals(this.image, v1ContainerStatus.image) && Objects.equals(this.imageID, v1ContainerStatus.imageID) && Objects.equals(this.lastState, v1ContainerStatus.lastState) && Objects.equals(this.name, v1ContainerStatus.name) && Objects.equals(this.ready, v1ContainerStatus.ready) && Objects.equals(this.resources, v1ContainerStatus.resources) && Objects.equals(this.restartCount, v1ContainerStatus.restartCount) && Objects.equals(this.started, v1ContainerStatus.started) && Objects.equals(this.state, v1ContainerStatus.state) && Objects.equals(this.volumeMounts, v1ContainerStatus.volumeMounts);
    }

    public int hashCode() {
        return Objects.hash(this.allocatedResources, this.containerID, this.image, this.imageID, this.lastState, this.name, this.ready, this.resources, this.restartCount, this.started, this.state, this.volumeMounts);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1ContainerStatus {\n");
        sb.append("    allocatedResources: ").append(this.toIndentedString(this.allocatedResources)).append("\n");
        sb.append("    containerID: ").append(this.toIndentedString(this.containerID)).append("\n");
        sb.append("    image: ").append(this.toIndentedString(this.image)).append("\n");
        sb.append("    imageID: ").append(this.toIndentedString(this.imageID)).append("\n");
        sb.append("    lastState: ").append(this.toIndentedString(this.lastState)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    ready: ").append(this.toIndentedString(this.ready)).append("\n");
        sb.append("    resources: ").append(this.toIndentedString(this.resources)).append("\n");
        sb.append("    restartCount: ").append(this.toIndentedString(this.restartCount)).append("\n");
        sb.append("    started: ").append(this.toIndentedString(this.started)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("    volumeMounts: ").append(this.toIndentedString(this.volumeMounts)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

