/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V1IngressClassParametersReference;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="IngressClassSpec provides information about the class of an Ingress.")
public class V1IngressClassSpec {
    public static final String SERIALIZED_NAME_CONTROLLER = "controller";
    @SerializedName(value="controller")
    private String controller;
    public static final String SERIALIZED_NAME_PARAMETERS = "parameters";
    @SerializedName(value="parameters")
    private V1IngressClassParametersReference parameters;

    public V1IngressClassSpec controller(String controller) {
        this.controller = controller;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="controller refers to the name of the controller that should handle this class. This allows for different \"flavors\" that are controlled by the same controller. For example, you may have different parameters for the same implementing controller. This should be specified as a domain-prefixed path no more than 250 characters in length, e.g. \"acme.io/ingress-controller\". This field is immutable.")
    public String getController() {
        return this.controller;
    }

    public void setController(String controller) {
        this.controller = controller;
    }

    public V1IngressClassSpec parameters(V1IngressClassParametersReference parameters) {
        this.parameters = parameters;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1IngressClassParametersReference getParameters() {
        return this.parameters;
    }

    public void setParameters(V1IngressClassParametersReference parameters) {
        this.parameters = parameters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1IngressClassSpec v1IngressClassSpec = (V1IngressClassSpec)o;
        return Objects.equals(this.controller, v1IngressClassSpec.controller) && Objects.equals(this.parameters, v1IngressClassSpec.parameters);
    }

    public int hashCode() {
        return Objects.hash(this.controller, this.parameters);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1IngressClassSpec {\n");
        sb.append("    controller: ").append(this.toIndentedString(this.controller)).append("\n");
        sb.append("    parameters: ").append(this.toIndentedString(this.parameters)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

