/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V1VolumeError;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="VolumeAttachmentStatus is the status of a VolumeAttachment request.")
public class V1VolumeAttachmentStatus {
    public static final String SERIALIZED_NAME_ATTACH_ERROR = "attachError";
    @SerializedName(value="attachError")
    private V1VolumeError attachError;
    public static final String SERIALIZED_NAME_ATTACHED = "attached";
    @SerializedName(value="attached")
    private Boolean attached;
    public static final String SERIALIZED_NAME_ATTACHMENT_METADATA = "attachmentMetadata";
    @SerializedName(value="attachmentMetadata")
    private Map<String, String> attachmentMetadata = null;
    public static final String SERIALIZED_NAME_DETACH_ERROR = "detachError";
    @SerializedName(value="detachError")
    private V1VolumeError detachError;

    public V1VolumeAttachmentStatus attachError(V1VolumeError attachError) {
        this.attachError = attachError;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1VolumeError getAttachError() {
        return this.attachError;
    }

    public void setAttachError(V1VolumeError attachError) {
        this.attachError = attachError;
    }

    public V1VolumeAttachmentStatus attached(Boolean attached) {
        this.attached = attached;
        return this;
    }

    @ApiModelProperty(required=true, value="attached indicates the volume is successfully attached. This field must only be set by the entity completing the attach operation, i.e. the external-attacher.")
    public Boolean getAttached() {
        return this.attached;
    }

    public void setAttached(Boolean attached) {
        this.attached = attached;
    }

    public V1VolumeAttachmentStatus attachmentMetadata(Map<String, String> attachmentMetadata) {
        this.attachmentMetadata = attachmentMetadata;
        return this;
    }

    public V1VolumeAttachmentStatus putAttachmentMetadataItem(String key, String attachmentMetadataItem) {
        if (this.attachmentMetadata == null) {
            this.attachmentMetadata = new HashMap<String, String>();
        }
        this.attachmentMetadata.put(key, attachmentMetadataItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="attachmentMetadata is populated with any information returned by the attach operation, upon successful attach, that must be passed into subsequent WaitForAttach or Mount calls. This field must only be set by the entity completing the attach operation, i.e. the external-attacher.")
    public Map<String, String> getAttachmentMetadata() {
        return this.attachmentMetadata;
    }

    public void setAttachmentMetadata(Map<String, String> attachmentMetadata) {
        this.attachmentMetadata = attachmentMetadata;
    }

    public V1VolumeAttachmentStatus detachError(V1VolumeError detachError) {
        this.detachError = detachError;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1VolumeError getDetachError() {
        return this.detachError;
    }

    public void setDetachError(V1VolumeError detachError) {
        this.detachError = detachError;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1VolumeAttachmentStatus v1VolumeAttachmentStatus = (V1VolumeAttachmentStatus)o;
        return Objects.equals(this.attachError, v1VolumeAttachmentStatus.attachError) && Objects.equals(this.attached, v1VolumeAttachmentStatus.attached) && Objects.equals(this.attachmentMetadata, v1VolumeAttachmentStatus.attachmentMetadata) && Objects.equals(this.detachError, v1VolumeAttachmentStatus.detachError);
    }

    public int hashCode() {
        return Objects.hash(this.attachError, this.attached, this.attachmentMetadata, this.detachError);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1VolumeAttachmentStatus {\n");
        sb.append("    attachError: ").append(this.toIndentedString(this.attachError)).append("\n");
        sb.append("    attached: ").append(this.toIndentedString(this.attached)).append("\n");
        sb.append("    attachmentMetadata: ").append(this.toIndentedString(this.attachmentMetadata)).append("\n");
        sb.append("    detachError: ").append(this.toIndentedString(this.detachError)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

