/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V1JobCondition;
import io.kubernetes.client.openapi.models.V1UncountedTerminatedPods;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="JobStatus represents the current state of a Job.")
public class V1JobStatus {
    public static final String SERIALIZED_NAME_ACTIVE = "active";
    @SerializedName(value="active")
    private Integer active;
    public static final String SERIALIZED_NAME_COMPLETED_INDEXES = "completedIndexes";
    @SerializedName(value="completedIndexes")
    private String completedIndexes;
    public static final String SERIALIZED_NAME_COMPLETION_TIME = "completionTime";
    @SerializedName(value="completionTime")
    private OffsetDateTime completionTime;
    public static final String SERIALIZED_NAME_CONDITIONS = "conditions";
    @SerializedName(value="conditions")
    private List<V1JobCondition> conditions = null;
    public static final String SERIALIZED_NAME_FAILED = "failed";
    @SerializedName(value="failed")
    private Integer failed;
    public static final String SERIALIZED_NAME_READY = "ready";
    @SerializedName(value="ready")
    private Integer ready;
    public static final String SERIALIZED_NAME_START_TIME = "startTime";
    @SerializedName(value="startTime")
    private OffsetDateTime startTime;
    public static final String SERIALIZED_NAME_SUCCEEDED = "succeeded";
    @SerializedName(value="succeeded")
    private Integer succeeded;
    public static final String SERIALIZED_NAME_UNCOUNTED_TERMINATED_PODS = "uncountedTerminatedPods";
    @SerializedName(value="uncountedTerminatedPods")
    private V1UncountedTerminatedPods uncountedTerminatedPods;

    public V1JobStatus active(Integer active) {
        this.active = active;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of pending and running pods.")
    public Integer getActive() {
        return this.active;
    }

    public void setActive(Integer active) {
        this.active = active;
    }

    public V1JobStatus completedIndexes(String completedIndexes) {
        this.completedIndexes = completedIndexes;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="CompletedIndexes holds the completed indexes when .spec.completionMode = \"Indexed\" in a text format. The indexes are represented as decimal integers separated by commas. The numbers are listed in increasing order. Three or more consecutive numbers are compressed and represented by the first and last element of the series, separated by a hyphen. For example, if the completed indexes are 1, 3, 4, 5 and 7, they are represented as \"1,3-5,7\".")
    public String getCompletedIndexes() {
        return this.completedIndexes;
    }

    public void setCompletedIndexes(String completedIndexes) {
        this.completedIndexes = completedIndexes;
    }

    public V1JobStatus completionTime(OffsetDateTime completionTime) {
        this.completionTime = completionTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Represents time when the job was completed. It is not guaranteed to be set in happens-before order across separate operations. It is represented in RFC3339 form and is in UTC. The completion time is only set when the job finishes successfully.")
    public OffsetDateTime getCompletionTime() {
        return this.completionTime;
    }

    public void setCompletionTime(OffsetDateTime completionTime) {
        this.completionTime = completionTime;
    }

    public V1JobStatus conditions(List<V1JobCondition> conditions) {
        this.conditions = conditions;
        return this;
    }

    public V1JobStatus addConditionsItem(V1JobCondition conditionsItem) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<V1JobCondition>();
        }
        this.conditions.add(conditionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The latest available observations of an object's current state. When a Job fails, one of the conditions will have type \"Failed\" and status true. When a Job is suspended, one of the conditions will have type \"Suspended\" and status true; when the Job is resumed, the status of this condition will become false. When a Job is completed, one of the conditions will have type \"Complete\" and status true. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/")
    public List<V1JobCondition> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<V1JobCondition> conditions) {
        this.conditions = conditions;
    }

    public V1JobStatus failed(Integer failed) {
        this.failed = failed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of pods which reached phase Failed.")
    public Integer getFailed() {
        return this.failed;
    }

    public void setFailed(Integer failed) {
        this.failed = failed;
    }

    public V1JobStatus ready(Integer ready) {
        this.ready = ready;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of pods which have a Ready condition.  This field is beta-level. The job controller populates the field when the feature gate JobReadyPods is enabled (enabled by default).")
    public Integer getReady() {
        return this.ready;
    }

    public void setReady(Integer ready) {
        this.ready = ready;
    }

    public V1JobStatus startTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Represents time when the job controller started processing a job. When a Job is created in the suspended state, this field is not set until the first time it is resumed. This field is reset every time a Job is resumed from suspension. It is represented in RFC3339 form and is in UTC.")
    public OffsetDateTime getStartTime() {
        return this.startTime;
    }

    public void setStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
    }

    public V1JobStatus succeeded(Integer succeeded) {
        this.succeeded = succeeded;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of pods which reached phase Succeeded.")
    public Integer getSucceeded() {
        return this.succeeded;
    }

    public void setSucceeded(Integer succeeded) {
        this.succeeded = succeeded;
    }

    public V1JobStatus uncountedTerminatedPods(V1UncountedTerminatedPods uncountedTerminatedPods) {
        this.uncountedTerminatedPods = uncountedTerminatedPods;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1UncountedTerminatedPods getUncountedTerminatedPods() {
        return this.uncountedTerminatedPods;
    }

    public void setUncountedTerminatedPods(V1UncountedTerminatedPods uncountedTerminatedPods) {
        this.uncountedTerminatedPods = uncountedTerminatedPods;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1JobStatus v1JobStatus = (V1JobStatus)o;
        return Objects.equals(this.active, v1JobStatus.active) && Objects.equals(this.completedIndexes, v1JobStatus.completedIndexes) && Objects.equals(this.completionTime, v1JobStatus.completionTime) && Objects.equals(this.conditions, v1JobStatus.conditions) && Objects.equals(this.failed, v1JobStatus.failed) && Objects.equals(this.ready, v1JobStatus.ready) && Objects.equals(this.startTime, v1JobStatus.startTime) && Objects.equals(this.succeeded, v1JobStatus.succeeded) && Objects.equals(this.uncountedTerminatedPods, v1JobStatus.uncountedTerminatedPods);
    }

    public int hashCode() {
        return Objects.hash(this.active, this.completedIndexes, this.completionTime, this.conditions, this.failed, this.ready, this.startTime, this.succeeded, this.uncountedTerminatedPods);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1JobStatus {\n");
        sb.append("    active: ").append(this.toIndentedString(this.active)).append("\n");
        sb.append("    completedIndexes: ").append(this.toIndentedString(this.completedIndexes)).append("\n");
        sb.append("    completionTime: ").append(this.toIndentedString(this.completionTime)).append("\n");
        sb.append("    conditions: ").append(this.toIndentedString(this.conditions)).append("\n");
        sb.append("    failed: ").append(this.toIndentedString(this.failed)).append("\n");
        sb.append("    ready: ").append(this.toIndentedString(this.ready)).append("\n");
        sb.append("    startTime: ").append(this.toIndentedString(this.startTime)).append("\n");
        sb.append("    succeeded: ").append(this.toIndentedString(this.succeeded)).append("\n");
        sb.append("    uncountedTerminatedPods: ").append(this.toIndentedString(this.uncountedTerminatedPods)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

