/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="NodeSystemInfo is a set of ids/uuids to uniquely identify the node.")
public class V1NodeSystemInfo {
    public static final String SERIALIZED_NAME_ARCHITECTURE = "architecture";
    @SerializedName(value="architecture")
    private String architecture;
    public static final String SERIALIZED_NAME_BOOT_I_D = "bootID";
    @SerializedName(value="bootID")
    private String bootID;
    public static final String SERIALIZED_NAME_CONTAINER_RUNTIME_VERSION = "containerRuntimeVersion";
    @SerializedName(value="containerRuntimeVersion")
    private String containerRuntimeVersion;
    public static final String SERIALIZED_NAME_KERNEL_VERSION = "kernelVersion";
    @SerializedName(value="kernelVersion")
    private String kernelVersion;
    public static final String SERIALIZED_NAME_KUBE_PROXY_VERSION = "kubeProxyVersion";
    @SerializedName(value="kubeProxyVersion")
    private String kubeProxyVersion;
    public static final String SERIALIZED_NAME_KUBELET_VERSION = "kubeletVersion";
    @SerializedName(value="kubeletVersion")
    private String kubeletVersion;
    public static final String SERIALIZED_NAME_MACHINE_I_D = "machineID";
    @SerializedName(value="machineID")
    private String machineID;
    public static final String SERIALIZED_NAME_OPERATING_SYSTEM = "operatingSystem";
    @SerializedName(value="operatingSystem")
    private String operatingSystem;
    public static final String SERIALIZED_NAME_OS_IMAGE = "osImage";
    @SerializedName(value="osImage")
    private String osImage;
    public static final String SERIALIZED_NAME_SYSTEM_U_U_I_D = "systemUUID";
    @SerializedName(value="systemUUID")
    private String systemUUID;

    public V1NodeSystemInfo architecture(String architecture) {
        this.architecture = architecture;
        return this;
    }

    @ApiModelProperty(required=true, value="The Architecture reported by the node")
    public String getArchitecture() {
        return this.architecture;
    }

    public void setArchitecture(String architecture) {
        this.architecture = architecture;
    }

    public V1NodeSystemInfo bootID(String bootID) {
        this.bootID = bootID;
        return this;
    }

    @ApiModelProperty(required=true, value="Boot ID reported by the node.")
    public String getBootID() {
        return this.bootID;
    }

    public void setBootID(String bootID) {
        this.bootID = bootID;
    }

    public V1NodeSystemInfo containerRuntimeVersion(String containerRuntimeVersion) {
        this.containerRuntimeVersion = containerRuntimeVersion;
        return this;
    }

    @ApiModelProperty(required=true, value="ContainerRuntime Version reported by the node through runtime remote API (e.g. containerd://1.4.2).")
    public String getContainerRuntimeVersion() {
        return this.containerRuntimeVersion;
    }

    public void setContainerRuntimeVersion(String containerRuntimeVersion) {
        this.containerRuntimeVersion = containerRuntimeVersion;
    }

    public V1NodeSystemInfo kernelVersion(String kernelVersion) {
        this.kernelVersion = kernelVersion;
        return this;
    }

    @ApiModelProperty(required=true, value="Kernel Version reported by the node from 'uname -r' (e.g. 3.16.0-0.bpo.4-amd64).")
    public String getKernelVersion() {
        return this.kernelVersion;
    }

    public void setKernelVersion(String kernelVersion) {
        this.kernelVersion = kernelVersion;
    }

    public V1NodeSystemInfo kubeProxyVersion(String kubeProxyVersion) {
        this.kubeProxyVersion = kubeProxyVersion;
        return this;
    }

    @ApiModelProperty(required=true, value="KubeProxy Version reported by the node.")
    public String getKubeProxyVersion() {
        return this.kubeProxyVersion;
    }

    public void setKubeProxyVersion(String kubeProxyVersion) {
        this.kubeProxyVersion = kubeProxyVersion;
    }

    public V1NodeSystemInfo kubeletVersion(String kubeletVersion) {
        this.kubeletVersion = kubeletVersion;
        return this;
    }

    @ApiModelProperty(required=true, value="Kubelet Version reported by the node.")
    public String getKubeletVersion() {
        return this.kubeletVersion;
    }

    public void setKubeletVersion(String kubeletVersion) {
        this.kubeletVersion = kubeletVersion;
    }

    public V1NodeSystemInfo machineID(String machineID) {
        this.machineID = machineID;
        return this;
    }

    @ApiModelProperty(required=true, value="MachineID reported by the node. For unique machine identification in the cluster this field is preferred. Learn more from man(5) machine-id: http://man7.org/linux/man-pages/man5/machine-id.5.html")
    public String getMachineID() {
        return this.machineID;
    }

    public void setMachineID(String machineID) {
        this.machineID = machineID;
    }

    public V1NodeSystemInfo operatingSystem(String operatingSystem) {
        this.operatingSystem = operatingSystem;
        return this;
    }

    @ApiModelProperty(required=true, value="The Operating System reported by the node")
    public String getOperatingSystem() {
        return this.operatingSystem;
    }

    public void setOperatingSystem(String operatingSystem) {
        this.operatingSystem = operatingSystem;
    }

    public V1NodeSystemInfo osImage(String osImage) {
        this.osImage = osImage;
        return this;
    }

    @ApiModelProperty(required=true, value="OS Image reported by the node from /etc/os-release (e.g. Debian GNU/Linux 7 (wheezy)).")
    public String getOsImage() {
        return this.osImage;
    }

    public void setOsImage(String osImage) {
        this.osImage = osImage;
    }

    public V1NodeSystemInfo systemUUID(String systemUUID) {
        this.systemUUID = systemUUID;
        return this;
    }

    @ApiModelProperty(required=true, value="SystemUUID reported by the node. For unique machine identification MachineID is preferred. This field is specific to Red Hat hosts https://access.redhat.com/documentation/en-us/red_hat_subscription_management/1/html/rhsm/uuid")
    public String getSystemUUID() {
        return this.systemUUID;
    }

    public void setSystemUUID(String systemUUID) {
        this.systemUUID = systemUUID;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1NodeSystemInfo v1NodeSystemInfo = (V1NodeSystemInfo)o;
        return Objects.equals(this.architecture, v1NodeSystemInfo.architecture) && Objects.equals(this.bootID, v1NodeSystemInfo.bootID) && Objects.equals(this.containerRuntimeVersion, v1NodeSystemInfo.containerRuntimeVersion) && Objects.equals(this.kernelVersion, v1NodeSystemInfo.kernelVersion) && Objects.equals(this.kubeProxyVersion, v1NodeSystemInfo.kubeProxyVersion) && Objects.equals(this.kubeletVersion, v1NodeSystemInfo.kubeletVersion) && Objects.equals(this.machineID, v1NodeSystemInfo.machineID) && Objects.equals(this.operatingSystem, v1NodeSystemInfo.operatingSystem) && Objects.equals(this.osImage, v1NodeSystemInfo.osImage) && Objects.equals(this.systemUUID, v1NodeSystemInfo.systemUUID);
    }

    public int hashCode() {
        return Objects.hash(this.architecture, this.bootID, this.containerRuntimeVersion, this.kernelVersion, this.kubeProxyVersion, this.kubeletVersion, this.machineID, this.operatingSystem, this.osImage, this.systemUUID);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1NodeSystemInfo {\n");
        sb.append("    architecture: ").append(this.toIndentedString(this.architecture)).append("\n");
        sb.append("    bootID: ").append(this.toIndentedString(this.bootID)).append("\n");
        sb.append("    containerRuntimeVersion: ").append(this.toIndentedString(this.containerRuntimeVersion)).append("\n");
        sb.append("    kernelVersion: ").append(this.toIndentedString(this.kernelVersion)).append("\n");
        sb.append("    kubeProxyVersion: ").append(this.toIndentedString(this.kubeProxyVersion)).append("\n");
        sb.append("    kubeletVersion: ").append(this.toIndentedString(this.kubeletVersion)).append("\n");
        sb.append("    machineID: ").append(this.toIndentedString(this.machineID)).append("\n");
        sb.append("    operatingSystem: ").append(this.toIndentedString(this.operatingSystem)).append("\n");
        sb.append("    osImage: ").append(this.toIndentedString(this.osImage)).append("\n");
        sb.append("    systemUUID: ").append(this.toIndentedString(this.systemUUID)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

