/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.models.V1LabelSelector;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="TopologySpreadConstraint specifies how to spread matching pods among the given topology.")
public class V1TopologySpreadConstraint {
    public static final String SERIALIZED_NAME_LABEL_SELECTOR = "labelSelector";
    @SerializedName(value="labelSelector")
    private V1LabelSelector labelSelector;
    public static final String SERIALIZED_NAME_MAX_SKEW = "maxSkew";
    @SerializedName(value="maxSkew")
    private Integer maxSkew;
    public static final String SERIALIZED_NAME_TOPOLOGY_KEY = "topologyKey";
    @SerializedName(value="topologyKey")
    private String topologyKey;
    public static final String SERIALIZED_NAME_WHEN_UNSATISFIABLE = "whenUnsatisfiable";
    @SerializedName(value="whenUnsatisfiable")
    private WhenUnsatisfiableEnum whenUnsatisfiable;

    public V1TopologySpreadConstraint labelSelector(V1LabelSelector labelSelector) {
        this.labelSelector = labelSelector;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1LabelSelector getLabelSelector() {
        return this.labelSelector;
    }

    public void setLabelSelector(V1LabelSelector labelSelector) {
        this.labelSelector = labelSelector;
    }

    public V1TopologySpreadConstraint maxSkew(Integer maxSkew) {
        this.maxSkew = maxSkew;
        return this;
    }

    @ApiModelProperty(required=true, value="MaxSkew describes the degree to which pods may be unevenly distributed. When `whenUnsatisfiable=DoNotSchedule`, it is the maximum permitted difference between the number of matching pods in the target topology and the global minimum. For example, in a 3-zone cluster, MaxSkew is set to 1, and pods with the same labelSelector spread as 1/1/0: | zone1 | zone2 | zone3 | |   P   |   P   |       | - if MaxSkew is 1, incoming pod can only be scheduled to zone3 to become 1/1/1; scheduling it onto zone1(zone2) would make the ActualSkew(2-0) on zone1(zone2) violate MaxSkew(1). - if MaxSkew is 2, incoming pod can be scheduled onto any zone. When `whenUnsatisfiable=ScheduleAnyway`, it is used to give higher precedence to topologies that satisfy it. It's a required field. Default value is 1 and 0 is not allowed.")
    public Integer getMaxSkew() {
        return this.maxSkew;
    }

    public void setMaxSkew(Integer maxSkew) {
        this.maxSkew = maxSkew;
    }

    public V1TopologySpreadConstraint topologyKey(String topologyKey) {
        this.topologyKey = topologyKey;
        return this;
    }

    @ApiModelProperty(required=true, value="TopologyKey is the key of node labels. Nodes that have a label with this key and identical values are considered to be in the same topology. We consider each <key, value> as a \"bucket\", and try to put balanced number of pods into each bucket. It's a required field.")
    public String getTopologyKey() {
        return this.topologyKey;
    }

    public void setTopologyKey(String topologyKey) {
        this.topologyKey = topologyKey;
    }

    public V1TopologySpreadConstraint whenUnsatisfiable(WhenUnsatisfiableEnum whenUnsatisfiable) {
        this.whenUnsatisfiable = whenUnsatisfiable;
        return this;
    }

    @ApiModelProperty(required=true, value="WhenUnsatisfiable indicates how to deal with a pod if it doesn't satisfy the spread constraint. - DoNotSchedule (default) tells the scheduler not to schedule it. - ScheduleAnyway tells the scheduler to schedule the pod in any location,   but giving higher precedence to topologies that would help reduce the   skew. A constraint is considered \"Unsatisfiable\" for an incoming pod if and only if every possible node assignment for that pod would violate \"MaxSkew\" on some topology. For example, in a 3-zone cluster, MaxSkew is set to 1, and pods with the same labelSelector spread as 3/1/1: | zone1 | zone2 | zone3 | | P P P |   P   |   P   | If WhenUnsatisfiable is set to DoNotSchedule, incoming pod can only be scheduled to zone2(zone3) to become 3/2/1(3/1/2) as ActualSkew(2-1) on zone2(zone3) satisfies MaxSkew(1). In other words, the cluster can still be imbalanced, but scheduler won't make it *more* imbalanced. It's a required field.  Possible enum values:  - `\"DoNotSchedule\"` instructs the scheduler not to schedule the pod when constraints are not satisfied.  - `\"ScheduleAnyway\"` instructs the scheduler to schedule the pod even if constraints are not satisfied.")
    public WhenUnsatisfiableEnum getWhenUnsatisfiable() {
        return this.whenUnsatisfiable;
    }

    public void setWhenUnsatisfiable(WhenUnsatisfiableEnum whenUnsatisfiable) {
        this.whenUnsatisfiable = whenUnsatisfiable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1TopologySpreadConstraint v1TopologySpreadConstraint = (V1TopologySpreadConstraint)o;
        return Objects.equals(this.labelSelector, v1TopologySpreadConstraint.labelSelector) && Objects.equals(this.maxSkew, v1TopologySpreadConstraint.maxSkew) && Objects.equals(this.topologyKey, v1TopologySpreadConstraint.topologyKey) && Objects.equals((Object)this.whenUnsatisfiable, (Object)v1TopologySpreadConstraint.whenUnsatisfiable);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.labelSelector, this.maxSkew, this.topologyKey, this.whenUnsatisfiable});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1TopologySpreadConstraint {\n");
        sb.append("    labelSelector: ").append(this.toIndentedString(this.labelSelector)).append("\n");
        sb.append("    maxSkew: ").append(this.toIndentedString(this.maxSkew)).append("\n");
        sb.append("    topologyKey: ").append(this.toIndentedString(this.topologyKey)).append("\n");
        sb.append("    whenUnsatisfiable: ").append(this.toIndentedString((Object)this.whenUnsatisfiable)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum WhenUnsatisfiableEnum {
        DONOTSCHEDULE("DoNotSchedule"),
        SCHEDULEANYWAY("ScheduleAnyway");

        private String value;

        private WhenUnsatisfiableEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static WhenUnsatisfiableEnum fromValue(String value) {
            for (WhenUnsatisfiableEnum b : WhenUnsatisfiableEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<WhenUnsatisfiableEnum> {
            public void write(JsonWriter jsonWriter, WhenUnsatisfiableEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public WhenUnsatisfiableEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return WhenUnsatisfiableEnum.fromValue(value);
            }
        }
    }
}

