/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.custom.IntOrString;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="ServicePort contains information on service's port.")
public class V1ServicePort {
    public static final String SERIALIZED_NAME_APP_PROTOCOL = "appProtocol";
    @SerializedName(value="appProtocol")
    private String appProtocol;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_NODE_PORT = "nodePort";
    @SerializedName(value="nodePort")
    private Integer nodePort;
    public static final String SERIALIZED_NAME_PORT = "port";
    @SerializedName(value="port")
    private Integer port;
    public static final String SERIALIZED_NAME_PROTOCOL = "protocol";
    @SerializedName(value="protocol")
    private ProtocolEnum protocol;
    public static final String SERIALIZED_NAME_TARGET_PORT = "targetPort";
    @SerializedName(value="targetPort")
    private IntOrString targetPort;

    public V1ServicePort appProtocol(String appProtocol) {
        this.appProtocol = appProtocol;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The application protocol for this port. This field follows standard Kubernetes label syntax. Un-prefixed names are reserved for IANA standard service names (as per RFC-6335 and http://www.iana.org/assignments/service-names). Non-standard protocols should use prefixed names such as mycompany.com/my-custom-protocol.")
    public String getAppProtocol() {
        return this.appProtocol;
    }

    public void setAppProtocol(String appProtocol) {
        this.appProtocol = appProtocol;
    }

    public V1ServicePort name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of this port within the service. This must be a DNS_LABEL. All ports within a ServiceSpec must have unique names. When considering the endpoints for a Service, this must match the 'name' field in the EndpointPort. Optional if only one ServicePort is defined on this service.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public V1ServicePort nodePort(Integer nodePort) {
        this.nodePort = nodePort;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The port on each node on which this service is exposed when type is NodePort or LoadBalancer.  Usually assigned by the system. If a value is specified, in-range, and not in use it will be used, otherwise the operation will fail.  If not specified, a port will be allocated if this Service requires one.  If this field is specified when creating a Service which does not need it, creation will fail. This field will be wiped when updating a Service to no longer need it (e.g. changing type from NodePort to ClusterIP). More info: https://kubernetes.io/docs/concepts/services-networking/service/#type-nodeport")
    public Integer getNodePort() {
        return this.nodePort;
    }

    public void setNodePort(Integer nodePort) {
        this.nodePort = nodePort;
    }

    public V1ServicePort port(Integer port) {
        this.port = port;
        return this;
    }

    @ApiModelProperty(required=true, value="The port that will be exposed by this service.")
    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public V1ServicePort protocol(ProtocolEnum protocol) {
        this.protocol = protocol;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The IP protocol for this port. Supports \"TCP\", \"UDP\", and \"SCTP\". Default is TCP.  Possible enum values:  - `\"SCTP\"` is the SCTP protocol.  - `\"TCP\"` is the TCP protocol.  - `\"UDP\"` is the UDP protocol.")
    public ProtocolEnum getProtocol() {
        return this.protocol;
    }

    public void setProtocol(ProtocolEnum protocol) {
        this.protocol = protocol;
    }

    public V1ServicePort targetPort(IntOrString targetPort) {
        this.targetPort = targetPort;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="IntOrString is a type that can hold an int32 or a string.  When used in JSON or YAML marshalling and unmarshalling, it produces or consumes the inner type.  This allows you to have, for example, a JSON field that can accept a name or number.")
    public IntOrString getTargetPort() {
        return this.targetPort;
    }

    public void setTargetPort(IntOrString targetPort) {
        this.targetPort = targetPort;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ServicePort v1ServicePort = (V1ServicePort)o;
        return Objects.equals(this.appProtocol, v1ServicePort.appProtocol) && Objects.equals(this.name, v1ServicePort.name) && Objects.equals(this.nodePort, v1ServicePort.nodePort) && Objects.equals(this.port, v1ServicePort.port) && Objects.equals((Object)this.protocol, (Object)v1ServicePort.protocol) && Objects.equals(this.targetPort, v1ServicePort.targetPort);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.appProtocol, this.name, this.nodePort, this.port, this.protocol, this.targetPort});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1ServicePort {\n");
        sb.append("    appProtocol: ").append(this.toIndentedString(this.appProtocol)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    nodePort: ").append(this.toIndentedString(this.nodePort)).append("\n");
        sb.append("    port: ").append(this.toIndentedString(this.port)).append("\n");
        sb.append("    protocol: ").append(this.toIndentedString((Object)this.protocol)).append("\n");
        sb.append("    targetPort: ").append(this.toIndentedString(this.targetPort)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ProtocolEnum {
        SCTP("SCTP"),
        TCP("TCP"),
        UDP("UDP");

        private String value;

        private ProtocolEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ProtocolEnum fromValue(String value) {
            for (ProtocolEnum b : ProtocolEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<ProtocolEnum> {
            public void write(JsonWriter jsonWriter, ProtocolEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ProtocolEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ProtocolEnum.fromValue(value);
            }
        }
    }
}

