/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;

@ApiModel(description="PodReadinessGate contains the reference to a pod condition")
public class V1PodReadinessGate {
    public static final String SERIALIZED_NAME_CONDITION_TYPE = "conditionType";
    @SerializedName(value="conditionType")
    private ConditionTypeEnum conditionType;

    public V1PodReadinessGate conditionType(ConditionTypeEnum conditionType) {
        this.conditionType = conditionType;
        return this;
    }

    @ApiModelProperty(required=true, value="ConditionType refers to a condition in the pod's condition list with matching type.  Possible enum values:  - `\"ContainersReady\"` indicates whether all containers in the pod are ready.  - `\"Initialized\"` means that all init containers in the pod have started successfully.  - `\"PodScheduled\"` represents status of the scheduling process for this pod.  - `\"Ready\"` means the pod is able to service requests and should be added to the load balancing pools of all matching services.")
    public ConditionTypeEnum getConditionType() {
        return this.conditionType;
    }

    public void setConditionType(ConditionTypeEnum conditionType) {
        this.conditionType = conditionType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1PodReadinessGate v1PodReadinessGate = (V1PodReadinessGate)o;
        return Objects.equals((Object)this.conditionType, (Object)v1PodReadinessGate.conditionType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.conditionType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1PodReadinessGate {\n");
        sb.append("    conditionType: ").append(this.toIndentedString((Object)this.conditionType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ConditionTypeEnum {
        CONTAINERSREADY("ContainersReady"),
        INITIALIZED("Initialized"),
        PODSCHEDULED("PodScheduled"),
        READY("Ready");

        private String value;

        private ConditionTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ConditionTypeEnum fromValue(String value) {
            for (ConditionTypeEnum b : ConditionTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<ConditionTypeEnum> {
            public void write(JsonWriter jsonWriter, ConditionTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ConditionTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ConditionTypeEnum.fromValue(value);
            }
        }
    }
}

