/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="NamespaceCondition contains details about state of namespace.")
public class V1NamespaceCondition {
    public static final String SERIALIZED_NAME_LAST_TRANSITION_TIME = "lastTransitionTime";
    @SerializedName(value="lastTransitionTime")
    private OffsetDateTime lastTransitionTime;
    public static final String SERIALIZED_NAME_MESSAGE = "message";
    @SerializedName(value="message")
    private String message;
    public static final String SERIALIZED_NAME_REASON = "reason";
    @SerializedName(value="reason")
    private String reason;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private String status;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private TypeEnum type;

    public V1NamespaceCondition lastTransitionTime(OffsetDateTime lastTransitionTime) {
        this.lastTransitionTime = lastTransitionTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Time is a wrapper around time.Time which supports correct marshaling to YAML and JSON.  Wrappers are provided for many of the factory methods that the time package offers.")
    public OffsetDateTime getLastTransitionTime() {
        return this.lastTransitionTime;
    }

    public void setLastTransitionTime(OffsetDateTime lastTransitionTime) {
        this.lastTransitionTime = lastTransitionTime;
    }

    public V1NamespaceCondition message(String message) {
        this.message = message;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public V1NamespaceCondition reason(String reason) {
        this.reason = reason;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public V1NamespaceCondition status(String status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(required=true, value="Status of the condition, one of True, False, Unknown.")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public V1NamespaceCondition type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="Type of namespace controller condition.  Possible enum values:  - `\"NamespaceContentRemaining\"` contains information about resources remaining in a namespace.  - `\"NamespaceDeletionContentFailure\"` contains information about namespace deleter errors during deletion of resources.  - `\"NamespaceDeletionDiscoveryFailure\"` contains information about namespace deleter errors during resource discovery.  - `\"NamespaceDeletionGroupVersionParsingFailure\"` contains information about namespace deleter errors parsing GV for legacy types.  - `\"NamespaceFinalizersRemaining\"` contains information about which finalizers are on resources remaining in a namespace.")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1NamespaceCondition v1NamespaceCondition = (V1NamespaceCondition)o;
        return Objects.equals(this.lastTransitionTime, v1NamespaceCondition.lastTransitionTime) && Objects.equals(this.message, v1NamespaceCondition.message) && Objects.equals(this.reason, v1NamespaceCondition.reason) && Objects.equals(this.status, v1NamespaceCondition.status) && Objects.equals((Object)this.type, (Object)v1NamespaceCondition.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.lastTransitionTime, this.message, this.reason, this.status, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1NamespaceCondition {\n");
        sb.append("    lastTransitionTime: ").append(this.toIndentedString(this.lastTransitionTime)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    reason: ").append(this.toIndentedString(this.reason)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        NAMESPACECONTENTREMAINING("NamespaceContentRemaining"),
        NAMESPACEDELETIONCONTENTFAILURE("NamespaceDeletionContentFailure"),
        NAMESPACEDELETIONDISCOVERYFAILURE("NamespaceDeletionDiscoveryFailure"),
        NAMESPACEDELETIONGROUPVERSIONPARSINGFAILURE("NamespaceDeletionGroupVersionParsingFailure"),
        NAMESPACEFINALIZERSREMAINING("NamespaceFinalizersRemaining");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(value);
            }
        }
    }
}

