/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="PersistentVolumeClaimVolumeSource references the user's PVC in the same namespace. This volume finds the bound PV and mounts that volume for the pod. A PersistentVolumeClaimVolumeSource is, essentially, a wrapper around another type of volume that is owned by someone else (the system).")
public class V1PersistentVolumeClaimVolumeSource {
    public static final String SERIALIZED_NAME_CLAIM_NAME = "claimName";
    @SerializedName(value="claimName")
    private String claimName;
    public static final String SERIALIZED_NAME_READ_ONLY = "readOnly";
    @SerializedName(value="readOnly")
    private Boolean readOnly;

    public V1PersistentVolumeClaimVolumeSource claimName(String claimName) {
        this.claimName = claimName;
        return this;
    }

    @ApiModelProperty(required=true, value="ClaimName is the name of a PersistentVolumeClaim in the same namespace as the pod using this volume. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims")
    public String getClaimName() {
        return this.claimName;
    }

    public void setClaimName(String claimName) {
        this.claimName = claimName;
    }

    public V1PersistentVolumeClaimVolumeSource readOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Will force the ReadOnly setting in VolumeMounts. Default false.")
    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1PersistentVolumeClaimVolumeSource v1PersistentVolumeClaimVolumeSource = (V1PersistentVolumeClaimVolumeSource)o;
        return Objects.equals(this.claimName, v1PersistentVolumeClaimVolumeSource.claimName) && Objects.equals(this.readOnly, v1PersistentVolumeClaimVolumeSource.readOnly);
    }

    public int hashCode() {
        return Objects.hash(this.claimName, this.readOnly);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1PersistentVolumeClaimVolumeSource {\n");
        sb.append("    claimName: ").append(this.toIndentedString(this.claimName)).append("\n");
        sb.append("    readOnly: ").append(this.toIndentedString(this.readOnly)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

